/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class FileUtil
extends ContextAwareBase {
    static final int BUF_SIZE = 32768;

    public FileUtil(Context context) {
        this.setContext(context);
    }

    public static URL fileToURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected exception on file [" + file + "]", e);
        }
    }

    public static boolean isParentDirectoryCreationRequired(File file) {
        File parent = file.getParentFile();
        return parent != null && !parent.exists();
    }

    public static boolean createMissingParentDirectories(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            throw new IllegalStateException(file + " should not have a null parent");
        }
        if (parent.exists()) {
            throw new IllegalStateException(file + " should not have existing parent directory");
        }
        return parent.mkdirs();
    }

    public static String prefixRelativePath(String prefix, String path) {
        if (prefix != null && !OptionHelper.isEmpty(prefix.trim()) && !new File(path).isAbsolute()) {
            path = prefix + "/" + path;
        }
        return path;
    }

    public void copy(String src, String destination) throws RolloverFailure {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int n;
            bis = new BufferedInputStream(new FileInputStream(src));
            bos = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] inbuf = new byte[32768];
            while ((n = bis.read(inbuf)) != -1) {
                ((BufferedOutputStream)bos).write(inbuf, 0, n);
            }
            bis.close();
            bis = null;
            bos.close();
            bos = null;
        }
        catch (IOException ioe) {
            String msg = "Failed to copy [" + src + "] to [" + destination + "]";
            this.addError(msg, ioe);
            throw new RolloverFailure(msg);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

