/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.android;

import ch.qos.logback.classic.android.ASaxEventRecorder;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.android.CommonPathUtil;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.Loader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class AndroidManifestPropertiesUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAndroidProperties(Context context) throws JoranException {
        ASaxEventRecorder rec = new ASaxEventRecorder();
        rec.setFilter("-");
        rec.setAttributeWatch("manifest");
        StatusManager sm = context.getStatusManager();
        InputStream stream = Loader.getClassLoaderOfObject(context).getResourceAsStream("AndroidManifest.xml");
        if (stream == null) {
            sm.add(new WarnStatus("Could not find AndroidManifest.xml", context));
            return;
        }
        try {
            rec.recordEvents(stream);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        context.putProperty("EXT_DIR", CommonPathUtil.getMountedExternalStorageDirectoryPath());
        Map<String, String> manifestAttrs = rec.getAttributeWatchValues();
        for (String key : manifestAttrs.keySet()) {
            if (key.equals("android:versionName")) {
                context.putProperty("VERSION_NAME", manifestAttrs.get(key));
                continue;
            }
            if (key.equals("android:versionCode")) {
                context.putProperty("VERSION_CODE", manifestAttrs.get(key));
                continue;
            }
            if (!key.equals("package")) continue;
            context.putProperty("PACKAGE_NAME", manifestAttrs.get(key));
        }
        String packageName = manifestAttrs.get("package");
        if (packageName != null && packageName.length() > 0) {
            context.putProperty("DATA_DIR", CommonPathUtil.getFilesDirectoryPath(packageName));
        } else {
            sm.add(new WarnStatus("Package name not found. Some properties cannot be set.", context));
        }
    }
}

