/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.StatusPrinter;
import org.slf4j.ILoggerFactory;
import org.slf4j.IMarkerFactory;
import org.slf4j.helpers.BasicMarkerFactory;
import org.slf4j.helpers.Util;
import org.slf4j.spi.MDCAdapter;
import org.slf4j.spi.SLF4JServiceProvider;

public class LoggerServiceProvider
implements SLF4JServiceProvider {
    public static String REQUESTED_API_VERSION = "2.0.7";
    private LoggerContext defaultLoggerContext;
    private IMarkerFactory markerFactory;
    private MDCAdapter mdcAdapter;

    public ILoggerFactory getLoggerFactory() {
        return this.defaultLoggerContext;
    }

    public IMarkerFactory getMarkerFactory() {
        return this.markerFactory;
    }

    public MDCAdapter getMDCAdapter() {
        return this.mdcAdapter;
    }

    public String getRequestedApiVersion() {
        return REQUESTED_API_VERSION;
    }

    public void initialize() {
        this.defaultLoggerContext = new LoggerContext();
        this.defaultLoggerContext.setName("default");
        this.initializeLoggerContext();
        this.defaultLoggerContext.start();
        this.markerFactory = new BasicMarkerFactory();
        this.mdcAdapter = new LogbackMDCAdapter();
    }

    private void initializeLoggerContext() {
        try {
            try {
                new ContextInitializer(this.defaultLoggerContext).autoConfig();
            }
            catch (JoranException joranException) {
                Util.report((String)"Failed to auto configure default logger context", (Throwable)joranException);
            }
            if (!StatusUtil.contextHasStatusListener(this.defaultLoggerContext)) {
                StatusPrinter.printInCaseOfErrorsOrWarnings(this.defaultLoggerContext);
            }
        }
        catch (Exception exception) {
            Util.report((String)("Failed to instantiate [" + LoggerContext.class.getName() + "]"), (Throwable)exception);
        }
    }
}

