/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Node;
import ch.qos.logback.core.subst.Token;
import java.util.List;

public class Parser {
    final List<Token> tokenList;
    int pointer = 0;

    public Parser(List<Token> list) {
        this.tokenList = list;
    }

    public Node parse() throws ScanException {
        if (this.tokenList == null || this.tokenList.isEmpty()) {
            return null;
        }
        return this.E();
    }

    private Node E() throws ScanException {
        Node node = this.T();
        if (node == null) {
            return null;
        }
        Node node2 = this.Eopt();
        if (node2 != null) {
            node.append(node2);
        }
        return node;
    }

    private Node Eopt() throws ScanException {
        Token token = this.peekAtCurentToken();
        if (token == null) {
            return null;
        }
        return this.E();
    }

    private Node T() throws ScanException {
        Token token = this.peekAtCurentToken();
        switch (token.type) {
            case LITERAL: {
                this.advanceTokenPointer();
                return this.makeNewLiteralNode(token.payload);
            }
            case CURLY_LEFT: {
                this.advanceTokenPointer();
                Node node = this.C();
                Token token2 = this.peekAtCurentToken();
                this.expectCurlyRight(token2);
                this.advanceTokenPointer();
                Node node2 = this.makeNewLiteralNode(CoreConstants.LEFT_ACCOLADE);
                node2.append(node);
                node2.append(this.makeNewLiteralNode(CoreConstants.RIGHT_ACCOLADE));
                return node2;
            }
            case START: {
                this.advanceTokenPointer();
                Node node = this.V();
                Token token3 = this.peekAtCurentToken();
                this.expectCurlyRight(token3);
                this.advanceTokenPointer();
                return node;
            }
        }
        return null;
    }

    private Node makeNewLiteralNode(String string) {
        return new Node(Node.Type.LITERAL, string);
    }

    private Node V() throws ScanException {
        Node node = this.E();
        Node node2 = new Node(Node.Type.VARIABLE, node);
        Token token = this.peekAtCurentToken();
        if (this.isDefaultToken(token)) {
            this.advanceTokenPointer();
            Node node3 = this.E();
            node2.defaultPart = node3;
        }
        return node2;
    }

    private Node C() throws ScanException {
        Node node = this.E();
        Token token = this.peekAtCurentToken();
        if (this.isDefaultToken(token)) {
            this.advanceTokenPointer();
            Node node2 = this.makeNewLiteralNode(":-");
            node.append(node2);
            Node node3 = this.E();
            node.append(node3);
        }
        return node;
    }

    private boolean isDefaultToken(Token token) {
        return token != null && token.type == Token.Type.DEFAULT;
    }

    void advanceTokenPointer() {
        ++this.pointer;
    }

    void expectNotNull(Token token, String string) {
        if (token == null) {
            throw new IllegalArgumentException("All tokens consumed but was expecting \"" + string + "\"");
        }
    }

    void expectCurlyRight(Token token) throws ScanException {
        this.expectNotNull(token, "}");
        if (token.type != Token.Type.CURLY_RIGHT) {
            throw new ScanException("Expecting }");
        }
    }

    Token peekAtCurentToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer);
        }
        return null;
    }
}

