/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.PeriodicityType;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class RollingCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = -5937537740925066161L;
    static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    private PeriodicityType periodicityType = PeriodicityType.ERRONEOUS;
    private String datePattern;
    private static final HashMap<Character, PeriodicityType> PATTERN_LETTER_TO_PERIODICITY = new LinkedHashMap<Character, PeriodicityType>();

    public RollingCalendar(String string) {
        this.datePattern = string;
        this.periodicityType = this.computePeriodicityType();
    }

    public RollingCalendar(String string, TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.datePattern = string;
        this.periodicityType = this.computePeriodicityType();
    }

    public PeriodicityType getPeriodicityType() {
        return this.periodicityType;
    }

    public PeriodicityType computePeriodicityType() {
        if (this.datePattern != null) {
            for (Map.Entry<Character, PeriodicityType> entry : PATTERN_LETTER_TO_PERIODICITY.entrySet()) {
                if (this.datePattern.indexOf(entry.getKey().charValue()) <= -1) continue;
                return entry.getValue();
            }
        }
        return PeriodicityType.ERRONEOUS;
    }

    public boolean isCollisionFree() {
        switch (this.periodicityType) {
            case TOP_OF_HOUR: {
                return !this.collision(43200000L);
            }
            case TOP_OF_DAY: {
                if (this.collision(604800000L)) {
                    return false;
                }
                if (this.collision(2678400000L)) {
                    return false;
                }
                return !this.collision(31536000000L);
            }
            case TOP_OF_WEEK: {
                if (this.collision(2937600000L)) {
                    return false;
                }
                return !this.collision(31622400000L);
            }
        }
        return true;
    }

    private boolean collision(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern, Locale.US);
        simpleDateFormat.setTimeZone(GMT_TIMEZONE);
        Date date = new Date(0L);
        String string = simpleDateFormat.format(date);
        Date date2 = new Date(l);
        String string2 = simpleDateFormat.format(date2);
        return string.equals(string2);
    }

    public void printPeriodicity(ContextAwareBase contextAwareBase) {
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                contextAwareBase.addInfo("Roll-over every millisecond.");
                break;
            }
            case TOP_OF_SECOND: {
                contextAwareBase.addInfo("Roll-over every second.");
                break;
            }
            case TOP_OF_MINUTE: {
                contextAwareBase.addInfo("Roll-over every minute.");
                break;
            }
            case TOP_OF_HOUR: {
                contextAwareBase.addInfo("Roll-over at the top of every hour.");
                break;
            }
            case HALF_DAY: {
                contextAwareBase.addInfo("Roll-over at midday and midnight.");
                break;
            }
            case TOP_OF_DAY: {
                contextAwareBase.addInfo("Roll-over at midnight.");
                break;
            }
            case TOP_OF_WEEK: {
                contextAwareBase.addInfo("Rollover at the start of week.");
                break;
            }
            case TOP_OF_MONTH: {
                contextAwareBase.addInfo("Rollover at start of every month.");
                break;
            }
            default: {
                contextAwareBase.addInfo("Unknown periodicity.");
            }
        }
    }

    public Date getEndOfNextNthPeriod(Date date, int n) {
        RollingCalendar rollingCalendar = this;
        rollingCalendar.setTime(date);
        this.roundDownTime(rollingCalendar, this.datePattern);
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                ((Calendar)rollingCalendar).add(14, n);
                break;
            }
            case TOP_OF_SECOND: {
                ((Calendar)rollingCalendar).add(13, n);
                break;
            }
            case TOP_OF_MINUTE: {
                ((Calendar)rollingCalendar).add(12, n);
                break;
            }
            case TOP_OF_HOUR: {
                ((Calendar)rollingCalendar).add(11, n);
                break;
            }
            case TOP_OF_DAY: {
                ((Calendar)rollingCalendar).add(5, n);
                break;
            }
            case TOP_OF_WEEK: {
                rollingCalendar.set(7, rollingCalendar.getFirstDayOfWeek());
                ((Calendar)rollingCalendar).add(3, n);
                break;
            }
            case TOP_OF_MONTH: {
                ((Calendar)rollingCalendar).add(2, n);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown periodicity type.");
            }
        }
        return rollingCalendar.getTime();
    }

    public Date getNextTriggeringDate(Date date) {
        return this.getEndOfNextNthPeriod(date, 1);
    }

    public Date normalizeDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.roundDownTime(calendar, this.datePattern);
        return calendar.getTime();
    }

    private void roundDownTime(Calendar calendar, String string) {
        Pattern pattern;
        Pattern pattern2;
        Pattern pattern3;
        if (string.indexOf(83) == -1) {
            calendar.roll(14, -calendar.get(14));
        }
        if (string.indexOf(115) == -1) {
            calendar.roll(13, -calendar.get(13));
        }
        if (string.indexOf(109) == -1) {
            calendar.roll(12, -calendar.get(12));
        }
        if (!(pattern3 = Pattern.compile("[hKkH]")).matcher(string).find()) {
            calendar.roll(11, -calendar.get(11));
        }
        if (!(pattern2 = Pattern.compile("[uEFdD]")).matcher(string).find()) {
            calendar.set(5, 1);
        }
        if (!(pattern = Pattern.compile("[MDw]")).matcher(string).find()) {
            calendar.set(2, 0);
        }
    }

    static {
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('S'), PeriodicityType.TOP_OF_MILLISECOND);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('s'), PeriodicityType.TOP_OF_SECOND);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('m'), PeriodicityType.TOP_OF_MINUTE);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('h'), PeriodicityType.TOP_OF_HOUR);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('K'), PeriodicityType.TOP_OF_HOUR);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('k'), PeriodicityType.TOP_OF_HOUR);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('H'), PeriodicityType.TOP_OF_HOUR);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('a'), PeriodicityType.HALF_DAY);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('u'), PeriodicityType.TOP_OF_DAY);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('E'), PeriodicityType.TOP_OF_DAY);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('F'), PeriodicityType.TOP_OF_DAY);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('d'), PeriodicityType.TOP_OF_DAY);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('D'), PeriodicityType.TOP_OF_DAY);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('W'), PeriodicityType.TOP_OF_WEEK);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('w'), PeriodicityType.TOP_OF_WEEK);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('M'), PeriodicityType.TOP_OF_MONTH);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('Y'), PeriodicityType.TOP_OF_WEEK);
    }
}

