/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.rolling.helper.MonoTypedConverter;

public class IntegerTokenConverter
extends DynamicConverter<Object>
implements MonoTypedConverter {
    public static final String CONVERTER_KEY = "i";

    @Override
    public String convert(int n) {
        String string = Integer.toString(n);
        FormatInfo formatInfo = this.getFormattingInfo();
        if (formatInfo == null) {
            return string;
        }
        int n2 = formatInfo.getMin();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = string.length(); i < n2; ++i) {
            stringBuilder.append('0');
        }
        return stringBuilder.append(string).toString();
    }

    @Override
    public String convert(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null argument forbidden");
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return this.convert(n);
        }
        throw new IllegalArgumentException("Cannot convert " + object + " of type" + object.getClass().getName());
    }

    @Override
    public boolean isApplicable(Object object) {
        return object instanceof Integer;
    }
}

