/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileFilterUtil {
    public static String afterLastSlash(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static File[] filesInFolderMatchingStemRegex(File file, final String string) {
        if (file == null) {
            return new File[0];
        }
        if (!file.exists() || !file.isDirectory()) {
            return new File[0];
        }
        return file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return string2.matches(string);
            }
        });
    }

    public static int findHighestCounter(File[] fileArray, String string) {
        int n = Integer.MIN_VALUE;
        for (File file : fileArray) {
            int n2 = FileFilterUtil.extractCounter(file, string);
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    public static int extractCounter(File file, String string) {
        String string2;
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(string2 = file.getName());
        if (!matcher.matches()) {
            throw new IllegalStateException("The regex [" + string + "] should match [" + string2 + "]");
        }
        String string3 = matcher.group(1);
        return Integer.valueOf(string3);
    }

    public static String slashify(String string) {
        return string.replace('\\', '/');
    }
}

