/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.net.SocketConnector;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.SocketFactory;

public class SocketConnectorBase
implements SocketConnector {
    private final Lock lock = new ReentrantLock();
    private final Condition connectCondition = this.lock.newCondition();
    private final InetAddress address;
    private final int port;
    private SocketConnector.ExceptionHandler exceptionHandler;
    private SocketFactory socketFactory;
    private DelayStrategy delayStrategy;
    private Socket socket;

    public SocketConnectorBase(InetAddress inetAddress, int n, int n2, int n3) {
        this(inetAddress, n, new FixedDelay(n2, n3));
    }

    public SocketConnectorBase(InetAddress inetAddress, int n, DelayStrategy delayStrategy) {
        this.address = inetAddress;
        this.port = n;
        this.delayStrategy = delayStrategy;
    }

    public void run() {
        if (this.socket != null) {
            throw new IllegalStateException("connector cannot be reused");
        }
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new ConsoleExceptionHandler();
        }
        if (this.socketFactory == null) {
            this.socketFactory = SocketFactory.getDefault();
        }
        try {
            while (!Thread.currentThread().isInterrupted()) {
                Thread.sleep(this.delayStrategy.nextDelay());
                try {
                    this.socket = this.socketFactory.createSocket(this.address, this.port);
                    this.signalConnected();
                    break;
                }
                catch (Exception exception) {
                    this.exceptionHandler.connectionFailed(this, exception);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.exceptionHandler.connectionFailed(this, interruptedException);
        }
    }

    private void signalConnected() {
        this.lock.lock();
        try {
            this.connectCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Socket awaitConnection() throws InterruptedException {
        return this.awaitConnection(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket awaitConnection(long l) throws InterruptedException {
        this.lock.lock();
        try {
            boolean bl = false;
            while (this.socket == null && !bl) {
                bl = !this.connectCondition.await(l, TimeUnit.MILLISECONDS);
            }
            Socket socket = this.socket;
            return socket;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setExceptionHandler(SocketConnector.ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    @Override
    public Socket call() throws InterruptedException {
        return null;
    }

    private static class FixedDelay
    implements DelayStrategy {
        private final int retryDelay;
        private int nextDelay;

        public FixedDelay(int n, int n2) {
            this.nextDelay = n;
            this.retryDelay = n2;
        }

        @Override
        public int nextDelay() {
            int n = this.nextDelay;
            this.nextDelay = this.retryDelay;
            return n;
        }
    }

    private static class ConsoleExceptionHandler
    implements SocketConnector.ExceptionHandler {
        private ConsoleExceptionHandler() {
        }

        @Override
        public void connectionFailed(SocketConnector socketConnector, Exception exception) {
            System.out.println(exception);
        }
    }

    public static interface DelayStrategy {
        public int nextDelay();
    }
}

