/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.net.LoginAuthenticator;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.sift.DefaultDiscriminator;
import ch.qos.logback.core.sift.Discriminator;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import ch.qos.logback.core.util.ContentTypeUtil;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public abstract class SMTPAppenderBase<E>
extends AppenderBase<E> {
    static InternetAddress[] EMPTY_IA_ARRAY = new InternetAddress[0];
    static final long MAX_DELAY_BETWEEN_STATUS_MESSAGES = 1228800000L;
    long lastTrackerStatusPrint = 0L;
    long delayBetweenStatusMessages = 300000L;
    protected Layout<E> subjectLayout;
    protected Layout<E> layout;
    private List<PatternLayoutBase<E>> toPatternLayoutList = new ArrayList<PatternLayoutBase<E>>();
    private String from;
    private String subjectStr = null;
    private String smtpHost;
    private int smtpPort = 25;
    private boolean starttls = false;
    private boolean ssl = false;
    String username;
    String password;
    String localhost;
    boolean asynchronousSending = true;
    private String charsetEncoding = "UTF-8";
    protected Session session;
    protected EventEvaluator<E> eventEvaluator;
    protected Discriminator<E> discriminator = new DefaultDiscriminator();
    protected CyclicBufferTracker<E> cbTracker;
    private int errorCount = 0;

    protected abstract Layout<E> makeSubjectLayout(String var1);

    @Override
    public void start() {
        if (this.cbTracker == null) {
            this.cbTracker = new CyclicBufferTracker();
        }
        this.session = this.buildSessionFromProperties();
        if (this.session == null) {
            this.addError("Failed to obtain javax.mail.Session. Cannot start.");
            return;
        }
        this.subjectLayout = this.makeSubjectLayout(this.subjectStr);
        this.started = true;
    }

    private Session buildSessionFromProperties() {
        Properties properties = new Properties(OptionHelper.getSystemProperties());
        if (this.smtpHost != null) {
            properties.put("mail.smtp.host", this.smtpHost);
        }
        properties.put("mail.smtp.port", Integer.toString(this.smtpPort));
        if (this.localhost != null) {
            properties.put("mail.smtp.localhost", this.localhost);
        }
        LoginAuthenticator loginAuthenticator = null;
        if (this.username != null) {
            loginAuthenticator = new LoginAuthenticator(this.username, this.password);
            properties.put("mail.smtp.auth", "true");
        }
        if (this.isSTARTTLS() && this.isSSL()) {
            this.addError("Both SSL and StartTLS cannot be enabled simultaneously");
        } else {
            if (this.isSTARTTLS()) {
                properties.put("mail.smtp.starttls.enable", "true");
                properties.put("mail.transport.protocol", "true");
            }
            if (this.isSSL()) {
                properties.put("mail.smtp.ssl.enable", "true");
            }
        }
        return Session.getInstance((Properties)properties, (Authenticator)loginAuthenticator);
    }

    @Override
    protected void append(E e) {
        long l;
        String string;
        block9: {
            if (!this.checkEntryConditions()) {
                return;
            }
            string = this.discriminator.getDiscriminatingValue(e);
            l = System.currentTimeMillis();
            CyclicBuffer cyclicBuffer = (CyclicBuffer)this.cbTracker.getOrCreate(string, l);
            this.subAppend(cyclicBuffer, e);
            try {
                if (this.eventEvaluator.evaluate(e)) {
                    CyclicBuffer cyclicBuffer2 = new CyclicBuffer(cyclicBuffer);
                    cyclicBuffer.clear();
                    if (this.asynchronousSending) {
                        SenderRunnable senderRunnable = new SenderRunnable(cyclicBuffer2, e);
                        this.context.getScheduledExecutorService().execute(senderRunnable);
                    } else {
                        this.sendBuffer(cyclicBuffer2, e);
                    }
                }
            }
            catch (EvaluationException evaluationException) {
                ++this.errorCount;
                if (this.errorCount >= 4) break block9;
                this.addError("SMTPAppender's EventEvaluator threw an Exception-", evaluationException);
            }
        }
        if (this.eventMarksEndOfLife(e)) {
            this.cbTracker.endOfLife(string);
        }
        this.cbTracker.removeStaleComponents(l);
        if (this.lastTrackerStatusPrint + this.delayBetweenStatusMessages < l) {
            this.addInfo("SMTPAppender [" + this.name + "] is tracking [" + this.cbTracker.getComponentCount() + "] buffers");
            this.lastTrackerStatusPrint = l;
            if (this.delayBetweenStatusMessages < 1228800000L) {
                this.delayBetweenStatusMessages *= 4L;
            }
        }
    }

    protected abstract boolean eventMarksEndOfLife(E var1);

    protected abstract void subAppend(CyclicBuffer<E> var1, E var2);

    public boolean checkEntryConditions() {
        if (!this.started) {
            this.addError("Attempting to append to a non-started appender: " + this.getName());
            return false;
        }
        if (this.eventEvaluator == null) {
            this.addError("No EventEvaluator is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.addError("No layout set for appender named [" + this.name + "]. For more information, please visit http://logback.qos.ch/codes.html#smtp_no_layout");
            return false;
        }
        return true;
    }

    @Override
    public synchronized void stop() {
        this.started = false;
    }

    InternetAddress getAddress(String string) {
        try {
            return new InternetAddress(string);
        }
        catch (AddressException addressException) {
            this.addError("Could not parse address [" + string + "].", addressException);
            return null;
        }
    }

    private List<InternetAddress> parseAddress(E e) {
        int n = this.toPatternLayoutList.size();
        ArrayList<InternetAddress> arrayList = new ArrayList<InternetAddress>();
        for (int i = 0; i < n; ++i) {
            try {
                PatternLayoutBase<E> patternLayoutBase = this.toPatternLayoutList.get(i);
                String string = patternLayoutBase.doLayout(e);
                if (string == null || string.length() == 0) continue;
                InternetAddress[] internetAddressArray = InternetAddress.parse((String)string, (boolean)true);
                arrayList.addAll(Arrays.asList(internetAddressArray));
                continue;
            }
            catch (AddressException addressException) {
                this.addError("Could not parse email address for [" + this.toPatternLayoutList.get(i) + "] for event [" + e + "]", addressException);
                return arrayList;
            }
        }
        return arrayList;
    }

    public List<PatternLayoutBase<E>> getToList() {
        return this.toPatternLayoutList;
    }

    protected void updateMimeMsg(MimeMessage mimeMessage, CyclicBuffer<E> cyclicBuffer, E e) {
    }

    protected void sendBuffer(CyclicBuffer<E> cyclicBuffer, E e) {
        try {
            String string;
            String string2;
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = this.layout.getFileHeader();
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            if ((string2 = this.layout.getPresentationHeader()) != null) {
                stringBuffer.append(string2);
            }
            this.fillBuffer(cyclicBuffer, stringBuffer);
            String string4 = this.layout.getPresentationFooter();
            if (string4 != null) {
                stringBuffer.append(string4);
            }
            if ((string = this.layout.getFileFooter()) != null) {
                stringBuffer.append(string);
            }
            String string5 = "Undefined subject";
            if (this.subjectLayout != null) {
                int n;
                string5 = this.subjectLayout.doLayout(e);
                int n2 = n = string5 != null ? string5.indexOf(10) : -1;
                if (n > -1) {
                    string5 = string5.substring(0, n);
                }
            }
            MimeMessage mimeMessage = new MimeMessage(this.session);
            if (this.from != null) {
                mimeMessage.setFrom((Address)this.getAddress(this.from));
            } else {
                mimeMessage.setFrom();
            }
            mimeMessage.setSubject(string5, this.charsetEncoding);
            List<InternetAddress> list = this.parseAddress(e);
            if (list.isEmpty()) {
                this.addInfo("Empty destination address. Aborting email transmission");
                return;
            }
            Object[] objectArray = list.toArray(EMPTY_IA_ARRAY);
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])objectArray);
            String string6 = this.layout.getContentType();
            if (ContentTypeUtil.isTextual(string6)) {
                mimeBodyPart.setText(stringBuffer.toString(), this.charsetEncoding, ContentTypeUtil.getSubType(string6));
            } else {
                mimeBodyPart.setContent((Object)stringBuffer.toString(), this.layout.getContentType());
            }
            MimeMultipart mimeMultipart = new MimeMultipart();
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            mimeMessage.setContent((Multipart)mimeMultipart);
            this.updateMimeMsg(mimeMessage, cyclicBuffer, e);
            mimeMessage.setSentDate(new Date());
            this.addInfo("About to send out SMTP message \"" + string5 + "\" to " + Arrays.toString(objectArray));
            Transport.send((Message)mimeMessage);
        }
        catch (Exception exception) {
            this.addError("Error occurred while sending e-mail notification.", exception);
        }
    }

    protected abstract void fillBuffer(CyclicBuffer<E> var1, StringBuffer var2);

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subjectStr;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public void setSubject(String string) {
        this.subjectStr = string;
    }

    public void setSMTPHost(String string) {
        this.setSmtpHost(string);
    }

    public void setSmtpHost(String string) {
        this.smtpHost = string;
    }

    public String getSMTPHost() {
        return this.getSmtpHost();
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSMTPPort(int n) {
        this.setSmtpPort(n);
    }

    public void setSmtpPort(int n) {
        this.smtpPort = n;
    }

    public int getSMTPPort() {
        return this.getSmtpPort();
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public String getLocalhost() {
        return this.localhost;
    }

    public void setLocalhost(String string) {
        this.localhost = string;
    }

    public CyclicBufferTracker<E> getCyclicBufferTracker() {
        return this.cbTracker;
    }

    public void setCyclicBufferTracker(CyclicBufferTracker<E> cyclicBufferTracker) {
        this.cbTracker = cyclicBufferTracker;
    }

    public Discriminator<E> getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(Discriminator<E> discriminator) {
        this.discriminator = discriminator;
    }

    public boolean isAsynchronousSending() {
        return this.asynchronousSending;
    }

    public void setAsynchronousSending(boolean bl) {
        this.asynchronousSending = bl;
    }

    public void addTo(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Null or empty <to> property");
        }
        PatternLayoutBase<E> patternLayoutBase = this.makeNewToPatternLayout(string.trim());
        patternLayoutBase.setContext(this.context);
        patternLayoutBase.start();
        this.toPatternLayoutList.add(patternLayoutBase);
    }

    protected abstract PatternLayoutBase<E> makeNewToPatternLayout(String var1);

    public List<String> getToAsListOfString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PatternLayoutBase<E> patternLayoutBase : this.toPatternLayoutList) {
            arrayList.add(patternLayoutBase.getPattern());
        }
        return arrayList;
    }

    public boolean isSTARTTLS() {
        return this.starttls;
    }

    public void setSTARTTLS(boolean bl) {
        this.starttls = bl;
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public void setSSL(boolean bl) {
        this.ssl = bl;
    }

    public void setEvaluator(EventEvaluator<E> eventEvaluator) {
        this.eventEvaluator = eventEvaluator;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public void setCharsetEncoding(String string) {
        this.charsetEncoding = string;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }

    class SenderRunnable
    implements Runnable {
        final CyclicBuffer<E> cyclicBuffer;
        final E e;

        SenderRunnable(CyclicBuffer<E> cyclicBuffer, E e) {
            this.cyclicBuffer = cyclicBuffer;
            this.e = e;
        }

        @Override
        public void run() {
            SMTPAppenderBase.this.sendBuffer(this.cyclicBuffer, this.e);
        }
    }
}

