/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.util.DelayStrategy;
import ch.qos.logback.core.util.FixedDelay;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;

public class DefaultSocketConnector
implements SocketConnector {
    private final InetAddress address;
    private final int port;
    private final DelayStrategy delayStrategy;
    private SocketConnector.ExceptionHandler exceptionHandler;
    private SocketFactory socketFactory;

    public DefaultSocketConnector(InetAddress inetAddress, int n, long l, long l2) {
        this(inetAddress, n, new FixedDelay(l, l2));
    }

    public DefaultSocketConnector(InetAddress inetAddress, int n, DelayStrategy delayStrategy) {
        this.address = inetAddress;
        this.port = n;
        this.delayStrategy = delayStrategy;
    }

    @Override
    public Socket call() throws InterruptedException {
        this.useDefaultsForMissingFields();
        Socket socket = this.createSocket();
        while (socket == null && !Thread.currentThread().isInterrupted()) {
            Thread.sleep(this.delayStrategy.nextDelay());
            socket = this.createSocket();
        }
        return socket;
    }

    private Socket createSocket() {
        Socket socket = null;
        try {
            socket = this.socketFactory.createSocket(this.address, this.port);
        }
        catch (IOException iOException) {
            this.exceptionHandler.connectionFailed(this, iOException);
        }
        return socket;
    }

    private void useDefaultsForMissingFields() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new ConsoleExceptionHandler();
        }
        if (this.socketFactory == null) {
            this.socketFactory = SocketFactory.getDefault();
        }
    }

    @Override
    public void setExceptionHandler(SocketConnector.ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    private static class ConsoleExceptionHandler
    implements SocketConnector.ExceptionHandler {
        private ConsoleExceptionHandler() {
        }

        @Override
        public void connectionFailed(SocketConnector socketConnector, Exception exception) {
            System.out.println(exception);
        }
    }
}

