/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.net.URL;

public class ConfigurationWatchListUtil {
    static final ConfigurationWatchListUtil origin = new ConfigurationWatchListUtil();

    private ConfigurationWatchListUtil() {
    }

    public static void registerConfigurationWatchList(Context context, ConfigurationWatchList configurationWatchList) {
        context.putObject("CONFIGURATION_WATCH_LIST", configurationWatchList);
    }

    public static void setMainWatchURL(Context context, URL uRL) {
        if (context == null) {
            return;
        }
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList(context);
        if (configurationWatchList == null) {
            configurationWatchList = new ConfigurationWatchList();
            configurationWatchList.setContext(context);
            context.putObject("CONFIGURATION_WATCH_LIST", configurationWatchList);
        } else {
            configurationWatchList.clear();
        }
        configurationWatchList.setMainURL(uRL);
    }

    public static URL getMainWatchURL(Context context) {
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList(context);
        if (configurationWatchList == null) {
            return null;
        }
        return configurationWatchList.getMainURL();
    }

    public static void addToWatchList(Context context, URL uRL) {
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList(context);
        if (configurationWatchList == null) {
            ConfigurationWatchListUtil.addWarn(context, "Null ConfigurationWatchList. Cannot add " + uRL);
        } else {
            ConfigurationWatchListUtil.addInfo(context, "Adding [" + uRL + "] to configuration watch list.");
            configurationWatchList.addToWatchList(uRL);
        }
    }

    public static ConfigurationWatchList getConfigurationWatchList(Context context) {
        if (context == null) {
            return null;
        }
        return (ConfigurationWatchList)context.getObject("CONFIGURATION_WATCH_LIST");
    }

    static void addStatus(Context context, Status status) {
        if (context == null) {
            System.out.println("Null context in " + ConfigurationWatchList.class.getName());
            return;
        }
        StatusManager statusManager = context.getStatusManager();
        if (statusManager == null) {
            return;
        }
        statusManager.add(status);
    }

    static void addInfo(Context context, String string) {
        ConfigurationWatchListUtil.addStatus(context, new InfoStatus(string, origin));
    }

    static void addWarn(Context context, String string) {
        ConfigurationWatchListUtil.addStatus(context, new WarnStatus(string, origin));
    }
}

