/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.event;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.EndEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareImpl;
import ch.qos.logback.core.status.Status;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.sax2.Driver;

public class SaxEventRecorder
extends DefaultHandler
implements ContextAware {
    private final ContextAwareImpl cai;
    private List<SaxEvent> saxEventList = new ArrayList<SaxEvent>();
    private Locator locator;
    ElementPath globalElementPath = new ElementPath();

    public SaxEventRecorder() {
        this.cai = new ContextAwareImpl(null, this);
    }

    public SaxEventRecorder(Context context) {
        this.cai = new ContextAwareImpl(context, this);
    }

    public final void recordEvents(InputStream inputStream) throws JoranException {
        this.recordEvents(new InputSource(inputStream));
    }

    public List<SaxEvent> recordEvents(InputSource inputSource) throws JoranException {
        Driver driver = this.buildPullParser();
        try {
            driver.setContentHandler((ContentHandler)this);
            driver.setErrorHandler((ErrorHandler)this);
            driver.parse(inputSource);
            return this.saxEventList;
        }
        catch (EOFException eOFException) {
            this.handleError(eOFException.getLocalizedMessage(), new SAXParseException(eOFException.getLocalizedMessage(), this.locator, eOFException));
        }
        catch (IOException iOException) {
            this.handleError("I/O error occurred while parsing xml file", iOException);
        }
        catch (SAXException sAXException) {
            throw new JoranException("Problem parsing XML document. See previously reported errors.", sAXException);
        }
        catch (Exception exception) {
            this.handleError("Unexpected exception while parsing XML document.", exception);
        }
        throw new IllegalStateException("This point can never be reached");
    }

    private void handleError(String string, Throwable throwable) throws JoranException {
        this.addError(string, throwable);
        throw new JoranException(string, throwable);
    }

    private Driver buildPullParser() throws JoranException {
        try {
            Driver driver = new Driver();
            try {
                driver.setFeature("http://xml.org/sax/features/validation", false);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            driver.setFeature("http://xml.org/sax/features/namespaces", true);
            return driver;
        }
        catch (Exception exception) {
            String string = "Parser configuration error occurred";
            this.addError(string, exception);
            throw new JoranException(string, exception);
        }
    }

    @Override
    public void startDocument() {
    }

    public Locator getLocator() {
        return this.locator;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        String string4 = string3 == null || string3.length() == 0 ? string2 : string3;
        String string5 = this.getTagName(string2, string4);
        this.globalElementPath.push(string5);
        ElementPath elementPath = this.globalElementPath.duplicate();
        this.saxEventList.add(new StartEvent(elementPath, string, string2, string4, attributes, this.getLocator()));
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        SaxEvent saxEvent = this.getLastEvent();
        if (saxEvent instanceof BodyEvent) {
            BodyEvent bodyEvent = (BodyEvent)saxEvent;
            bodyEvent.append(string);
        } else if (!this.isSpaceOnly(string)) {
            this.saxEventList.add(new BodyEvent(string, this.getLocator()));
        }
    }

    boolean isSpaceOnly(String string) {
        String string2 = string.trim();
        return string2.length() == 0;
    }

    SaxEvent getLastEvent() {
        if (this.saxEventList.isEmpty()) {
            return null;
        }
        int n = this.saxEventList.size();
        return this.saxEventList.get(n - 1);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        String string4 = string3 == null || string3.length() == 0 ? string2 : string3;
        this.saxEventList.add(new EndEvent(string, string2, string4, this.getLocator()));
        this.globalElementPath.pop();
    }

    String getTagName(String string, String string2) {
        String string3 = string;
        if (string3 == null || string3.length() < 1) {
            string3 = string2;
        }
        return string3;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.addError("XML_PARSING - Parsing error on line " + sAXParseException.getLineNumber() + " and column " + sAXParseException.getColumnNumber(), sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.addError("XML_PARSING - Parsing fatal error on line " + sAXParseException.getLineNumber() + " and column " + sAXParseException.getColumnNumber(), sAXParseException);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.addWarn("XML_PARSING - Parsing warning on line " + sAXParseException.getLineNumber() + " and column " + sAXParseException.getColumnNumber(), sAXParseException);
    }

    @Override
    public void addError(String string) {
        this.cai.addError(string);
    }

    @Override
    public void addError(String string, Throwable throwable) {
        this.cai.addError(string, throwable);
    }

    @Override
    public void addInfo(String string) {
        this.cai.addInfo(string);
    }

    @Override
    public void addInfo(String string, Throwable throwable) {
        this.cai.addInfo(string, throwable);
    }

    @Override
    public void addStatus(Status status) {
        this.cai.addStatus(status);
    }

    @Override
    public void addWarn(String string) {
        this.cai.addWarn(string);
    }

    @Override
    public void addWarn(String string, Throwable throwable) {
        this.cai.addWarn(string, throwable);
    }

    @Override
    public Context getContext() {
        return this.cai.getContext();
    }

    @Override
    public void setContext(Context context) {
        this.cai.setContext(context);
    }

    public List<SaxEvent> getSaxEventList() {
        return this.saxEventList;
    }
}

