/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.pattern.ClassNameOnlyAbbreviator;
import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import ch.qos.logback.classic.spi.ILoggingEvent;

public abstract class NamedConverter
extends ClassicConverter {
    Abbreviator abbreviator = null;

    protected abstract String getFullyQualifiedName(ILoggingEvent var1);

    @Override
    public void start() {
        String string = this.getFirstOption();
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (n == 0) {
                    this.abbreviator = new ClassNameOnlyAbbreviator();
                } else if (n > 0) {
                    this.abbreviator = new TargetLengthBasedClassNameAbbreviator(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public String convert(ILoggingEvent iLoggingEvent) {
        String string = this.getFullyQualifiedName(iLoggingEvent);
        if (this.abbreviator == null) {
            return string;
        }
        return this.abbreviator.abbreviate(string);
    }
}

