/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.FilenameParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DateParser
implements FilenameParser<Date> {
    private final SimpleDateFormat dateFormatter;
    private final Pattern pathPattern;

    DateParser(FileNamePattern fileNamePattern) {
        this.dateFormatter = this.getDateFormatter(fileNamePattern);
        String string = fileNamePattern.toRegex(true, false);
        this.pathPattern = Pattern.compile(string);
    }

    Date parseDate(String string) throws ParseException {
        return this.dateFormatter.parse(string);
    }

    @Override
    public Date parseFilename(String string) {
        Date date = null;
        try {
            date = this.parseDate(this.findToken(string));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    private String findToken(String string) {
        Matcher matcher = this.pathPattern.matcher(string);
        return matcher.find() && matcher.groupCount() >= 1 ? matcher.group(1) : "";
    }

    private SimpleDateFormat getDateFormatter(FileNamePattern fileNamePattern) {
        TimeZone timeZone;
        DateTokenConverter<Object> dateTokenConverter = fileNamePattern.getPrimaryDateTokenConverter();
        String string = dateTokenConverter != null ? dateTokenConverter.getDatePattern() : "yyyy-MM-dd";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.US);
        TimeZone timeZone2 = timeZone = dateTokenConverter != null ? dateTokenConverter.getTimeZone() : TimeZone.getDefault();
        if (timeZone != null) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        return simpleDateFormat;
    }
}

