/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.PackagingDataCalculator;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableProxy
implements IThrowableProxy {
    private Throwable throwable;
    private String className;
    private String message;
    StackTraceElementProxy[] stackTraceElementProxyArray;
    int commonFrames;
    private ThrowableProxy cause;
    private ThrowableProxy[] suppressed = NO_SUPPRESSED;
    private transient PackagingDataCalculator packagingDataCalculator;
    private boolean calculatedPackageData = false;
    private static final Method GET_SUPPRESSED_METHOD;
    private static final ThrowableProxy[] NO_SUPPRESSED;
    private static final StackTraceElementProxy[] NO_STACK_TRACE;

    public ThrowableProxy(Throwable throwable) {
        this(throwable, Collections.newSetFromMap(new IdentityHashMap(1)));
    }

    private ThrowableProxy(Throwable throwable, Set<Throwable> set) {
        this.throwable = throwable;
        this.className = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.stackTraceElementProxyArray = ThrowableProxyUtil.steArrayToStepArray(throwable.getStackTrace());
        if (set.contains(throwable)) {
            this.className = "CIRCULAR REFERENCE:" + throwable.getClass().getName();
            this.stackTraceElementProxyArray = NO_STACK_TRACE;
        } else {
            set.add(throwable);
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                this.cause = new ThrowableProxy(throwable2, set);
                this.cause.commonFrames = ThrowableProxyUtil.findNumberOfCommonFrames(throwable2.getStackTrace(), this.stackTraceElementProxyArray);
            }
            if (GET_SUPPRESSED_METHOD != null) {
                try {
                    Throwable[] throwableArray;
                    Object object = GET_SUPPRESSED_METHOD.invoke((Object)throwable, new Object[0]);
                    if (object instanceof Throwable[] && (throwableArray = (Throwable[])object).length > 0) {
                        this.suppressed = new ThrowableProxy[throwableArray.length];
                        for (int i = 0; i < throwableArray.length; ++i) {
                            this.suppressed[i] = new ThrowableProxy(throwableArray[i], set);
                            this.suppressed[i].commonFrames = ThrowableProxyUtil.findNumberOfCommonFrames(throwableArray[i].getStackTrace(), this.stackTraceElementProxyArray);
                        }
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StackTraceElementProxy[] getStackTraceElementProxyArray() {
        return this.stackTraceElementProxyArray;
    }

    @Override
    public int getCommonFrames() {
        return this.commonFrames;
    }

    @Override
    public IThrowableProxy getCause() {
        return this.cause;
    }

    @Override
    public IThrowableProxy[] getSuppressed() {
        return this.suppressed;
    }

    public PackagingDataCalculator getPackagingDataCalculator() {
        if (this.throwable != null && this.packagingDataCalculator == null) {
            this.packagingDataCalculator = new PackagingDataCalculator();
        }
        return this.packagingDataCalculator;
    }

    public void calculatePackagingData() {
        if (this.calculatedPackageData) {
            return;
        }
        PackagingDataCalculator packagingDataCalculator = this.getPackagingDataCalculator();
        if (packagingDataCalculator != null) {
            this.calculatedPackageData = true;
            packagingDataCalculator.calculate(this);
        }
    }

    public void fullDump() {
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElementProxy stackTraceElementProxy : this.stackTraceElementProxyArray) {
            String string = stackTraceElementProxy.toString();
            stringBuilder.append('\t').append(string);
            ThrowableProxyUtil.subjoinPackagingData(stringBuilder, stackTraceElementProxy);
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        }
        System.out.println(stringBuilder.toString());
    }

    static {
        Method method = null;
        try {
            method = Throwable.class.getMethod("getSuppressed", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        GET_SUPPRESSED_METHOD = method;
        NO_SUPPRESSED = new ThrowableProxy[0];
        NO_STACK_TRACE = new StackTraceElementProxy[0];
    }
}

