/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.EncoderBase;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutWrappingEncoder<E>
extends EncoderBase<E> {
    protected Layout<E> layout;
    private Charset charset;
    private boolean immediateFlush = true;

    public void setImmediateFlush(boolean bl) {
        this.immediateFlush = bl;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public byte[] headerBytes() {
        if (this.layout == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendIfNotNull(stringBuilder, this.layout.getFileHeader());
        this.appendIfNotNull(stringBuilder, this.layout.getPresentationHeader());
        if (stringBuilder.length() > 0) {
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        }
        return this.convertToBytes(stringBuilder.toString());
    }

    @Override
    public byte[] footerBytes() {
        if (this.layout == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendIfNotNull(stringBuilder, this.layout.getPresentationFooter());
        this.appendIfNotNull(stringBuilder, this.layout.getFileFooter());
        return this.convertToBytes(stringBuilder.toString());
    }

    private byte[] convertToBytes(String string) {
        if (this.charset == null) {
            return string.getBytes();
        }
        return string.getBytes(this.charset);
    }

    @Override
    public byte[] encode(E e) {
        String string = this.layout.doLayout(e);
        return this.convertToBytes(string);
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
    }

    private void appendIfNotNull(StringBuilder stringBuilder, String string) {
        if (string != null) {
            stringBuilder.append(string);
        }
    }
}

