/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.PeriodicityType;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class RollingCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = -5937537740925066161L;
    static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    PeriodicityType periodicityType = PeriodicityType.ERRONEOUS;
    String datePattern;

    public RollingCalendar(String string) {
        this.datePattern = string;
        this.periodicityType = this.computePeriodicityType();
    }

    public RollingCalendar(String string, TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.datePattern = string;
        this.periodicityType = this.computePeriodicityType();
    }

    public PeriodicityType getPeriodicityType() {
        return this.periodicityType;
    }

    public PeriodicityType computePeriodicityType() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(GMT_TIMEZONE, Locale.US);
        Date date = new Date(0L);
        if (this.datePattern != null) {
            for (PeriodicityType periodicityType : PeriodicityType.VALID_ORDERED_LIST) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern, Locale.US);
                simpleDateFormat.setTimeZone(GMT_TIMEZONE);
                String string = simpleDateFormat.format(date);
                Date date2 = RollingCalendar.innerGetEndOfThisPeriod(gregorianCalendar, periodicityType, date);
                String string2 = simpleDateFormat.format(date2);
                if (string == null || string2 == null || string.equals(string2)) continue;
                return periodicityType;
            }
        }
        return PeriodicityType.ERRONEOUS;
    }

    public boolean isCollisionFree() {
        switch (this.periodicityType) {
            case TOP_OF_HOUR: {
                return !this.collision(43200000L);
            }
            case TOP_OF_DAY: {
                if (this.collision(604800000L)) {
                    return false;
                }
                if (this.collision(2678400000L)) {
                    return false;
                }
                return !this.collision(31536000000L);
            }
            case TOP_OF_WEEK: {
                if (this.collision(2937600000L)) {
                    return false;
                }
                return !this.collision(31622400000L);
            }
        }
        return true;
    }

    private boolean collision(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern, Locale.US);
        simpleDateFormat.setTimeZone(GMT_TIMEZONE);
        Date date = new Date(0L);
        String string = simpleDateFormat.format(date);
        Date date2 = new Date(l);
        String string2 = simpleDateFormat.format(date2);
        return string.equals(string2);
    }

    public void printPeriodicity(ContextAwareBase contextAwareBase) {
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                contextAwareBase.addInfo("Roll-over every millisecond.");
                break;
            }
            case TOP_OF_SECOND: {
                contextAwareBase.addInfo("Roll-over every second.");
                break;
            }
            case TOP_OF_MINUTE: {
                contextAwareBase.addInfo("Roll-over every minute.");
                break;
            }
            case TOP_OF_HOUR: {
                contextAwareBase.addInfo("Roll-over at the top of every hour.");
                break;
            }
            case HALF_DAY: {
                contextAwareBase.addInfo("Roll-over at midday and midnight.");
                break;
            }
            case TOP_OF_DAY: {
                contextAwareBase.addInfo("Roll-over at midnight.");
                break;
            }
            case TOP_OF_WEEK: {
                contextAwareBase.addInfo("Rollover at the start of week.");
                break;
            }
            case TOP_OF_MONTH: {
                contextAwareBase.addInfo("Rollover at start of every month.");
                break;
            }
            default: {
                contextAwareBase.addInfo("Unknown periodicity.");
            }
        }
    }

    public long periodBarriersCrossed(long l, long l2) {
        if (l > l2) {
            throw new IllegalArgumentException("Start cannot come before end");
        }
        Date date = this.getsStartOfCurrentPeriod(l);
        Date date2 = this.getsStartOfCurrentPeriod(l2);
        long l3 = date2.getTime() - date.getTime();
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                return l3;
            }
            case TOP_OF_SECOND: {
                return l3 / 1000L;
            }
            case TOP_OF_MINUTE: {
                return l3 / 60000L;
            }
            case TOP_OF_HOUR: {
                return (long)((int)l3) / 3600000L;
            }
            case TOP_OF_DAY: {
                return l3 / 86400000L;
            }
            case TOP_OF_WEEK: {
                return l3 / 604800000L;
            }
            case TOP_OF_MONTH: {
                return RollingCalendar.diffInMonths(l, l2);
            }
        }
        throw new IllegalStateException("Unknown periodicity type.");
    }

    public static int diffInMonths(long l, long l2) {
        if (l > l2) {
            throw new IllegalArgumentException("startTime cannot be larger than endTime");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(l2);
        int n = calendar2.get(1) - calendar.get(1);
        int n2 = calendar2.get(2) - calendar.get(2);
        return n * 12 + n2;
    }

    private static Date innerGetEndOfThisPeriod(Calendar calendar, PeriodicityType periodicityType, Date date) {
        return RollingCalendar.innerGetEndOfNextNthPeriod(calendar, periodicityType, date, 1);
    }

    private static Date innerGetEndOfNextNthPeriod(Calendar calendar, PeriodicityType periodicityType, Date date, int n) {
        calendar.setTime(date);
        switch (periodicityType) {
            case TOP_OF_MILLISECOND: {
                calendar.add(14, n);
                break;
            }
            case TOP_OF_SECOND: {
                calendar.set(14, 0);
                calendar.add(13, n);
                break;
            }
            case TOP_OF_MINUTE: {
                calendar.set(13, 0);
                calendar.set(14, 0);
                calendar.add(12, n);
                break;
            }
            case TOP_OF_HOUR: {
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                calendar.add(11, n);
                break;
            }
            case TOP_OF_DAY: {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                calendar.add(5, n);
                break;
            }
            case TOP_OF_WEEK: {
                calendar.set(7, calendar.getFirstDayOfWeek());
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                calendar.add(3, n);
                break;
            }
            case TOP_OF_MONTH: {
                calendar.set(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                calendar.add(2, n);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown periodicity type.");
            }
        }
        return calendar.getTime();
    }

    public Date getEndOfNextNthPeriod(Date date, int n) {
        return RollingCalendar.innerGetEndOfNextNthPeriod(this, this.periodicityType, date, n);
    }

    public Date getNextTriggeringDate(Date date) {
        return this.getEndOfNextNthPeriod(date, 1);
    }

    public Date getsStartOfCurrentPeriod(long l) {
        Calendar calendar = Calendar.getInstance(this.getTimeZone());
        calendar.setTimeInMillis(l);
        return this.getEndOfNextNthPeriod(calendar.getTime(), 0);
    }
}

