/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.spi.MDCAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogbackMDCAdapter
implements MDCAdapter {
    final InheritableThreadLocal<Map<String, String>> copyOnInheritThreadLocal = new InheritableThreadLocal();
    private static final int WRITE_OPERATION = 1;
    private static final int MAP_COPY_OPERATION = 2;
    final ThreadLocal<Integer> lastOperation = new ThreadLocal();

    private Integer getAndSetLastOperation(int n) {
        Integer n2 = this.lastOperation.get();
        this.lastOperation.set(n);
        return n2;
    }

    private boolean wasLastOpReadOrNull(Integer n) {
        return n == null || n == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> duplicateAndInsertNewMap(Map<String, String> map) {
        Map<String, String> map2 = Collections.synchronizedMap(new HashMap());
        if (map != null) {
            Map<String, String> map3 = map;
            synchronized (map3) {
                map2.putAll(map);
            }
        }
        this.copyOnInheritThreadLocal.set(map2);
        return map2;
    }

    public void put(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Map map = (Map)this.copyOnInheritThreadLocal.get();
        Integer n = this.getAndSetLastOperation(1);
        if (this.wasLastOpReadOrNull(n) || map == null) {
            Map<String, String> map2 = this.duplicateAndInsertNewMap(map);
            map2.put(string, string2);
        } else {
            map.put(string, string2);
        }
    }

    public void remove(String string) {
        if (string == null) {
            return;
        }
        Map map = (Map)this.copyOnInheritThreadLocal.get();
        if (map == null) {
            return;
        }
        Integer n = this.getAndSetLastOperation(1);
        if (this.wasLastOpReadOrNull(n)) {
            Map<String, String> map2 = this.duplicateAndInsertNewMap(map);
            map2.remove(string);
        } else {
            map.remove(string);
        }
    }

    public void clear() {
        this.lastOperation.set(1);
        this.copyOnInheritThreadLocal.remove();
    }

    public String get(String string) {
        Map map = (Map)this.copyOnInheritThreadLocal.get();
        if (map != null && string != null) {
            return (String)map.get(string);
        }
        return null;
    }

    public Map<String, String> getPropertyMap() {
        this.lastOperation.set(2);
        return (Map)this.copyOnInheritThreadLocal.get();
    }

    public Set<String> getKeys() {
        Map<String, String> map = this.getPropertyMap();
        if (map != null) {
            return map.keySet();
        }
        return null;
    }

    public Map<String, String> getCopyOfContextMap() {
        Map map = (Map)this.copyOnInheritThreadLocal.get();
        if (map == null) {
            return null;
        }
        return new HashMap<String, String>(map);
    }

    public void setContextMap(Map<String, String> map) {
        this.lastOperation.set(1);
        Map<String, String> map2 = Collections.synchronizedMap(new HashMap());
        map2.putAll(map);
        this.copyOnInheritThreadLocal.set(map2);
    }
}

