/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.CharSequenceState;

class CharSequenceToRegexMapper {
    CharSequenceToRegexMapper() {
    }

    String toRegex(CharSequenceState charSequenceState) {
        int n = charSequenceState.occurrences;
        char c = charSequenceState.c;
        switch (charSequenceState.c) {
            case 'G': 
            case 'z': {
                return ".*";
            }
            case 'M': {
                if (n >= 3) {
                    return ".{3,12}";
                }
                return this.number(n);
            }
            case 'D': 
            case 'F': 
            case 'H': 
            case 'K': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 's': 
            case 'w': 
            case 'y': {
                return this.number(n);
            }
            case 'E': {
                return ".{2,12}";
            }
            case 'a': {
                return ".{2}";
            }
            case 'Z': {
                return "(\\+|-)\\d{4}";
            }
            case '.': {
                return "\\.";
            }
            case '\\': {
                throw new IllegalStateException("Forward slashes are not allowed");
            }
            case '\'': {
                if (n == 1) {
                    return "";
                }
                throw new IllegalStateException("Too many single quotes");
            }
        }
        if (n == 1) {
            return "" + c;
        }
        return c + "{" + n + "}";
    }

    private String number(int n) {
        return "\\d{" + n + "}";
    }
}

