/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.util.StatusListenerConfigHelper;
import ch.qos.logback.core.android.AndroidContextUtil;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "assets/logback.xml";
    public static final String CONFIG_FILE_PROPERTY = "logback.configurationFile";
    public static final String STATUS_LISTENER_CLASS = "logback.statusListenerClass";
    final ClassLoader classLoader;
    final LoggerContext loggerContext;

    public ContextInitializer(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
        this.classLoader = Loader.getClassLoaderOfObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL findConfigFileFromSystemProperties(boolean bl) {
        String string = OptionHelper.getSystemProperty(CONFIG_FILE_PROPERTY);
        if (string != null) {
            URL uRL = null;
            try {
                File file = new File(string);
                if (file.exists() && file.isFile()) {
                    if (bl) {
                        this.statusOnResourceSearch(string, this.classLoader, string);
                    }
                    uRL = file.toURI().toURL();
                } else {
                    uRL = new URL(string);
                }
                URL uRL2 = uRL;
                if (bl) {
                    this.statusOnResourceSearch(string, this.classLoader, uRL != null ? uRL.toString() : null);
                }
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = Loader.getResource(string, this.classLoader);
                    if (uRL != null) {
                        URL uRL3 = uRL;
                        if (bl) {
                            this.statusOnResourceSearch(string, this.classLoader, uRL != null ? uRL.toString() : null);
                        }
                        return uRL3;
                    }
                    if (bl) {
                        this.statusOnResourceSearch(string, this.classLoader, uRL != null ? uRL.toString() : null);
                    }
                }
                catch (Throwable throwable) {
                    if (bl) {
                        this.statusOnResourceSearch(string, this.classLoader, uRL != null ? uRL.toString() : null);
                    }
                    throw throwable;
                }
            }
        }
        return null;
    }

    private InputStream findConfigFileURLFromAssets(boolean bl) {
        return this.getResource(AUTOCONFIG_FILE, this.classLoader, bl);
    }

    private InputStream getResource(String string, ClassLoader classLoader, boolean bl) {
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (bl) {
            String string2 = null;
            if (inputStream != null) {
                string2 = string;
            }
            this.statusOnResourceSearch(string, classLoader, string2);
        }
        return inputStream;
    }

    public void autoConfig() throws JoranException {
        Object object;
        StatusListenerConfigHelper.installIfAsked(this.loggerContext);
        new AndroidContextUtil().setupProperties(this.loggerContext);
        boolean bl = true;
        boolean bl2 = false;
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.loggerContext);
        if (!bl2 && (object = this.findConfigFileFromSystemProperties(bl)) != null) {
            joranConfigurator.doConfigure((URL)object);
            bl2 = true;
        }
        if (!bl2 && (object = this.findConfigFileURLFromAssets(bl)) != null) {
            joranConfigurator.doConfigure((InputStream)object);
            bl2 = true;
        }
    }

    private void statusOnResourceSearch(String string, ClassLoader classLoader, String string2) {
        StatusManager statusManager = this.loggerContext.getStatusManager();
        if (string2 == null) {
            statusManager.add(new InfoStatus("Could NOT find resource [" + string + "]", this.loggerContext));
        } else {
            statusManager.add(new InfoStatus("Found resource [" + string + "] at [" + string2 + "]", this.loggerContext));
        }
    }
}

