/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation.camera;

import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.navigation.camera.Camera;
import com.mapbox.services.android.navigation.v5.navigation.camera.RouteInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleCamera
extends Camera {
    protected static final int DEFAULT_TILT = 50;
    protected static final double DEFAULT_ZOOM = 15.0;
    private List<Point> routeCoordinates = new ArrayList<Point>();
    private DirectionsRoute initialRoute;

    @Override
    public double tilt(RouteInformation routeInformation) {
        return 50.0;
    }

    @Override
    public double zoom(RouteInformation routeInformation) {
        return 15.0;
    }

    @Override
    public List<Point> overview(RouteInformation routeInformation) {
        boolean invalidCoordinates;
        boolean bl = invalidCoordinates = this.routeCoordinates == null || this.routeCoordinates.isEmpty();
        if (invalidCoordinates) {
            this.buildRouteCoordinatesFromRouteData(routeInformation);
        }
        return this.routeCoordinates;
    }

    private void buildRouteCoordinatesFromRouteData(RouteInformation routeInformation) {
        if (routeInformation.route() != null) {
            this.setupLineStringAndBearing(routeInformation.route());
        } else if (routeInformation.routeProgress() != null) {
            this.setupLineStringAndBearing(routeInformation.routeProgress().directionsRoute());
        }
    }

    private void setupLineStringAndBearing(DirectionsRoute route) {
        if (route.equals(this.initialRoute)) {
            return;
        }
        this.initialRoute = route;
        this.routeCoordinates = this.generateRouteCoordinates(route);
    }

    private List<Point> generateRouteCoordinates(DirectionsRoute route) {
        if (route == null) {
            return Collections.emptyList();
        }
        LineString lineString = LineString.fromPolyline((String)route.geometry(), (int)6);
        return lineString.coordinates();
    }
}

