/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import java.io.File;

class UnpackUpdateTask
extends AsyncTask<File, Long, File> {
    private ProgressUpdateListener progressUpdateListener;

    UnpackUpdateTask(@NonNull ProgressUpdateListener progressUpdateListener) {
        this.progressUpdateListener = progressUpdateListener;
    }

    protected File doInBackground(File ... files) {
        File tilePack = files[0];
        double size = tilePack.length();
        long progress = 0L;
        do {
            progress = (long)(100.0 * (1.0 - (double)tilePack.length() / size));
            this.publishProgress(new Long[]{progress});
        } while (progress < 100L);
        return tilePack;
    }

    protected void onPostExecute(File file) {
        super.onPostExecute((Object)file);
        if (this.progressUpdateListener != null) {
            this.progressUpdateListener.onCompletion();
        }
    }

    protected void onProgressUpdate(Long ... values) {
        if (this.progressUpdateListener != null) {
            this.progressUpdateListener.onProgressUpdate(values[0]);
        }
    }

    public static interface ProgressUpdateListener {
        public void onProgressUpdate(Long var1);

        public void onCompletion();
    }
}

