/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.location.Location;
import android.os.Handler;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.navigator.NavigationStatus;
import com.mapbox.navigator.RouteState;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigator;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEngineFactory;
import com.mapbox.services.android.navigation.v5.navigation.NavigationRouteProcessor;
import com.mapbox.services.android.navigation.v5.navigation.RouteProcessorBackgroundThread;
import com.mapbox.services.android.navigation.v5.navigation.RouteRefresher;
import com.mapbox.services.android.navigation.v5.offroute.OffRoute;
import com.mapbox.services.android.navigation.v5.offroute.OffRouteDetector;
import com.mapbox.services.android.navigation.v5.route.FasterRoute;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.snap.Snap;
import com.mapbox.services.android.navigation.v5.snap.SnapToRoute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class RouteProcessorRunnable
implements Runnable {
    private static final int ONE_SECOND_IN_MILLISECONDS = 1000;
    private static final int ARRIVAL_ZONE_RADIUS = 40;
    private final NavigationRouteProcessor routeProcessor;
    private final MapboxNavigation navigation;
    private final Handler workerHandler;
    private final Handler responseHandler;
    private final RouteProcessorBackgroundThread.Listener listener;
    private Location rawLocation;

    RouteProcessorRunnable(NavigationRouteProcessor routeProcessor, MapboxNavigation navigation, Handler workerHandler, Handler responseHandler, RouteProcessorBackgroundThread.Listener listener) {
        this.routeProcessor = routeProcessor;
        this.navigation = navigation;
        this.workerHandler = workerHandler;
        this.responseHandler = responseHandler;
        this.listener = listener;
    }

    @Override
    public void run() {
        this.process();
    }

    void updateRawLocation(Location rawLocation) {
        this.rawLocation = rawLocation;
    }

    private void process() {
        MapboxNavigator mapboxNavigator = this.navigation.retrieveMapboxNavigator();
        MapboxNavigationOptions options = this.navigation.options();
        DirectionsRoute route = this.navigation.getRoute();
        Date date = new Date();
        NavigationStatus status = mapboxNavigator.retrieveStatus(date, options.navigationLocationEngineIntervalLagInMilliseconds());
        NavigationStatus previousStatus = this.routeProcessor.retrievePreviousStatus();
        status = this.checkForNewLegIndex(mapboxNavigator, route, status, previousStatus, options.enableAutoIncrementLegIndex());
        RouteProgress routeProgress = this.routeProcessor.buildNewRouteProgress(mapboxNavigator, status, route);
        RouteRefresher routeRefresher = this.navigation.retrieveRouteRefresher();
        if (routeRefresher != null && routeRefresher.check(date)) {
            routeRefresher.refresh(routeProgress);
        }
        NavigationEngineFactory engineFactory = this.navigation.retrieveEngineFactory();
        boolean userOffRoute = this.isUserOffRoute(options, status, this.rawLocation, routeProgress, engineFactory);
        Location snappedLocation = this.findSnappedLocation(status, this.rawLocation, routeProgress, engineFactory);
        boolean checkFasterRoute = this.checkFasterRoute(options, snappedLocation, routeProgress, engineFactory, userOffRoute);
        List<Milestone> milestones = this.findTriggeredMilestones(this.navigation, routeProgress);
        this.sendUpdateToResponseHandler(userOffRoute, milestones, snappedLocation, checkFasterRoute, routeProgress);
        this.routeProcessor.updatePreviousRouteProgress(routeProgress);
        this.workerHandler.postDelayed((Runnable)this, 1000L);
    }

    private NavigationStatus checkForNewLegIndex(MapboxNavigator mapboxNavigator, DirectionsRoute route, NavigationStatus currentStatus, NavigationStatus previousStatus, boolean autoIncrementEnabled) {
        boolean isValidDistanceRemaining;
        if (previousStatus == null) {
            return currentStatus;
        }
        RouteState previousState = previousStatus.getRouteState();
        int previousLegIndex = previousStatus.getLegIndex();
        int routeLegsSize = route.legs().size() - 1;
        boolean canUpdateLeg = previousState == RouteState.COMPLETE && previousLegIndex < routeLegsSize;
        boolean bl = isValidDistanceRemaining = previousStatus.getRemainingLegDistance() < 40.0f;
        if (autoIncrementEnabled && canUpdateLeg && isValidDistanceRemaining) {
            int newLegIndex = previousLegIndex + 1;
            return mapboxNavigator.updateLegIndex(newLegIndex);
        }
        return currentStatus;
    }

    private boolean isUserOffRoute(MapboxNavigationOptions options, NavigationStatus status, Location rawLocation, RouteProgress routeProgress, NavigationEngineFactory engineFactory) {
        OffRoute offRoute = engineFactory.retrieveOffRouteEngine();
        if (offRoute instanceof OffRouteDetector) {
            return ((OffRouteDetector)offRoute).isUserOffRouteWith(status);
        }
        return offRoute.isUserOffRoute(rawLocation, routeProgress, options);
    }

    private Location findSnappedLocation(NavigationStatus status, Location rawLocation, RouteProgress routeProgress, NavigationEngineFactory engineFactory) {
        Snap snap = engineFactory.retrieveSnapEngine();
        if (snap instanceof SnapToRoute) {
            return ((SnapToRoute)snap).getSnappedLocationWith(status, rawLocation);
        }
        return snap.getSnappedLocation(rawLocation, routeProgress);
    }

    private boolean checkFasterRoute(MapboxNavigationOptions options, Location rawLocation, RouteProgress routeProgress, NavigationEngineFactory engineFactory, boolean userOffRoute) {
        FasterRoute fasterRoute = engineFactory.retrieveFasterRouteEngine();
        boolean fasterRouteDetectionEnabled = options.enableFasterRouteDetection();
        return fasterRouteDetectionEnabled && !userOffRoute && fasterRoute.shouldCheckFasterRoute(rawLocation, routeProgress);
    }

    private List<Milestone> findTriggeredMilestones(MapboxNavigation mapboxNavigation, RouteProgress routeProgress) {
        RouteProgress previousRouteProgress = this.routeProcessor.retrievePreviousRouteProgress();
        if (previousRouteProgress == null) {
            previousRouteProgress = routeProgress;
        }
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        for (Milestone milestone : mapboxNavigation.getMilestones()) {
            if (!milestone.isOccurring(previousRouteProgress, routeProgress)) continue;
            milestones.add(milestone);
        }
        return milestones;
    }

    private void sendUpdateToResponseHandler(final boolean userOffRoute, final List<Milestone> milestones, final Location location, final boolean checkFasterRoute, final RouteProgress finalRouteProgress) {
        this.responseHandler.post(new Runnable(){

            @Override
            public void run() {
                RouteProcessorRunnable.this.listener.onNewRouteProgress(location, finalRouteProgress);
                RouteProcessorRunnable.this.listener.onMilestoneTrigger(milestones, finalRouteProgress);
                RouteProcessorRunnable.this.listener.onUserOffRoute(location, userOffRoute);
                RouteProcessorRunnable.this.listener.onCheckFasterRoute(location, finalRouteProgress, checkFasterRoute);
            }
        });
    }
}

