/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import java.util.ArrayList;

public class NavigationLifecycleMonitor
implements Application.ActivityLifecycleCallbacks {
    private static final int ONE_HUNDRED_PERCENT = 100;
    private long startSessionTime = 0L;
    private ArrayList<Long> resumes;
    private ArrayList<Long> pauses;
    private Integer currentOrientation;
    private long portraitStartTime = 0L;
    private double portraitTimeInMillis = 0.0;

    NavigationLifecycleMonitor(Application application) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.startSessionTime = System.currentTimeMillis();
        this.resumes = new ArrayList();
        this.pauses = new ArrayList();
        this.initCurrentOrientation(application);
    }

    public void onActivityStarted(Activity activity) {
        int newOrientation = activity.getResources().getConfiguration().orientation;
        if (!this.currentOrientation.equals(newOrientation)) {
            this.currentOrientation = newOrientation;
            long currentTimeMillis = System.currentTimeMillis();
            if (this.currentOrientation.equals(2)) {
                this.portraitTimeInMillis += (double)(currentTimeMillis - this.portraitStartTime);
            } else if (this.currentOrientation.equals(1)) {
                this.portraitStartTime = currentTimeMillis;
            }
        }
    }

    public void onActivityResumed(Activity activity) {
        this.resumes.add(System.currentTimeMillis());
    }

    public void onActivityPaused(Activity activity) {
        this.pauses.add(System.currentTimeMillis());
    }

    public void onActivityDestroyed(Activity activity) {
        if (activity.isFinishing()) {
            activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    int obtainPortraitPercentage() {
        if (this.currentOrientation.equals(1) && this.portraitTimeInMillis == 0.0) {
            return 100;
        }
        double portraitFraction = this.portraitTimeInMillis / (double)(System.currentTimeMillis() - this.startSessionTime);
        return (int)(100.0 * portraitFraction);
    }

    int obtainForegroundPercentage() {
        long currentTime = System.currentTimeMillis();
        double foregroundTime = this.calculateForegroundTime(currentTime);
        return (int)(100.0 * (foregroundTime / (double)(currentTime - this.startSessionTime)));
    }

    private void initCurrentOrientation(Application application) {
        this.currentOrientation = application.getResources().getConfiguration().orientation;
        if (this.currentOrientation.equals(1)) {
            this.portraitStartTime = System.currentTimeMillis();
        }
    }

    private double calculateForegroundTime(long currentTime) {
        ArrayList<Long> tempResumes = new ArrayList<Long>(this.resumes);
        if (tempResumes.size() < this.pauses.size() && this.pauses.size() > 0) {
            tempResumes.add(currentTime);
        }
        long resumePauseDiff = 0L;
        for (int i = 0; i < tempResumes.size(); ++i) {
            if (i >= this.pauses.size()) continue;
            resumePauseDiff += tempResumes.get(i) - this.pauses.get(i);
        }
        return currentTime - resumePauseDiff - this.startSessionTime;
    }
}

