/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineProvider;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.navigator.Navigator;
import com.mapbox.services.android.navigation.v5.location.RawLocationListener;
import com.mapbox.services.android.navigation.v5.milestone.BannerInstructionMilestone;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.milestone.MilestoneEventListener;
import com.mapbox.services.android.navigation.v5.milestone.VoiceInstructionMilestone;
import com.mapbox.services.android.navigation.v5.navigation.DirectionsRouteType;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigator;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEngineFactory;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEventDispatcher;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEventListener;
import com.mapbox.services.android.navigation.v5.navigation.NavigationLibraryLoader;
import com.mapbox.services.android.navigation.v5.navigation.NavigationService;
import com.mapbox.services.android.navigation.v5.navigation.NavigationTelemetry;
import com.mapbox.services.android.navigation.v5.navigation.RouteRefresh;
import com.mapbox.services.android.navigation.v5.navigation.RouteRefresher;
import com.mapbox.services.android.navigation.v5.navigation.camera.Camera;
import com.mapbox.services.android.navigation.v5.offroute.OffRoute;
import com.mapbox.services.android.navigation.v5.offroute.OffRouteListener;
import com.mapbox.services.android.navigation.v5.route.FasterRoute;
import com.mapbox.services.android.navigation.v5.route.FasterRouteListener;
import com.mapbox.services.android.navigation.v5.routeprogress.ProgressChangeListener;
import com.mapbox.services.android.navigation.v5.snap.Snap;
import com.mapbox.services.android.navigation.v5.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import timber.log.Timber;

public class MapboxNavigation
implements ServiceConnection {
    private static final long UPDATE_INTERVAL_IN_MILLISECONDS = 1000L;
    private static final long FASTEST_UPDATE_INTERVAL_IN_MILLISECONDS = 500L;
    private NavigationEventDispatcher navigationEventDispatcher;
    private NavigationEngineFactory navigationEngineFactory;
    private NavigationTelemetry navigationTelemetry = null;
    private NavigationService navigationService;
    private MapboxNavigator mapboxNavigator;
    private DirectionsRoute directionsRoute;
    private MapboxNavigationOptions options;
    private LocationEngine locationEngine;
    private LocationEngineRequest locationEngineRequest;
    private Set<Milestone> milestones;
    private final String accessToken;
    private Context applicationContext;
    private boolean isBound;
    private RouteRefresher routeRefresher;

    public MapboxNavigation(@NonNull Context context, @NonNull String accessToken) {
        this(context, accessToken, MapboxNavigationOptions.builder().build());
    }

    public MapboxNavigation(@NonNull Context context, @NonNull String accessToken, @NonNull MapboxNavigationOptions options) {
        this.initializeContext(context);
        this.accessToken = accessToken;
        this.options = options;
        this.initialize();
    }

    public MapboxNavigation(@NonNull Context context, @NonNull String accessToken, @NonNull MapboxNavigationOptions options, @NonNull LocationEngine locationEngine) {
        this.initializeContext(context);
        this.accessToken = accessToken;
        this.options = options;
        this.locationEngine = locationEngine;
        this.initialize();
    }

    MapboxNavigation(@NonNull Context context, @NonNull String accessToken, @NonNull MapboxNavigationOptions options, NavigationTelemetry navigationTelemetry, LocationEngine locationEngine) {
        this.initializeContext(context);
        this.accessToken = accessToken;
        this.options = options;
        this.navigationTelemetry = navigationTelemetry;
        this.locationEngine = locationEngine;
        this.initializeForTest();
    }

    MapboxNavigation(@NonNull Context context, @NonNull String accessToken, NavigationTelemetry navigationTelemetry, LocationEngine locationEngine, MapboxNavigator mapboxNavigator) {
        this.initializeContext(context);
        this.accessToken = accessToken;
        this.options = MapboxNavigationOptions.builder().build();
        this.navigationTelemetry = navigationTelemetry;
        this.locationEngine = locationEngine;
        this.mapboxNavigator = mapboxNavigator;
        this.initializeForTest();
    }

    public void onDestroy() {
        this.stopNavigation();
        this.removeOffRouteListener(null);
        this.removeProgressChangeListener(null);
        this.removeMilestoneEventListener(null);
        this.removeNavigationEventListener(null);
        this.removeFasterRouteListener(null);
        this.removeRawLocationListener(null);
    }

    public void addMilestone(@NonNull Milestone milestone) {
        boolean milestoneAdded = this.milestones.add(milestone);
        if (!milestoneAdded) {
            Timber.w((String)"Milestone has already been added to the stack.", (Object[])new Object[0]);
        }
    }

    public void addMilestones(@NonNull List<Milestone> milestones) {
        boolean milestonesAdded = this.milestones.addAll(milestones);
        if (!milestonesAdded) {
            Timber.w((String)"These milestones have already been added to the stack.", (Object[])new Object[0]);
        }
    }

    public void removeMilestone(@Nullable Milestone milestone) {
        if (milestone == null) {
            this.milestones.clear();
            return;
        }
        if (!this.milestones.contains(milestone)) {
            Timber.w((String)"Milestone attempting to remove does not exist in stack.", (Object[])new Object[0]);
            return;
        }
        this.milestones.remove(milestone);
    }

    public void removeMilestone(int milestoneIdentifier) {
        for (Milestone milestone : this.milestones) {
            if (milestoneIdentifier != milestone.getIdentifier()) continue;
            this.removeMilestone(milestone);
            return;
        }
        Timber.w((String)"No milestone found with the specified identifier.", (Object[])new Object[0]);
    }

    public void setLocationEngine(@NonNull LocationEngine locationEngine) {
        this.locationEngine = locationEngine;
        this.navigationTelemetry.updateLocationEngineNameAndSimulation(locationEngine);
        if (this.isServiceAvailable()) {
            this.navigationService.updateLocationEngine(locationEngine);
        }
    }

    @NonNull
    public LocationEngine getLocationEngine() {
        return this.locationEngine;
    }

    public void setLocationEngineRequest(@NonNull LocationEngineRequest locationEngineRequest) {
        this.locationEngineRequest = locationEngineRequest;
        if (this.isServiceAvailable()) {
            this.navigationService.updateLocationEngineRequest(locationEngineRequest);
        }
    }

    public void startNavigation(@NonNull DirectionsRoute directionsRoute) {
        this.startNavigationWith(directionsRoute, DirectionsRouteType.NEW_ROUTE);
    }

    public void startNavigation(@NonNull DirectionsRoute directionsRoute, @NonNull DirectionsRouteType routeType) {
        this.startNavigationWith(directionsRoute, routeType);
    }

    public void stopNavigation() {
        Timber.d((String)"MapboxNavigation stopNavigation called", (Object[])new Object[0]);
        if (this.isServiceAvailable()) {
            this.navigationTelemetry.stopSession();
            this.applicationContext.unbindService((ServiceConnection)this);
            this.isBound = false;
            this.navigationService.endNavigation();
            this.navigationService.stopSelf();
            this.navigationEventDispatcher.onNavigationEvent(false);
        }
    }

    public void addMilestoneEventListener(@NonNull MilestoneEventListener milestoneEventListener) {
        this.navigationEventDispatcher.addMilestoneEventListener(milestoneEventListener);
    }

    public void removeMilestoneEventListener(@Nullable MilestoneEventListener milestoneEventListener) {
        this.navigationEventDispatcher.removeMilestoneEventListener(milestoneEventListener);
    }

    public void addProgressChangeListener(@NonNull ProgressChangeListener progressChangeListener) {
        this.navigationEventDispatcher.addProgressChangeListener(progressChangeListener);
    }

    public void removeProgressChangeListener(@Nullable ProgressChangeListener progressChangeListener) {
        this.navigationEventDispatcher.removeProgressChangeListener(progressChangeListener);
    }

    public void addOffRouteListener(@NonNull OffRouteListener offRouteListener) {
        this.navigationEventDispatcher.addOffRouteListener(offRouteListener);
    }

    public void removeOffRouteListener(@Nullable OffRouteListener offRouteListener) {
        this.navigationEventDispatcher.removeOffRouteListener(offRouteListener);
    }

    public void addNavigationEventListener(@NonNull NavigationEventListener navigationEventListener) {
        this.navigationEventDispatcher.addNavigationEventListener(navigationEventListener);
    }

    public void removeNavigationEventListener(@Nullable NavigationEventListener navigationEventListener) {
        this.navigationEventDispatcher.removeNavigationEventListener(navigationEventListener);
    }

    public void addFasterRouteListener(@NonNull FasterRouteListener fasterRouteListener) {
        this.navigationEventDispatcher.addFasterRouteListener(fasterRouteListener);
    }

    public void removeFasterRouteListener(@Nullable FasterRouteListener fasterRouteListener) {
        this.navigationEventDispatcher.removeFasterRouteListener(fasterRouteListener);
    }

    public void addRawLocationListener(@NonNull RawLocationListener rawLocationListener) {
        this.navigationEventDispatcher.addRawLocationListener(rawLocationListener);
    }

    public void removeRawLocationListener(@Nullable RawLocationListener rawLocationListener) {
        this.navigationEventDispatcher.removeRawLocationListener(rawLocationListener);
    }

    public void setCameraEngine(@NonNull Camera cameraEngine) {
        this.navigationEngineFactory.updateCameraEngine(cameraEngine);
    }

    @NonNull
    public Camera getCameraEngine() {
        return this.navigationEngineFactory.retrieveCameraEngine();
    }

    public void setSnapEngine(@NonNull Snap snapEngine) {
        this.navigationEngineFactory.updateSnapEngine(snapEngine);
    }

    public Snap getSnapEngine() {
        return this.navigationEngineFactory.retrieveSnapEngine();
    }

    public void setOffRouteEngine(@NonNull OffRoute offRouteEngine) {
        this.navigationEngineFactory.updateOffRouteEngine(offRouteEngine);
    }

    @NonNull
    public OffRoute getOffRouteEngine() {
        return this.navigationEngineFactory.retrieveOffRouteEngine();
    }

    public void setFasterRouteEngine(@NonNull FasterRoute fasterRouteEngine) {
        this.navigationEngineFactory.updateFasterRouteEngine(fasterRouteEngine);
    }

    @NonNull
    public FasterRoute getFasterRouteEngine() {
        return this.navigationEngineFactory.retrieveFasterRouteEngine();
    }

    public String recordFeedback(String feedbackType, String description, String source) {
        return this.navigationTelemetry.recordFeedbackEvent(feedbackType, description, source);
    }

    public void updateFeedback(String feedbackId, String feedbackType, String description, String screenshot) {
        this.navigationTelemetry.updateFeedbackEvent(feedbackId, feedbackType, description, screenshot);
    }

    public void cancelFeedback(String feedbackId) {
        this.navigationTelemetry.cancelFeedback(feedbackId);
    }

    public boolean updateRouteLegIndex(int legIndex) {
        if (this.checkInvalidLegIndex(legIndex)) {
            return false;
        }
        this.mapboxNavigator.updateLegIndex(legIndex);
        return true;
    }

    public String retrieveHistory() {
        return this.mapboxNavigator.retrieveHistory();
    }

    public void toggleHistory(boolean isEnabled) {
        this.mapboxNavigator.toggleHistory(isEnabled);
    }

    public void addHistoryEvent(String eventType, String eventJsonProperties) {
        this.mapboxNavigator.addHistoryEvent(eventType, eventJsonProperties);
    }

    public String retrieveSsmlAnnouncementInstruction(int index) {
        return this.mapboxNavigator.retrieveVoiceInstruction(index).getSsmlAnnouncement();
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        Timber.d((String)"Connected to service.", (Object[])new Object[0]);
        NavigationService.LocalBinder binder = (NavigationService.LocalBinder)service;
        this.navigationService = binder.getService();
        this.navigationService.startNavigation(this);
        this.isBound = true;
    }

    public void onServiceDisconnected(ComponentName name) {
        Timber.d((String)"Disconnected from service.", (Object[])new Object[0]);
        this.navigationService = null;
        this.isBound = false;
    }

    String obtainAccessToken() {
        return this.accessToken;
    }

    DirectionsRoute getRoute() {
        return this.directionsRoute;
    }

    List<Milestone> getMilestones() {
        return new ArrayList<Milestone>(this.milestones);
    }

    MapboxNavigationOptions options() {
        return this.options;
    }

    NavigationEventDispatcher getEventDispatcher() {
        return this.navigationEventDispatcher;
    }

    NavigationEngineFactory retrieveEngineFactory() {
        return this.navigationEngineFactory;
    }

    MapboxNavigator retrieveMapboxNavigator() {
        return this.mapboxNavigator;
    }

    @NonNull
    LocationEngineRequest retrieveLocationEngineRequest() {
        return this.locationEngineRequest;
    }

    @Nullable
    RouteRefresher retrieveRouteRefresher() {
        return this.routeRefresher;
    }

    private void initializeForTest() {
        this.navigationEventDispatcher = new NavigationEventDispatcher();
        this.navigationEngineFactory = new NavigationEngineFactory();
        this.locationEngine = this.obtainLocationEngine();
        this.locationEngineRequest = this.obtainLocationEngineRequest();
        this.initializeTelemetry();
        this.milestones = new HashSet<Milestone>();
        if (this.options.defaultMilestonesEnabled()) {
            this.addMilestone(new VoiceInstructionMilestone.Builder().setIdentifier(1).build());
            this.addMilestone(new BannerInstructionMilestone.Builder().setIdentifier(2).build());
        }
    }

    private void initialize() {
        this.mapboxNavigator = new MapboxNavigator(new Navigator());
        this.navigationEventDispatcher = new NavigationEventDispatcher();
        this.navigationEngineFactory = new NavigationEngineFactory();
        this.locationEngine = this.obtainLocationEngine();
        this.locationEngineRequest = this.obtainLocationEngineRequest();
        this.initializeTelemetry();
        this.milestones = new HashSet<Milestone>();
        if (this.options.defaultMilestonesEnabled()) {
            this.addMilestone(new VoiceInstructionMilestone.Builder().setIdentifier(1).build());
            this.addMilestone(new BannerInstructionMilestone.Builder().setIdentifier(2).build());
        }
    }

    private void initializeContext(Context context) {
        if (context == null || context.getApplicationContext() == null) {
            throw new IllegalArgumentException("Non-null application context required.");
        }
        this.applicationContext = context.getApplicationContext();
    }

    private void initializeTelemetry() {
        this.navigationTelemetry = this.obtainTelemetry();
        this.navigationTelemetry.initialize(this.applicationContext, this.accessToken, this);
    }

    private NavigationTelemetry obtainTelemetry() {
        if (this.navigationTelemetry == null) {
            return NavigationTelemetry.getInstance();
        }
        return this.navigationTelemetry;
    }

    @NonNull
    private LocationEngine obtainLocationEngine() {
        if (this.locationEngine == null) {
            return LocationEngineProvider.getBestLocationEngine((Context)this.applicationContext);
        }
        return this.locationEngine;
    }

    @NonNull
    private LocationEngineRequest obtainLocationEngineRequest() {
        if (this.locationEngineRequest == null) {
            return new LocationEngineRequest.Builder(1000L).setPriority(0).setFastestInterval(500L).build();
        }
        return this.locationEngineRequest;
    }

    private void startNavigationWith(@NonNull DirectionsRoute directionsRoute, DirectionsRouteType routeType) {
        ValidationUtils.validDirectionsRoute(directionsRoute, this.options.defaultMilestonesEnabled());
        this.directionsRoute = directionsRoute;
        this.routeRefresher = new RouteRefresher(this, new RouteRefresh(this.accessToken));
        this.mapboxNavigator.updateRoute(directionsRoute, routeType);
        if (!this.isBound) {
            this.navigationTelemetry.startSession(directionsRoute, this.locationEngine);
            this.startNavigationService();
            this.navigationEventDispatcher.onNavigationEvent(true);
        } else {
            this.navigationTelemetry.updateSessionRoute(directionsRoute);
        }
    }

    private void startNavigationService() {
        Intent intent = this.getServiceIntent();
        if (Build.VERSION.SDK_INT >= 26) {
            this.applicationContext.startForegroundService(intent);
        } else {
            this.applicationContext.startService(intent);
        }
        this.applicationContext.bindService(intent, (ServiceConnection)this, 1);
    }

    private Intent getServiceIntent() {
        return new Intent(this.applicationContext, NavigationService.class);
    }

    private boolean isServiceAvailable() {
        return this.navigationService != null && this.isBound;
    }

    private boolean checkInvalidLegIndex(int legIndex) {
        int legSize = this.directionsRoute.legs().size();
        if (legIndex < 0 || legIndex > legSize - 1) {
            Timber.e((String)"Invalid leg index update: %s Current leg index size: %s", (Object[])new Object[]{legIndex, legSize});
            return true;
        }
        return false;
    }

    static {
        NavigationLibraryLoader.load();
    }
}

