/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.annotation.SuppressLint;
import android.location.Location;
import android.support.annotation.NonNull;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineCallback;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.android.core.location.LocationEngineResult;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEventDispatcher;
import com.mapbox.services.android.navigation.v5.navigation.NavigationTelemetry;
import com.mapbox.services.android.navigation.v5.navigation.RouteProcessorBackgroundThread;
import java.lang.ref.WeakReference;
import timber.log.Timber;

class LocationUpdater {
    private final LocationEngineCallback<LocationEngineResult> callback = new CurrentLocationEngineCallback(this);
    private final RouteProcessorBackgroundThread thread;
    private final NavigationEventDispatcher dispatcher;
    private LocationEngine locationEngine;
    private LocationEngineRequest request;

    @SuppressLint(value={"MissingPermission"})
    LocationUpdater(RouteProcessorBackgroundThread thread, NavigationEventDispatcher dispatcher, LocationEngine locationEngine, LocationEngineRequest request) {
        this.thread = thread;
        this.dispatcher = dispatcher;
        this.locationEngine = locationEngine;
        this.request = request;
        this.requestInitialLocationUpdates(locationEngine, request);
    }

    void updateLocationEngine(LocationEngine locationEngine) {
        this.requestLocationUpdates(this.request, locationEngine);
        this.locationEngine = locationEngine;
    }

    void updateLocationEngineRequest(LocationEngineRequest request) {
        this.requestLocationUpdates(request, this.locationEngine);
        this.request = request;
    }

    void onLocationChanged(Location location) {
        if (location != null) {
            this.thread.updateLocation(location);
            this.dispatcher.onLocationUpdate(location);
            NavigationTelemetry.getInstance().updateLocation(location);
        }
    }

    void removeLocationUpdates() {
        this.locationEngine.removeLocationUpdates(this.callback);
    }

    @SuppressLint(value={"MissingPermission"})
    private void requestInitialLocationUpdates(LocationEngine locationEngine, LocationEngineRequest request) {
        locationEngine.requestLocationUpdates(request, this.callback, null);
    }

    @SuppressLint(value={"MissingPermission"})
    private void requestLocationUpdates(LocationEngineRequest request, LocationEngine locationEngine) {
        this.locationEngine.removeLocationUpdates(this.callback);
        locationEngine.requestLocationUpdates(request, this.callback, null);
    }

    static class CurrentLocationEngineCallback
    implements LocationEngineCallback<LocationEngineResult> {
        private final WeakReference<LocationUpdater> updaterWeakReference;

        CurrentLocationEngineCallback(LocationUpdater locationUpdater) {
            this.updaterWeakReference = new WeakReference<LocationUpdater>(locationUpdater);
        }

        public void onSuccess(LocationEngineResult result) {
            LocationUpdater locationUpdater = (LocationUpdater)this.updaterWeakReference.get();
            if (locationUpdater != null) {
                Location location = result.getLastLocation();
                locationUpdater.onLocationChanged(location);
            }
        }

        public void onFailure(@NonNull Exception exception) {
            Timber.e((Throwable)exception);
        }
    }
}

