/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.milestone;

import com.mapbox.navigator.VoiceInstruction;
import com.mapbox.services.android.navigation.v5.instruction.Instruction;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.milestone.Trigger;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;

public class VoiceInstructionMilestone
extends Milestone {
    private static final String EMPTY_STRING = "";
    private String announcement = "";
    private String ssmlAnnouncement = "";

    VoiceInstructionMilestone(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isOccurring(RouteProgress previousRouteProgress, RouteProgress routeProgress) {
        return this.updateCurrentAnnouncement(routeProgress);
    }

    @Override
    public Instruction getInstruction() {
        return new Instruction(){

            @Override
            public String buildInstruction(RouteProgress routeProgress) {
                return VoiceInstructionMilestone.this.announcement;
            }
        };
    }

    public String getSsmlAnnouncement() {
        return this.ssmlAnnouncement;
    }

    public String getAnnouncement() {
        return this.announcement;
    }

    private boolean updateCurrentAnnouncement(RouteProgress routeProgress) {
        VoiceInstruction currentVoiceInstruction = routeProgress.voiceInstruction();
        if (currentVoiceInstruction != null) {
            this.announcement = currentVoiceInstruction.getAnnouncement();
            this.ssmlAnnouncement = currentVoiceInstruction.getSsmlAnnouncement();
            return true;
        }
        return false;
    }

    public static final class Builder
    extends Milestone.Builder {
        private Trigger.Statement trigger;

        @Override
        Trigger.Statement getTrigger() {
            return this.trigger;
        }

        @Override
        public Builder setTrigger(Trigger.Statement trigger) {
            this.trigger = trigger;
            return this;
        }

        @Override
        public VoiceInstructionMilestone build() {
            return new VoiceInstructionMilestone(this);
        }
    }
}

