/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.milestone;

import com.mapbox.api.directions.v5.models.BannerComponents;
import com.mapbox.api.directions.v5.models.BannerInstructions;
import com.mapbox.api.directions.v5.models.BannerText;
import com.mapbox.navigator.BannerComponent;
import com.mapbox.navigator.BannerInstruction;
import com.mapbox.navigator.BannerSection;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.milestone.Trigger;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import java.util.ArrayList;
import java.util.List;

public class BannerInstructionMilestone
extends Milestone {
    private BannerInstructions instructions;

    private BannerInstructionMilestone(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isOccurring(RouteProgress previousRouteProgress, RouteProgress routeProgress) {
        return this.updateCurrentBanner(routeProgress);
    }

    private boolean updateCurrentBanner(RouteProgress routeProgress) {
        BannerInstruction currentBannerInstruction = routeProgress.bannerInstruction();
        if (currentBannerInstruction != null) {
            BannerSection currentPrimary = currentBannerInstruction.getPrimary();
            BannerText primary = this.retrieveBannerFrom(currentPrimary);
            BannerSection currentSecondary = currentBannerInstruction.getSecondary();
            BannerText secondary = this.retrieveBannerFrom(currentSecondary);
            BannerSection currentSub = currentBannerInstruction.getSub();
            BannerText sub = this.retrieveBannerFrom(currentSub);
            this.instructions = BannerInstructions.builder().primary(primary).secondary(secondary).sub(sub).distanceAlongGeometry((double)currentBannerInstruction.getRemainingStepDistance()).build();
            return true;
        }
        return false;
    }

    private BannerText retrieveBannerFrom(BannerSection bannerSection) {
        BannerText banner = null;
        if (bannerSection == null) {
            return banner;
        }
        ArrayList currentComponents = bannerSection.getComponents();
        if (currentComponents != null) {
            ArrayList<BannerComponents> primaryComponents = new ArrayList<BannerComponents>();
            for (BannerComponent bannerComponent : currentComponents) {
                BannerComponents bannerComponents = BannerComponents.builder().text(bannerComponent.getText()).type(bannerComponent.getType()).abbreviation(bannerComponent.getAbbr()).abbreviationPriority(bannerComponent.getAbbrPriority()).imageBaseUrl(bannerComponent.getImageBaseurl()).directions((List)bannerComponent.getDirections()).active(bannerComponent.getActive()).build();
                primaryComponents.add(bannerComponents);
            }
            Integer bannerSectionDegrees = bannerSection.getDegrees();
            Double degrees = null;
            if (bannerSectionDegrees != null) {
                degrees = (double)bannerSectionDegrees;
            }
            banner = BannerText.builder().text(bannerSection.getText()).type(bannerSection.getType()).modifier(bannerSection.getModifier()).degrees(degrees).drivingSide(bannerSection.getDrivingSide()).components(primaryComponents).build();
        }
        return banner;
    }

    public BannerInstructions getBannerInstructions() {
        return this.instructions;
    }

    public static final class Builder
    extends Milestone.Builder {
        private Trigger.Statement trigger;

        @Override
        Trigger.Statement getTrigger() {
            return this.trigger;
        }

        @Override
        public Builder setTrigger(Trigger.Statement trigger) {
            this.trigger = trigger;
            return this;
        }

        @Override
        public BannerInstructionMilestone build() {
            return new BannerInstructionMilestone(this);
        }
    }
}

