/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.services.android.navigation.v5.navigation.LocationUpdater;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEngineFactory;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEventDispatcher;
import com.mapbox.services.android.navigation.v5.navigation.NavigationFasterRouteListener;
import com.mapbox.services.android.navigation.v5.navigation.NavigationNotificationProvider;
import com.mapbox.services.android.navigation.v5.navigation.NavigationTelemetry;
import com.mapbox.services.android.navigation.v5.navigation.RouteProcessorBackgroundThread;
import com.mapbox.services.android.navigation.v5.navigation.RouteProcessorThreadListener;
import com.mapbox.services.android.navigation.v5.navigation.notification.NavigationNotification;
import com.mapbox.services.android.navigation.v5.route.FasterRoute;
import com.mapbox.services.android.navigation.v5.route.RouteFetcher;
import timber.log.Timber;

public class NavigationService
extends Service {
    private final IBinder localBinder = new LocalBinder();
    private RouteProcessorBackgroundThread thread;
    private LocationUpdater locationUpdater;
    private RouteFetcher routeFetcher;
    private NavigationNotificationProvider notificationProvider;

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.localBinder;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        NavigationTelemetry.getInstance().initializeLifecycleMonitor(this.getApplication());
        return 1;
    }

    public void onDestroy() {
        this.stopForeground(true);
        super.onDestroy();
    }

    void startNavigation(MapboxNavigation mapboxNavigation) {
        this.initialize(mapboxNavigation);
        this.startForegroundNotification(this.notificationProvider.retrieveNotification());
    }

    void endNavigation() {
        this.routeFetcher.clearListeners();
        this.locationUpdater.removeLocationUpdates();
        this.notificationProvider.shutdown((Context)this.getApplication());
        this.thread.quit();
    }

    void updateLocationEngine(LocationEngine locationEngine) {
        this.locationUpdater.updateLocationEngine(locationEngine);
    }

    void updateLocationEngineRequest(LocationEngineRequest request) {
        this.locationUpdater.updateLocationEngineRequest(request);
    }

    private void initialize(MapboxNavigation mapboxNavigation) {
        NavigationEventDispatcher dispatcher = mapboxNavigation.getEventDispatcher();
        String accessToken = mapboxNavigation.obtainAccessToken();
        this.initializeRouteFetcher(dispatcher, accessToken, mapboxNavigation.retrieveEngineFactory());
        this.initializeNotificationProvider(mapboxNavigation);
        this.initializeRouteProcessorThread(mapboxNavigation, dispatcher, this.routeFetcher, this.notificationProvider);
        this.initializeLocationUpdater(mapboxNavigation);
    }

    private void initializeRouteFetcher(NavigationEventDispatcher dispatcher, String accessToken, NavigationEngineFactory engineProvider) {
        FasterRoute fasterRouteEngine = engineProvider.retrieveFasterRouteEngine();
        NavigationFasterRouteListener listener = new NavigationFasterRouteListener(dispatcher, fasterRouteEngine);
        this.routeFetcher = new RouteFetcher((Context)this.getApplication(), accessToken);
        this.routeFetcher.addRouteListener(listener);
    }

    private void initializeNotificationProvider(MapboxNavigation mapboxNavigation) {
        this.notificationProvider = new NavigationNotificationProvider((Context)this.getApplication(), mapboxNavigation);
    }

    private void initializeRouteProcessorThread(MapboxNavigation mapboxNavigation, NavigationEventDispatcher dispatcher, RouteFetcher routeFetcher, NavigationNotificationProvider notificationProvider) {
        RouteProcessorThreadListener listener = new RouteProcessorThreadListener(dispatcher, routeFetcher, notificationProvider);
        this.thread = new RouteProcessorBackgroundThread(mapboxNavigation, new Handler(), listener);
    }

    private void initializeLocationUpdater(MapboxNavigation mapboxNavigation) {
        LocationEngine locationEngine = mapboxNavigation.getLocationEngine();
        LocationEngineRequest locationEngineRequest = mapboxNavigation.retrieveLocationEngineRequest();
        this.locationUpdater = new LocationUpdater(this.thread, locationEngine, locationEngineRequest);
    }

    private void startForegroundNotification(NavigationNotification navigationNotification) {
        Notification notification = navigationNotification.getNotification();
        int notificationId = navigationNotification.getNotificationId();
        notification.flags = 64;
        this.startForeground(notificationId, notification);
    }

    class LocalBinder
    extends Binder {
        LocalBinder() {
        }

        NavigationService getService() {
            Timber.d((String)"Local binder called.", (Object[])new Object[0]);
            return NavigationService.this;
        }
    }
}

