/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.android.telemetry.Event;
import com.mapbox.services.android.navigation.v5.navigation.Attribute;
import com.mapbox.services.android.navigation.v5.navigation.Counter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

@SuppressLint(value={"ParcelCreator"})
class NavigationPerformanceEvent
extends Event
implements Parcelable {
    private static final String DATE_AND_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
    private static final String PERFORMANCE_TRACE = "mobile.performance_trace";
    private final String event;
    private final String created = this.obtainCurrentDate();
    private final String sessionId;
    private final List<Counter> counters;
    private final List<Attribute> attributes;

    NavigationPerformanceEvent(String sessionId) {
        this.event = PERFORMANCE_TRACE;
        this.sessionId = sessionId;
        this.counters = new ArrayList<Counter>();
        this.attributes = new ArrayList<Attribute>();
    }

    private String obtainCurrentDate() {
        return dateFormat.format(new Date());
    }

    void addCounter(Counter counter) {
        this.counters.add(counter);
    }

    void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
    }
}

