/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.milestone.MilestoneEventListener;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEventListener;
import com.mapbox.services.android.navigation.v5.navigation.metrics.NavigationMetricListener;
import com.mapbox.services.android.navigation.v5.offroute.OffRouteListener;
import com.mapbox.services.android.navigation.v5.route.FasterRouteListener;
import com.mapbox.services.android.navigation.v5.routeprogress.ProgressChangeListener;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.RouteUtils;
import java.util.concurrent.CopyOnWriteArrayList;
import timber.log.Timber;

class NavigationEventDispatcher {
    private CopyOnWriteArrayList<NavigationEventListener> navigationEventListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<MilestoneEventListener> milestoneEventListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<ProgressChangeListener> progressChangeListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<OffRouteListener> offRouteListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<FasterRouteListener> fasterRouteListeners = new CopyOnWriteArrayList();
    private NavigationMetricListener metricEventListener;
    private RouteUtils routeUtils;

    NavigationEventDispatcher() {
        this(new RouteUtils());
    }

    NavigationEventDispatcher(RouteUtils routeUtils) {
        this.routeUtils = routeUtils;
    }

    void addMilestoneEventListener(@NonNull MilestoneEventListener milestoneEventListener) {
        if (this.milestoneEventListeners.contains(milestoneEventListener)) {
            Timber.w((String)"The specified MilestoneEventListener has already been added to the stack.", (Object[])new Object[0]);
            return;
        }
        this.milestoneEventListeners.add(milestoneEventListener);
    }

    void removeMilestoneEventListener(@Nullable MilestoneEventListener milestoneEventListener) {
        if (milestoneEventListener == null) {
            this.milestoneEventListeners.clear();
        } else if (!this.milestoneEventListeners.contains(milestoneEventListener)) {
            Timber.w((String)"The specified MilestoneEventListener isn't found in stack, therefore, cannot be removed.", (Object[])new Object[0]);
        } else {
            this.milestoneEventListeners.remove(milestoneEventListener);
        }
    }

    void addProgressChangeListener(@NonNull ProgressChangeListener progressChangeListener) {
        if (this.progressChangeListeners.contains(progressChangeListener)) {
            Timber.w((String)"The specified ProgressChangeListener has already been added to the stack.", (Object[])new Object[0]);
            return;
        }
        this.progressChangeListeners.add(progressChangeListener);
    }

    void removeProgressChangeListener(@Nullable ProgressChangeListener progressChangeListener) {
        if (progressChangeListener == null) {
            this.progressChangeListeners.clear();
        } else if (!this.progressChangeListeners.contains(progressChangeListener)) {
            Timber.w((String)"The specified ProgressChangeListener isn't found in stack, therefore, cannot be removed.", (Object[])new Object[0]);
        } else {
            this.progressChangeListeners.remove(progressChangeListener);
        }
    }

    void addOffRouteListener(@NonNull OffRouteListener offRouteListener) {
        if (this.offRouteListeners.contains(offRouteListener)) {
            Timber.w((String)"The specified OffRouteListener has already been added to the stack.", (Object[])new Object[0]);
            return;
        }
        this.offRouteListeners.add(offRouteListener);
    }

    void removeOffRouteListener(@Nullable OffRouteListener offRouteListener) {
        if (offRouteListener == null) {
            this.offRouteListeners.clear();
        } else if (!this.offRouteListeners.contains(offRouteListener)) {
            Timber.w((String)"The specified OffRouteListener isn't found in stack, therefore, cannot be removed.", (Object[])new Object[0]);
        } else {
            this.offRouteListeners.remove(offRouteListener);
        }
    }

    void addNavigationEventListener(@NonNull NavigationEventListener navigationEventListener) {
        if (this.navigationEventListeners.contains(navigationEventListener)) {
            Timber.w((String)"The specified NavigationEventListener has already been added to the stack.", (Object[])new Object[0]);
            return;
        }
        this.navigationEventListeners.add(navigationEventListener);
    }

    void removeNavigationEventListener(@Nullable NavigationEventListener navigationEventListener) {
        if (navigationEventListener == null) {
            this.navigationEventListeners.clear();
        } else if (!this.navigationEventListeners.contains(navigationEventListener)) {
            Timber.w((String)"The specified NavigationEventListener isn't found in stack, therefore, cannot be removed.", (Object[])new Object[0]);
        } else {
            this.navigationEventListeners.remove(navigationEventListener);
        }
    }

    void addFasterRouteListener(@NonNull FasterRouteListener fasterRouteListener) {
        if (this.fasterRouteListeners.contains(fasterRouteListener)) {
            Timber.w((String)"The specified FasterRouteListener has already been added to the stack.", (Object[])new Object[0]);
            return;
        }
        this.fasterRouteListeners.add(fasterRouteListener);
    }

    void removeFasterRouteListener(@Nullable FasterRouteListener fasterRouteListener) {
        if (fasterRouteListener == null) {
            this.fasterRouteListeners.clear();
        } else if (!this.fasterRouteListeners.contains(fasterRouteListener)) {
            Timber.w((String)"The specified FasterRouteListener isn't found in stack, therefore, cannot be removed.", (Object[])new Object[0]);
        } else {
            this.fasterRouteListeners.remove(fasterRouteListener);
        }
    }

    void onMilestoneEvent(RouteProgress routeProgress, String instruction, Milestone milestone) {
        this.checkForArrivalEvent(routeProgress);
        for (MilestoneEventListener milestoneEventListener : this.milestoneEventListeners) {
            milestoneEventListener.onMilestoneEvent(routeProgress, instruction, milestone);
        }
    }

    void onProgressChange(Location location, RouteProgress routeProgress) {
        this.sendMetricProgressUpdate(routeProgress);
        for (ProgressChangeListener progressChangeListener : this.progressChangeListeners) {
            progressChangeListener.onProgressChange(location, routeProgress);
        }
    }

    void onUserOffRoute(Location location) {
        for (OffRouteListener offRouteListener : this.offRouteListeners) {
            offRouteListener.userOffRoute(location);
        }
        if (this.metricEventListener != null) {
            this.metricEventListener.onOffRouteEvent(location);
        }
    }

    void onNavigationEvent(boolean isRunning) {
        for (NavigationEventListener navigationEventListener : this.navigationEventListeners) {
            navigationEventListener.onRunning(isRunning);
        }
    }

    void onFasterRouteEvent(DirectionsRoute directionsRoute) {
        for (FasterRouteListener fasterRouteListener : this.fasterRouteListeners) {
            fasterRouteListener.fasterRouteFound(directionsRoute);
        }
    }

    void addMetricEventListeners(NavigationMetricListener eventListeners) {
        if (this.metricEventListener == null) {
            this.metricEventListener = eventListeners;
        }
    }

    private void checkForArrivalEvent(RouteProgress routeProgress) {
        if (this.metricEventListener != null && this.routeUtils.isArrivalEvent(routeProgress)) {
            this.metricEventListener.onArrival(routeProgress);
            if (this.routeUtils.isLastLeg(routeProgress)) {
                this.metricEventListener = null;
            }
        }
    }

    private void sendMetricProgressUpdate(RouteProgress routeProgress) {
        if (this.metricEventListener != null) {
            this.metricEventListener.onRouteProgressUpdate(routeProgress);
        }
    }
}

