/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.support.annotation.NonNull;
import com.mapbox.navigator.Navigator;
import com.mapbox.services.android.navigation.v5.navigation.NavigationLibraryLoader;
import com.mapbox.services.android.navigation.v5.navigation.OfflineNavigator;
import com.mapbox.services.android.navigation.v5.navigation.OfflineRoute;
import com.mapbox.services.android.navigation.v5.navigation.OfflineTileVersions;
import com.mapbox.services.android.navigation.v5.navigation.OfflineTiles;
import com.mapbox.services.android.navigation.v5.navigation.OnOfflineRouteFoundCallback;
import com.mapbox.services.android.navigation.v5.navigation.OnOfflineTilesConfiguredCallback;
import com.mapbox.services.android.navigation.v5.navigation.OnTileVersionsFoundCallback;
import com.mapbox.services.android.navigation.v5.navigation.RouteTileDownloadListener;
import com.mapbox.services.android.navigation.v5.navigation.RouteTileDownloader;
import java.io.File;

public class MapboxOfflineRouter {
    private static final String TILE_PATH_NAME = "tiles";
    private final String tilePath;
    private final OfflineNavigator offlineNavigator;
    private final OfflineTileVersions offlineTileVersions;

    public MapboxOfflineRouter(String offlinePath) {
        File tileDir = new File(offlinePath, TILE_PATH_NAME);
        if (!tileDir.exists()) {
            tileDir.mkdirs();
        }
        this.tilePath = tileDir.getAbsolutePath();
        this.offlineNavigator = new OfflineNavigator(new Navigator());
        this.offlineTileVersions = new OfflineTileVersions();
    }

    MapboxOfflineRouter(String tilePath, OfflineNavigator offlineNavigator, OfflineTileVersions offlineTileVersions) {
        this.tilePath = tilePath;
        this.offlineNavigator = offlineNavigator;
        this.offlineTileVersions = offlineTileVersions;
    }

    public void configure(String version, OnOfflineTilesConfiguredCallback callback) {
        this.offlineNavigator.configure(new File(this.tilePath, version).getAbsolutePath(), callback);
    }

    public void findRoute(@NonNull OfflineRoute route, OnOfflineRouteFoundCallback callback) {
        this.offlineNavigator.retrieveRouteFor(route, callback);
    }

    public void downloadTiles(OfflineTiles offlineTiles, RouteTileDownloadListener listener) {
        new RouteTileDownloader(this.offlineNavigator, this.tilePath, listener).startDownload(offlineTiles);
    }

    public void fetchAvailableTileVersions(String accessToken, OnTileVersionsFoundCallback callback) {
        this.offlineTileVersions.fetchRouteTileVersions(accessToken, callback);
    }

    static {
        NavigationLibraryLoader.load();
    }
}

