/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.location.replay;

import android.app.PendingIntent;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineCallback;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.android.core.location.LocationEngineResult;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.location.replay.ReplayLocationDispatcher;
import com.mapbox.services.android.navigation.v5.location.replay.ReplayRouteLocationConverter;
import com.mapbox.services.android.navigation.v5.location.replay.ReplayRouteLocationListener;
import java.util.ArrayList;
import java.util.List;
import timber.log.Timber;

public class ReplayRouteLocationEngine
implements LocationEngine,
Runnable {
    private static final int HEAD = 0;
    private static final int MOCKED_POINTS_LEFT_THRESHOLD = 5;
    private static final int ONE_SECOND_IN_MILLISECONDS = 1000;
    private static final int FORTY_FIVE_KM_PER_HOUR = 45;
    private static final int DEFAULT_SPEED = 45;
    private static final int ONE_SECOND = 1;
    private static final int DEFAULT_DELAY = 1;
    private static final int DO_NOT_DELAY = 0;
    private static final int ZERO = 0;
    private static final String SPEED_MUST_BE_GREATER_THAN_ZERO_KM_H = "Speed must be greater than 0 km/h.";
    private static final String DELAY_MUST_BE_GREATER_THAN_ZERO_SECONDS = "Delay must be greater than 0 seconds.";
    private static final String REPLAY_ROUTE = "ReplayRouteLocation";
    private ReplayRouteLocationConverter converter;
    private int speed = 45;
    private int delay = 1;
    private Handler handler = new Handler();
    private List<Location> mockedLocations;
    private ReplayLocationDispatcher dispatcher;
    private ReplayRouteLocationListener replayLocationListener;
    private Location lastLocation = null;
    private DirectionsRoute route = null;
    private Point point = null;

    public void assign(DirectionsRoute route) {
        this.route = route;
        this.point = null;
    }

    public void moveTo(Point point) {
        this.point = point;
        this.route = null;
    }

    public void assignLastLocation(Point currentPosition) {
        this.initializeLastLocation();
        this.lastLocation.setLongitude(currentPosition.longitude());
        this.lastLocation.setLatitude(currentPosition.latitude());
    }

    public void updateSpeed(int customSpeedInKmPerHour) {
        if (customSpeedInKmPerHour <= 0) {
            throw new IllegalArgumentException(SPEED_MUST_BE_GREATER_THAN_ZERO_KM_H);
        }
        this.speed = customSpeedInKmPerHour;
    }

    public void updateDelay(int customDelayInSeconds) {
        if (customDelayInSeconds <= 0) {
            throw new IllegalArgumentException(DELAY_MUST_BE_GREATER_THAN_ZERO_SECONDS);
        }
        this.delay = customDelayInSeconds;
    }

    @Override
    public void run() {
        List<Location> nextMockedLocations = this.converter.toLocations();
        if (nextMockedLocations.isEmpty()) {
            if (this.converter.isMultiLegRoute()) {
                nextMockedLocations = this.converter.toLocations();
            } else {
                this.handler.removeCallbacks((Runnable)this);
                return;
            }
        }
        this.dispatcher.add(nextMockedLocations);
        this.mockedLocations.addAll(nextMockedLocations);
        this.scheduleNextDispatch();
    }

    public void getLastLocation(@NonNull LocationEngineCallback<LocationEngineResult> callback) throws SecurityException {
        if (this.lastLocation == null) {
            callback.onFailure(new Exception("Last location can't be null"));
            return;
        }
        callback.onSuccess((Object)LocationEngineResult.create((Location)this.lastLocation));
    }

    public void requestLocationUpdates(@NonNull LocationEngineRequest request, @NonNull LocationEngineCallback<LocationEngineResult> callback, @Nullable Looper looper) throws SecurityException {
        this.beginReplayWith(callback);
    }

    public void requestLocationUpdates(@NonNull LocationEngineRequest request, PendingIntent pendingIntent) throws SecurityException {
        Timber.e((String)"ReplayEngine does not support PendingIntent.", (Object[])new Object[0]);
    }

    public void removeLocationUpdates(@NonNull LocationEngineCallback<LocationEngineResult> callback) {
        this.deactivate();
    }

    public void removeLocationUpdates(PendingIntent pendingIntent) {
        Timber.e((String)"ReplayEngine does not support PendingIntent.", (Object[])new Object[0]);
    }

    void updateLastLocation(Location lastLocation) {
        this.lastLocation = lastLocation;
    }

    void removeLastMockedLocation() {
        if (!this.mockedLocations.isEmpty()) {
            this.mockedLocations.remove(0);
        }
    }

    private void deactivate() {
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
        this.handler.removeCallbacks((Runnable)this);
    }

    private void start(DirectionsRoute route, LocationEngineCallback<LocationEngineResult> callback) {
        this.handler.removeCallbacks((Runnable)this);
        this.converter = new ReplayRouteLocationConverter(route, this.speed, this.delay);
        this.converter.initializeTime();
        this.mockedLocations = this.converter.toLocations();
        this.dispatcher = this.obtainDispatcher(callback);
        this.dispatcher.run();
        this.scheduleNextDispatch();
    }

    private ReplayLocationDispatcher obtainDispatcher(LocationEngineCallback<LocationEngineResult> callback) {
        if (this.dispatcher != null && this.replayLocationListener != null) {
            this.dispatcher.stop();
            this.dispatcher.removeReplayLocationListener(this.replayLocationListener);
        }
        this.dispatcher = new ReplayLocationDispatcher(this.mockedLocations);
        this.replayLocationListener = new ReplayRouteLocationListener(this, callback);
        this.dispatcher.addReplayLocationListener(this.replayLocationListener);
        return this.dispatcher;
    }

    private void startRoute(Point point, Location lastLocation, LocationEngineCallback<LocationEngineResult> callback) {
        this.handler.removeCallbacks((Runnable)this);
        this.converter.updateSpeed(this.speed);
        this.converter.updateDelay(this.delay);
        this.converter.initializeTime();
        LineString route = this.obtainRoute(point, lastLocation);
        this.mockedLocations = this.converter.calculateMockLocations(this.converter.sliceRoute(route));
        this.dispatcher = this.obtainDispatcher(callback);
        this.dispatcher.run();
    }

    @NonNull
    private LineString obtainRoute(Point point, Location lastLocation) {
        ArrayList<Point> pointList = new ArrayList<Point>();
        pointList.add(Point.fromLngLat((double)lastLocation.getLongitude(), (double)lastLocation.getLatitude()));
        pointList.add(point);
        return LineString.fromLngLats(pointList);
    }

    private void scheduleNextDispatch() {
        int currentMockedPoints = this.mockedLocations.size();
        if (currentMockedPoints == 0) {
            this.handler.postDelayed((Runnable)this, 0L);
        } else if (currentMockedPoints <= 5) {
            this.handler.postDelayed((Runnable)this, 1000L);
        } else {
            this.handler.postDelayed((Runnable)this, (long)((currentMockedPoints - 5) * 1000));
        }
    }

    private void beginReplayWith(@NonNull LocationEngineCallback<LocationEngineResult> callback) {
        if (this.route != null) {
            this.start(this.route, callback);
        } else if (this.point != null) {
            if (this.lastLocation == null) {
                callback.onFailure(new Exception("Cannot move to point without last location assigned."));
                return;
            }
            this.startRoute(this.point, this.lastLocation, callback);
        } else {
            callback.onFailure(new Exception("No route found to replay."));
        }
    }

    private void initializeLastLocation() {
        if (this.lastLocation == null) {
            this.lastLocation = new Location(REPLAY_ROUTE);
        }
    }
}

