/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.voice;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.NonNull;
import com.mapbox.services.android.navigation.ui.v5.ConnectivityStatusProvider;
import com.mapbox.services.android.navigation.ui.v5.voice.AndroidSpeechPlayer;
import com.mapbox.services.android.navigation.ui.v5.voice.AudioFocusDelegateProvider;
import com.mapbox.services.android.navigation.ui.v5.voice.MapboxSpeechPlayer;
import com.mapbox.services.android.navigation.ui.v5.voice.NavigationSpeechListener;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechAudioFocusManager;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechListener;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechPlayer;
import com.mapbox.services.android.navigation.ui.v5.voice.VoiceInstructionLoader;
import java.util.ArrayList;
import java.util.List;

public class SpeechPlayerProvider {
    private static final int FIRST_PLAYER = 0;
    private AndroidSpeechPlayer androidSpeechPlayer;
    private List<SpeechPlayer> speechPlayers = new ArrayList<SpeechPlayer>(2);
    private VoiceInstructionLoader voiceInstructionLoader;
    private ConnectivityStatusProvider connectivityStatus;

    public SpeechPlayerProvider(@NonNull Context context, String language, boolean voiceLanguageSupported, VoiceInstructionLoader voiceInstructionLoader) {
        this.initialize(context, language, voiceLanguageSupported, voiceInstructionLoader);
    }

    SpeechPlayerProvider(@NonNull Context context, String language, boolean voiceLanguageSupported, VoiceInstructionLoader voiceInstructionLoader, ConnectivityStatusProvider connectivityStatus) {
        this(context, language, voiceLanguageSupported, voiceInstructionLoader);
        this.connectivityStatus = connectivityStatus;
    }

    SpeechPlayer retrieveSpeechPlayer() {
        if (this.voiceInstructionLoader.hasCache() || this.connectivityStatus.isConnectedFast()) {
            return this.speechPlayers.get(0);
        }
        return this.androidSpeechPlayer;
    }

    AndroidSpeechPlayer retrieveAndroidSpeechPlayer() {
        return this.androidSpeechPlayer;
    }

    void setMuted(boolean isMuted) {
        for (SpeechPlayer player : this.speechPlayers) {
            player.setMuted(isMuted);
        }
    }

    void onOffRoute() {
        for (SpeechPlayer player : this.speechPlayers) {
            player.onOffRoute();
        }
    }

    void onDestroy() {
        for (SpeechPlayer player : this.speechPlayers) {
            player.onDestroy();
        }
    }

    private void initialize(@NonNull Context context, String language, boolean voiceLanguageSupported, VoiceInstructionLoader voiceInstructionLoader) {
        AudioFocusDelegateProvider provider = this.buildAudioFocusDelegateProvider(context);
        SpeechAudioFocusManager audioFocusManager = new SpeechAudioFocusManager(provider);
        NavigationSpeechListener speechListener = new NavigationSpeechListener(this, audioFocusManager);
        this.initializeMapboxSpeechPlayer(context, language, voiceLanguageSupported, speechListener, voiceInstructionLoader);
        this.initializeAndroidSpeechPlayer(context, language, speechListener);
        this.voiceInstructionLoader = voiceInstructionLoader;
        this.connectivityStatus = new ConnectivityStatusProvider(context);
    }

    private AudioFocusDelegateProvider buildAudioFocusDelegateProvider(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return new AudioFocusDelegateProvider(audioManager);
    }

    private void initializeMapboxSpeechPlayer(Context context, String language, boolean voiceLanguageSupported, SpeechListener listener, VoiceInstructionLoader voiceInstructionLoader) {
        if (!voiceLanguageSupported) {
            return;
        }
        voiceInstructionLoader.setupMapboxSpeechBuilder(language);
        MapboxSpeechPlayer mapboxSpeechPlayer = new MapboxSpeechPlayer(context, listener, voiceInstructionLoader);
        this.speechPlayers.add(mapboxSpeechPlayer);
    }

    private void initializeAndroidSpeechPlayer(Context context, String language, SpeechListener listener) {
        this.androidSpeechPlayer = new AndroidSpeechPlayer(context, language, listener);
        this.speechPlayers.add(this.androidSpeechPlayer);
    }
}

