/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.voice;

import android.support.annotation.NonNull;
import com.mapbox.services.android.navigation.ui.v5.voice.VoiceInstructionLoader;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import timber.log.Timber;

class InstructionCacheCallback
implements Callback<ResponseBody> {
    private final VoiceInstructionLoader loader;

    InstructionCacheCallback(VoiceInstructionLoader loader) {
        this.loader = loader;
    }

    public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
        if (this.closeResponseBody(response)) {
            String url = call.request().url().toString();
            this.loader.addCachedUrl(url);
        }
    }

    public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable throwable) {
        Timber.e((Throwable)throwable, (String)"onFailure cache instruction", (Object[])new Object[0]);
    }

    private boolean closeResponseBody(@NonNull Response<ResponseBody> response) {
        ResponseBody body = (ResponseBody)response.body();
        if (body != null) {
            body.byteStream();
            body.close();
            return true;
        }
        return false;
    }
}

