/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.route;

import android.support.annotation.NonNull;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.services.android.navigation.ui.v5.route.MapRouteLine;
import com.mapbox.services.android.navigation.ui.v5.route.OnRouteSelectionChangeListener;
import com.mapbox.turf.TurfMeasurement;
import com.mapbox.turf.TurfMisc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class MapRouteClickListener
implements MapboxMap.OnMapClickListener {
    private final MapRouteLine routeLine;
    private OnRouteSelectionChangeListener onRouteSelectionChangeListener;
    private boolean alternativesVisible = true;

    MapRouteClickListener(MapRouteLine routeLine) {
        this.routeLine = routeLine;
    }

    public boolean onMapClick(@NonNull LatLng point) {
        HashMap<LineString, DirectionsRoute> routeLineStrings = this.routeLine.retrieveRouteLineStrings();
        if (this.invalidMapClick(routeLineStrings)) {
            return false;
        }
        List<DirectionsRoute> directionsRoutes = this.routeLine.retrieveDirectionsRoutes();
        this.findClickedRoute(point, routeLineStrings, directionsRoutes);
        return false;
    }

    void setOnRouteSelectionChangeListener(OnRouteSelectionChangeListener listener) {
        this.onRouteSelectionChangeListener = listener;
    }

    void updateAlternativesVisible(boolean alternativesVisible) {
        this.alternativesVisible = alternativesVisible;
    }

    private boolean invalidMapClick(HashMap<LineString, DirectionsRoute> routeLineStrings) {
        return routeLineStrings == null || routeLineStrings.isEmpty() || !this.alternativesVisible;
    }

    private void findClickedRoute(@NonNull LatLng point, HashMap<LineString, DirectionsRoute> routeLineStrings, List<DirectionsRoute> directionsRoutes) {
        HashMap<Double, DirectionsRoute> routeDistancesAwayFromClick = new HashMap<Double, DirectionsRoute>();
        Point clickPoint = Point.fromLngLat((double)point.getLongitude(), (double)point.getLatitude());
        this.calculateClickDistances(routeDistancesAwayFromClick, clickPoint, routeLineStrings);
        ArrayList<Double> distancesAwayFromClick = new ArrayList<Double>(routeDistancesAwayFromClick.keySet());
        Collections.sort(distancesAwayFromClick);
        DirectionsRoute clickedRoute = routeDistancesAwayFromClick.get(distancesAwayFromClick.get(0));
        int newPrimaryRouteIndex = directionsRoutes.indexOf(clickedRoute);
        if (this.routeLine.updatePrimaryRouteIndex(newPrimaryRouteIndex) && this.onRouteSelectionChangeListener != null) {
            DirectionsRoute selectedRoute = directionsRoutes.get(newPrimaryRouteIndex);
            this.onRouteSelectionChangeListener.onNewPrimaryRouteSelected(selectedRoute);
        }
    }

    private void calculateClickDistances(HashMap<Double, DirectionsRoute> routeDistancesAwayFromClick, Point clickPoint, HashMap<LineString, DirectionsRoute> routeLineStrings) {
        for (LineString lineString : routeLineStrings.keySet()) {
            Point pointOnLine = this.findPointOnLine(clickPoint, lineString);
            if (pointOnLine == null) {
                return;
            }
            double distance = TurfMeasurement.distance((Point)clickPoint, (Point)pointOnLine, (String)"meters");
            routeDistancesAwayFromClick.put(distance, routeLineStrings.get(lineString));
        }
    }

    private Point findPointOnLine(Point clickPoint, LineString lineString) {
        List linePoints = lineString.coordinates();
        Feature feature = TurfMisc.nearestPointOnLine((Point)clickPoint, (List)linePoints);
        return (Point)feature.geometry();
    }
}

