/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.instruction.maneuver;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.RectF;
import com.mapbox.services.android.navigation.ui.v5.instruction.maneuver.PaintCodeDashPathEffect;
import java.util.Stack;

public class ManeuversStyleKit {
    public static void drawArrow180Right(Canvas canvas, int primaryColor, PointF size) {
        ManeuversStyleKit.drawArrow180Right(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, size);
    }

    public static void drawArrow180Right(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, PointF size) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForArrow180right.paint;
        float x = size.x / 2.0f;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float y = size.y / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForArrow180right.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForArrow180right.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForArrow180right.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(x, y + 1.0f);
        ((Matrix)currentTransformation.peek()).postTranslate(x, y + 1.0f);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezierRect = CacheForArrow180right.bezierRect;
        bezierRect.set(-3.49f, 1.0f, 14.51f, 14.99f);
        Path bezierPath = CacheForArrow180right.bezierPath;
        bezierPath.reset();
        bezierPath.moveTo(-3.36f, 2.8f);
        bezierPath.lineTo(5.51f, 14.99f);
        bezierPath.lineTo(14.37f, 2.8f);
        bezierPath.cubicTo(14.45f, 2.71f, 14.51f, 2.59f, 14.51f, 2.46f);
        bezierPath.cubicTo(14.51f, 2.19f, 14.28f, 1.96f, 14.01f, 1.96f);
        bezierPath.cubicTo(13.97f, 1.96f, 13.89f, 1.97f, 13.89f, 1.97f);
        bezierPath.lineTo(8.15f, 3.94f);
        bezierPath.cubicTo(8.11f, 3.95f, 8.06f, 3.96f, 8.01f, 3.96f);
        bezierPath.cubicTo(7.74f, 3.96f, 7.51f, 3.76f, 7.51f, 3.5f);
        bezierPath.cubicTo(7.51f, 3.13f, 7.51f, 1.0f, 7.51f, 1.0f);
        bezierPath.lineTo(5.51f, 1.0f);
        bezierPath.lineTo(3.5f, 1.0f);
        bezierPath.cubicTo(3.5f, 1.0f, 3.51f, 3.13f, 3.51f, 3.5f);
        bezierPath.cubicTo(3.51f, 3.76f, 3.28f, 3.97f, 3.01f, 3.97f);
        bezierPath.cubicTo(2.96f, 3.97f, 2.91f, 3.96f, 2.86f, 3.95f);
        bezierPath.lineTo(-2.88f, 1.98f);
        bezierPath.cubicTo(-2.88f, 1.98f, -2.95f, 1.96f, -2.99f, 1.96f);
        bezierPath.cubicTo(-3.27f, 1.96f, -3.49f, 2.19f, -3.49f, 2.46f);
        bezierPath.cubicTo(-3.49f, 2.59f, -3.44f, 2.71f, -3.36f, 2.8f);
        bezierPath.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezierPath, paint);
        RectF bezier2Rect = CacheForArrow180right.bezier2Rect;
        bezier2Rect.set(-7.5f, -12.0f, 5.5f, 15.0f);
        Path bezier2Path = CacheForArrow180right.bezier2Path;
        bezier2Path.reset();
        bezier2Path.moveTo(-7.5f, 15.0f);
        bezier2Path.lineTo(-7.5f, -5.16f);
        bezier2Path.cubicTo(-7.5f, -8.91f, -4.55f, -12.0f, -1.0f, -12.0f);
        bezier2Path.cubicTo(2.59f, -12.0f, 5.5f, -8.72f, 5.5f, -5.15f);
        bezier2Path.lineTo(5.5f, 4.0f);
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeMiter(10.0f);
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier2Path, paint);
        canvas.restore();
        canvas.restore();
        canvas.restore();
    }

    public static void drawArrowRight(Canvas canvas, int primaryColor, PointF size) {
        ManeuversStyleKit.drawArrowRight(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, size);
    }

    public static void drawArrowRight(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, PointF size) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForArrowright.paint;
        float y = size.y / 2.0f;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float x = size.x / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForArrowright.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForArrowright.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForArrowright.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(x, y + 1.0f);
        ((Matrix)currentTransformation.peek()).postTranslate(x, y + 1.0f);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezierRect = CacheForArrowright.bezierRect;
        bezierRect.set(-14.01f, -15.01f, 14.01f, 15.01f);
        Path bezierPath = CacheForArrowright.bezierPath;
        bezierPath.reset();
        bezierPath.moveTo(-10.01f, 15.01f);
        bezierPath.lineTo(-10.01f, 1.0f);
        bezierPath.cubicTo(-10.0f, 0.49f, -9.84f, -3.99f, -5.05f, -3.99f);
        bezierPath.lineTo(2.57f, -3.99f);
        bezierPath.cubicTo(2.8f, -3.95f, 2.98f, -3.75f, 2.98f, -3.51f);
        bezierPath.cubicTo(2.98f, -3.46f, 2.97f, -3.41f, 2.96f, -3.36f);
        bezierPath.lineTo(0.99f, 2.38f);
        bezierPath.cubicTo(0.99f, 2.38f, 0.98f, 2.45f, 0.98f, 2.49f);
        bezierPath.cubicTo(0.98f, 2.77f, 1.2f, 2.99f, 1.48f, 2.99f);
        bezierPath.cubicTo(1.61f, 2.99f, 1.73f, 2.94f, 1.82f, 2.86f);
        bezierPath.lineTo(14.01f, -6.01f);
        bezierPath.lineTo(1.82f, -14.87f);
        bezierPath.cubicTo(1.73f, -14.95f, 1.61f, -15.01f, 1.48f, -15.01f);
        bezierPath.cubicTo(1.2f, -15.01f, 0.98f, -14.78f, 0.98f, -14.51f);
        bezierPath.cubicTo(0.98f, -14.47f, 0.99f, -14.4f, 0.99f, -14.4f);
        bezierPath.lineTo(2.96f, -8.65f);
        bezierPath.cubicTo(2.97f, -8.61f, 2.98f, -8.56f, 2.98f, -8.51f);
        bezierPath.cubicTo(2.98f, -8.24f, 2.76f, -8.01f, 2.5f, -8.01f);
        bezierPath.cubicTo(2.14f, -8.01f, -5.05f, -7.99f, -5.05f, -7.99f);
        bezierPath.cubicTo(-11.58f, -7.99f, -13.99f, -2.63f, -14.01f, 0.99f);
        bezierPath.lineTo(-14.01f, 15.01f);
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezierPath, paint);
        canvas.restore();
        canvas.restore();
    }

    public static void drawArrowSlightRight(Canvas canvas, int primaryColor, PointF size) {
        ManeuversStyleKit.drawArrowSlightRight(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, size);
    }

    public static void drawArrowSlightRight(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, PointF size) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForArrowslightright.paint;
        float x = size.x / 2.0f;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float y = size.y / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForArrowslightright.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForArrowslightright.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForArrowslightright.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(x + 1.0f, y + 1.0f);
        ((Matrix)currentTransformation.peek()).postTranslate(x + 1.0f, y + 1.0f);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezier3Rect = CacheForArrowslightright.bezier3Rect;
        bezier3Rect.set(-8.34f, -5.09f, 0.99f, 15.06f);
        Path bezier3Path = CacheForArrowslightright.bezier3Path;
        bezier3Path.reset();
        bezier3Path.moveTo(0.99f, -5.09f);
        bezier3Path.lineTo(-6.55f, 1.88f);
        bezier3Path.cubicTo(-7.71f, 3.63f, -8.34f, 5.75f, -8.34f, 7.93f);
        bezier3Path.lineTo(-8.34f, 15.06f);
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeMiter(10.0f);
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier3Path, paint);
        canvas.restore();
        RectF bezier4Rect = CacheForArrowslightright.bezier4Rect;
        bezier4Rect.set(-3.5f, -12.76f, 9.88f, 0.3f);
        Path bezier4Path = CacheForArrowslightright.bezier4Path;
        bezier4Path.reset();
        bezier4Path.moveTo(-2.97f, -12.04f);
        bezier4Path.lineTo(9.88f, -12.76f);
        bezier4Path.lineTo(7.31f, -0.15f);
        bezier4Path.cubicTo(7.3f, -0.02f, 7.24f, 0.09f, 7.15f, 0.18f);
        bezier4Path.cubicTo(6.94f, 0.36f, 6.62f, 0.34f, 6.44f, 0.13f);
        bezier4Path.cubicTo(6.41f, 0.1f, 6.38f, 0.03f, 6.38f, 0.03f);
        bezier4Path.lineTo(4.0f, -4.19f);
        bezier4Path.cubicTo(3.99f, -4.23f, 3.96f, -4.27f, 3.93f, -4.31f);
        bezier4Path.cubicTo(3.75f, -4.51f, 3.25f, -4.38f, 3.05f, -4.21f);
        bezier4Path.cubicTo(2.78f, -3.98f, 0.97f, -2.41f, 0.97f, -2.41f);
        bezier4Path.lineTo(-0.34f, -3.92f);
        bezier4Path.lineTo(-1.65f, -5.44f);
        bezier4Path.cubicTo(-1.65f, -5.44f, 0.16f, -7.0f, 0.43f, -7.24f);
        bezier4Path.cubicTo(0.63f, -7.41f, 0.74f, -7.81f, 0.57f, -8.01f);
        bezier4Path.cubicTo(0.53f, -8.05f, 0.54f, -8.12f, 0.5f, -8.15f);
        bezier4Path.lineTo(-3.31f, -11.12f);
        bezier4Path.cubicTo(-3.31f, -11.12f, -3.36f, -11.18f, -3.38f, -11.21f);
        bezier4Path.cubicTo(-3.56f, -11.42f, -3.53f, -11.74f, -3.32f, -11.92f);
        bezier4Path.cubicTo(-3.22f, -12.01f, -3.09f, -12.05f, -2.97f, -12.04f);
        bezier4Path.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier4Path, paint);
        RectF clipRect = CacheForArrowslightright.clipRect;
        clipRect.set(-10.2f, -13.7f, 10.2f, 13.05f);
        canvas.restore();
        canvas.restore();
    }

    public static void drawArrowStraight(Canvas canvas, int primaryColor, PointF size) {
        ManeuversStyleKit.drawArrowStraight(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, size);
    }

    public static void drawArrowStraight(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, PointF size) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForArrowstraight.paint;
        float y = size.y / 2.0f;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float x = size.x / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForArrowstraight.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForArrowstraight.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForArrowstraight.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(x, y + 1.0f);
        ((Matrix)currentTransformation.peek()).postTranslate(x, y + 1.0f);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezierRect = CacheForArrowstraight.bezierRect;
        bezierRect.set(-9.0f, -15.02f, 9.0f, 15.02f);
        Path bezierPath = CacheForArrowstraight.bezierPath;
        bezierPath.reset();
        bezierPath.moveTo(8.86f, -2.82f);
        bezierPath.lineTo(0.0f, -15.02f);
        bezierPath.lineTo(-8.86f, -2.82f);
        bezierPath.cubicTo(-8.95f, -2.73f, -9.0f, -2.62f, -9.0f, -2.48f);
        bezierPath.cubicTo(-9.0f, -2.21f, -8.78f, -1.98f, -8.5f, -1.98f);
        bezierPath.cubicTo(-8.46f, -1.98f, -8.39f, -2.0f, -8.39f, -2.0f);
        bezierPath.lineTo(-2.64f, -3.96f);
        bezierPath.cubicTo(-2.6f, -3.98f, -2.55f, -3.98f, -2.5f, -3.98f);
        bezierPath.cubicTo(-2.23f, -3.98f, -2.0f, -3.76f, -2.0f, -3.5f);
        bezierPath.lineTo(-2.0f, 15.02f);
        bezierPath.lineTo(2.0f, 15.02f);
        bezierPath.cubicTo(2.0f, 15.02f, 2.0f, -3.14f, 2.0f, -3.5f);
        bezierPath.cubicTo(2.0f, -3.76f, 2.23f, -3.98f, 2.5f, -3.98f);
        bezierPath.cubicTo(2.55f, -3.98f, 2.6f, -3.98f, 2.64f, -3.96f);
        bezierPath.lineTo(8.39f, -2.0f);
        bezierPath.cubicTo(8.39f, -2.0f, 8.46f, -1.98f, 8.5f, -1.98f);
        bezierPath.cubicTo(8.78f, -1.98f, 9.0f, -2.21f, 9.0f, -2.48f);
        bezierPath.cubicTo(9.0f, -2.62f, 8.95f, -2.73f, 8.86f, -2.82f);
        bezierPath.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezierPath, paint);
        canvas.restore();
        canvas.restore();
    }

    public static void drawArrowSharpRight(Canvas canvas, int primaryColor, PointF size) {
        ManeuversStyleKit.drawArrowSharpRight(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, size);
    }

    public static void drawArrowSharpRight(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, PointF size) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForArrowsharpright.paint;
        float x = size.x / 2.0f;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float y = size.y / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForArrowsharpright.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForArrowsharpright.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForArrowsharpright.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(x, y);
        ((Matrix)currentTransformation.peek()).postTranslate(x, y);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezierRect = CacheForArrowsharpright.bezierRect;
        bezierRect.set(-2.12f, -7.97f, 13.13f, 7.5f);
        Path bezierPath = CacheForArrowsharpright.bezierPath;
        bezierPath.reset();
        bezierPath.moveTo(-1.66f, 4.57f);
        bezierPath.lineTo(13.13f, 7.5f);
        bezierPath.lineTo(11.36f, -7.47f);
        bezierPath.cubicTo(11.36f, -7.59f, 11.32f, -7.71f, 11.23f, -7.81f);
        bezierPath.cubicTo(11.04f, -8.01f, 10.73f, -8.03f, 10.52f, -7.84f);
        bezierPath.cubicTo(10.49f, -7.81f, 10.45f, -7.75f, 10.45f, -7.75f);
        bezierPath.lineTo(7.57f, -2.41f);
        bezierPath.cubicTo(7.54f, -2.37f, 7.51f, -2.33f, 7.48f, -2.3f);
        bezierPath.cubicTo(7.28f, -2.11f, 6.96f, -2.12f, 6.78f, -2.31f);
        bezierPath.cubicTo(6.54f, -2.57f, 5.09f, -4.15f, 5.09f, -4.15f);
        bezierPath.lineTo(3.61f, -2.79f);
        bezierPath.lineTo(2.14f, -1.43f);
        bezierPath.cubicTo(2.14f, -1.43f, 3.6f, 0.14f, 3.85f, 0.41f);
        bezierPath.cubicTo(4.02f, 0.6f, 4.01f, 0.92f, 3.81f, 1.1f);
        bezierPath.cubicTo(3.77f, 1.14f, 3.73f, 1.16f, 3.69f, 1.18f);
        bezierPath.lineTo(-1.87f, 3.64f);
        bezierPath.cubicTo(-1.87f, 3.64f, -1.93f, 3.68f, -1.96f, 3.7f);
        bezierPath.cubicTo(-2.16f, 3.89f, -2.17f, 4.21f, -1.99f, 4.41f);
        bezierPath.cubicTo(-1.9f, 4.51f, -1.78f, 4.56f, -1.66f, 4.57f);
        bezierPath.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezierPath, paint);
        RectF bezier3Rect = CacheForArrowsharpright.bezier3Rect;
        bezier3Rect.set(-11.12f, -8.5f, 4.88f, 16.0f);
        Path bezier3Path = CacheForArrowsharpright.bezier3Path;
        bezier3Path.reset();
        bezier3Path.moveTo(-11.12f, -4.0f);
        bezier3Path.cubicTo(-11.12f, -4.0f, -11.33f, -8.5f, -6.62f, -8.5f);
        bezier3Path.cubicTo(-1.91f, -8.5f, 1.88f, -4.5f, 1.88f, -4.5f);
        bezier3Path.lineTo(4.88f, -1.5f);
        bezier3Path.moveTo(-11.12f, -4.5f);
        bezier3Path.lineTo(-11.12f, 1.5f);
        bezier3Path.moveTo(-11.12f, 1.5f);
        bezier3Path.lineTo(-11.12f, 3.5f);
        bezier3Path.moveTo(-11.12f, 3.5f);
        bezier3Path.lineTo(-11.12f, 12.98f);
        bezier3Path.lineTo(-11.12f, 16.0f);
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeMiter(10.0f);
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier3Path, paint);
        canvas.restore();
        canvas.restore();
        canvas.restore();
    }

    public static void drawArrive(Canvas canvas, int primaryColor, PointF size) {
        ManeuversStyleKit.drawArrive(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, size);
    }

    public static void drawArrive(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, PointF size) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForArrive.paint;
        float x = size.x / 2.0f;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float y = size.y / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForArrive.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForArrive.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForArrive.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(x, y + 1.0f);
        ((Matrix)currentTransformation.peek()).postTranslate(x, y + 1.0f);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezierRect = CacheForArrive.bezierRect;
        bezierRect.set(0.06f, 6.6f, 0.06f, 15.0f);
        Path bezierPath = CacheForArrive.bezierPath;
        bezierPath.reset();
        bezierPath.moveTo(0.06f, 6.6f);
        bezierPath.lineTo(0.06f, 15.0f);
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeMiter(10.0f);
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(primaryColor);
        canvas.drawPath(bezierPath, paint);
        canvas.restore();
        RectF bezier2Rect = CacheForArrive.bezier2Rect;
        bezier2Rect.set(-8.0f, -9.03f, 8.0f, 2.48f);
        Path bezier2Path = CacheForArrive.bezier2Path;
        bezier2Path.reset();
        bezier2Path.moveTo(-2.0f, 2.48f);
        bezier2Path.cubicTo(-2.0f, 2.48f, -2.0f, 2.09f, -2.0f, 1.73f);
        bezier2Path.cubicTo(-2.0f, 1.46f, -2.23f, 1.12f, -2.5f, 1.12f);
        bezier2Path.cubicTo(-2.55f, 1.12f, -2.6f, 1.07f, -2.64f, 1.08f);
        bezier2Path.lineTo(-7.39f, 2.02f);
        bezier2Path.cubicTo(-7.39f, 2.02f, -7.46f, 2.01f, -7.5f, 2.01f);
        bezier2Path.cubicTo(-7.78f, 2.01f, -8.0f, 1.78f, -8.0f, 1.51f);
        bezier2Path.cubicTo(-8.0f, 1.37f, -7.95f, 1.25f, -7.86f, 1.16f);
        bezier2Path.lineTo(0.0f, -9.03f);
        bezier2Path.lineTo(7.86f, 1.16f);
        bezier2Path.cubicTo(7.95f, 1.25f, 8.0f, 1.37f, 8.0f, 1.5f);
        bezier2Path.cubicTo(8.0f, 1.77f, 7.78f, 2.0f, 7.5f, 2.0f);
        bezier2Path.cubicTo(7.46f, 2.0f, 7.39f, 1.99f, 7.39f, 1.99f);
        bezier2Path.lineTo(2.64f, 1.02f);
        bezier2Path.cubicTo(2.6f, 1.01f, 2.55f, 1.0f, 2.5f, 1.0f);
        bezier2Path.cubicTo(2.23f, 1.0f, 2.0f, 1.46f, 2.0f, 1.73f);
        bezier2Path.cubicTo(2.0f, 2.09f, 2.0f, 2.48f, 2.0f, 2.48f);
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier2Path, paint);
        RectF ovalRect = CacheForArrive.ovalRect;
        ovalRect.set(-3.0f, -16.6f, 3.1f, -10.5f);
        Path ovalPath = CacheForArrive.ovalPath;
        ovalPath.reset();
        ovalPath.addOval(ovalRect, Path.Direction.CW);
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(ovalPath, paint);
        RectF rectangleRect = CacheForArrive.rectangleRect;
        rectangleRect.set(-2.0f, 3.63f, 2.0f, 5.58f);
        Path rectanglePath = CacheForArrive.rectanglePath;
        rectanglePath.reset();
        rectanglePath.moveTo(rectangleRect.left, rectangleRect.top);
        rectanglePath.lineTo(rectangleRect.right, rectangleRect.top);
        rectanglePath.lineTo(rectangleRect.right, rectangleRect.bottom);
        rectanglePath.lineTo(rectangleRect.left, rectangleRect.bottom);
        rectanglePath.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(rectanglePath, paint);
        canvas.restore();
        canvas.restore();
    }

    public static void drawStarting(Canvas canvas, int primaryColor, PointF size) {
        ManeuversStyleKit.drawStarting(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, size);
    }

    public static void drawStarting(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, PointF size) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForStarting.paint;
        float y = size.y / 2.0f;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float x = size.x / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForStarting.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForStarting.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForStarting.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(x, y);
        ((Matrix)currentTransformation.peek()).postTranslate(x, y);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezier2Rect = CacheForStarting.bezier2Rect;
        bezier2Rect.set(-10.0f, -10.5f, 10.0f, 10.5f);
        Path bezier2Path = CacheForStarting.bezier2Path;
        bezier2Path.reset();
        bezier2Path.moveTo(0.0f, -10.5f);
        bezier2Path.lineTo(-10.0f, 10.5f);
        bezier2Path.lineTo(0.07f, 4.2f);
        bezier2Path.lineTo(10.0f, 10.5f);
        bezier2Path.lineTo(0.0f, -10.5f);
        bezier2Path.close();
        paint.reset();
        paint.setFlags(1);
        bezier2Path.setFillType(Path.FillType.EVEN_ODD);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier2Path, paint);
        canvas.restore();
        canvas.restore();
    }

    public static void drawDestination(Canvas canvas, int primaryColor, PointF size) {
        ManeuversStyleKit.drawDestination(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, size);
    }

    public static void drawDestination(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, PointF size) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForDestination.paint;
        float y = size.y / 2.0f;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float x = size.x / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForDestination.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForDestination.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForDestination.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(x, y);
        ((Matrix)currentTransformation.peek()).postTranslate(x, y);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezierRect = CacheForDestination.bezierRect;
        bezierRect.set(-8.0f, -12.0f, 8.0f, 12.0f);
        Path bezierPath = CacheForDestination.bezierPath;
        bezierPath.reset();
        bezierPath.moveTo(0.0f, -7.0f);
        bezierPath.cubicTo(-0.34f, -7.0f, -0.66f, -6.94f, -0.97f, -6.84f);
        bezierPath.cubicTo(-2.15f, -6.44f, -3.0f, -5.32f, -3.0f, -4.0f);
        bezierPath.cubicTo(-3.0f, -2.34f, -1.66f, -1.0f, 0.0f, -1.0f);
        bezierPath.cubicTo(1.66f, -1.0f, 3.0f, -2.34f, 3.0f, -4.0f);
        bezierPath.cubicTo(3.0f, -5.66f, 1.66f, -7.0f, 0.0f, -7.0f);
        bezierPath.close();
        bezierPath.moveTo(8.0f, -4.0f);
        bezierPath.cubicTo(8.0f, 0.42f, 4.0f, 3.0f, 0.0f, 12.0f);
        bezierPath.cubicTo(-4.0f, 3.0f, -8.0f, 0.42f, -8.0f, -4.0f);
        bezierPath.cubicTo(-8.0f, -6.36f, -6.98f, -8.49f, -5.35f, -9.95f);
        bezierPath.cubicTo(-4.83f, -10.42f, -4.25f, -10.81f, -3.63f, -11.13f);
        bezierPath.cubicTo(-2.54f, -11.69f, -1.31f, -12.0f, 0.0f, -12.0f);
        bezierPath.cubicTo(4.42f, -12.0f, 8.0f, -8.42f, 8.0f, -4.0f);
        bezierPath.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezierPath, paint);
        canvas.restore();
        canvas.restore();
    }

    public static void drawMerge(Canvas canvas, int primaryColor, int secondaryColor, PointF size) {
        ManeuversStyleKit.drawMerge(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, secondaryColor, size);
    }

    public static void drawMerge(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, int secondaryColor, PointF size) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForMerge.paint;
        float x = size.x / 2.0f;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float y = size.y / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForMerge.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForMerge.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForMerge.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(x, y + 1.0f);
        ((Matrix)currentTransformation.peek()).postTranslate(x, y + 1.0f);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezierRect = CacheForMerge.bezierRect;
        bezierRect.set(0.07f, -10.51f, 8.07f, 15.0f);
        Path bezierPath = CacheForMerge.bezierPath;
        bezierPath.reset();
        bezierPath.moveTo(8.07f, 15.0f);
        bezierPath.lineTo(8.07f, 12.47f);
        bezierPath.cubicTo(8.07f, 10.53f, 7.44f, 8.65f, 6.28f, 7.1f);
        bezierPath.lineTo(1.86f, 1.19f);
        bezierPath.cubicTo(0.69f, -0.36f, 0.07f, -2.25f, 0.07f, -4.19f);
        bezierPath.lineTo(0.07f, -10.51f);
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeMiter(10.0f);
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(secondaryColor);
        canvas.drawPath(bezierPath, paint);
        canvas.restore();
        RectF bezier2Rect = CacheForMerge.bezier2Rect;
        bezier2Rect.set(-8.06f, -10.6f, -0.06f, 15.0f);
        Path bezier2Path = CacheForMerge.bezier2Path;
        bezier2Path.reset();
        bezier2Path.moveTo(-8.06f, 15.0f);
        bezier2Path.lineTo(-8.06f, 12.39f);
        bezier2Path.cubicTo(-8.06f, 10.45f, -7.43f, 8.56f, -6.27f, 7.01f);
        bezier2Path.lineTo(-1.85f, 1.11f);
        bezier2Path.cubicTo(-0.69f, -0.45f, -0.06f, -2.33f, -0.06f, -4.27f);
        bezier2Path.lineTo(-0.06f, -10.6f);
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeMiter(10.0f);
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier2Path, paint);
        canvas.restore();
        RectF bezier3Rect = CacheForMerge.bezier3Rect;
        bezier3Rect.set(-8.07f, -16.48f, 7.93f, -2.96f);
        Path bezier3Path = CacheForMerge.bezier3Path;
        bezier3Path.reset();
        bezier3Path.moveTo(7.8f, -6.29f);
        bezier3Path.lineTo(-0.07f, -16.48f);
        bezier3Path.lineTo(-7.93f, -6.29f);
        bezier3Path.cubicTo(-8.01f, -6.2f, -8.07f, -6.08f, -8.07f, -5.95f);
        bezier3Path.cubicTo(-8.07f, -5.67f, -7.84f, -5.45f, -7.57f, -5.45f);
        bezier3Path.cubicTo(-7.53f, -5.45f, -7.45f, -5.46f, -7.45f, -5.46f);
        bezier3Path.lineTo(-2.71f, -6.43f);
        bezier3Path.cubicTo(-2.66f, -6.44f, -2.62f, -6.45f, -2.57f, -6.45f);
        bezier3Path.cubicTo(-2.3f, -6.45f, -2.07f, -5.98f, -2.07f, -5.72f);
        bezier3Path.cubicTo(-2.07f, -5.36f, -2.07f, -2.96f, -2.07f, -2.96f);
        bezier3Path.lineTo(-0.07f, -2.96f);
        bezier3Path.lineTo(1.94f, -2.96f);
        bezier3Path.cubicTo(1.94f, -2.96f, 1.93f, -5.36f, 1.93f, -5.72f);
        bezier3Path.cubicTo(1.93f, -5.98f, 2.16f, -6.33f, 2.43f, -6.33f);
        bezier3Path.cubicTo(2.48f, -6.33f, 2.53f, -6.38f, 2.58f, -6.37f);
        bezier3Path.lineTo(7.32f, -5.43f);
        bezier3Path.cubicTo(7.32f, -5.43f, 7.4f, -5.43f, 7.43f, -5.43f);
        bezier3Path.cubicTo(7.71f, -5.43f, 7.93f, -5.66f, 7.93f, -5.94f);
        bezier3Path.cubicTo(7.93f, -6.07f, 7.88f, -6.2f, 7.8f, -6.29f);
        bezier3Path.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier3Path, paint);
        canvas.restore();
        canvas.restore();
    }

    public static void drawFork(Canvas canvas, int primaryColor, int secondaryColor, PointF size) {
        ManeuversStyleKit.drawFork(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, secondaryColor, size);
    }

    public static void drawFork(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, int secondaryColor, PointF size) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForFork.paint;
        float x = size.x / 2.0f;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float y = size.y / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForFork.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForFork.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForFork.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(x + 2.99f, y);
        ((Matrix)currentTransformation.peek()).postTranslate(x + 2.99f, y);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezierRect = CacheForFork.bezierRect;
        bezierRect.set(-12.57f, -12.73f, -3.99f, 16.0f);
        Path bezierPath = CacheForFork.bezierPath;
        bezierPath.reset();
        bezierPath.moveTo(-3.99f, 16.0f);
        bezierPath.lineTo(-3.99f, 9.0f);
        bezierPath.cubicTo(-3.99f, 7.06f, -4.74f, 5.17f, -5.9f, 3.62f);
        bezierPath.lineTo(-10.32f, -2.29f);
        bezierPath.cubicTo(-11.48f, -3.84f, -12.57f, -5.73f, -12.57f, -7.67f);
        bezierPath.lineTo(-12.57f, -12.73f);
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeMiter(10.0f);
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(secondaryColor);
        canvas.drawPath(bezierPath, paint);
        canvas.restore();
        RectF bezier2Rect = CacheForFork.bezier2Rect;
        bezier2Rect.set(-3.99f, -2.2f, 2.23f, 16.0f);
        Path bezier2Path = CacheForFork.bezier2Path;
        bezier2Path.reset();
        bezier2Path.moveTo(2.23f, -2.2f);
        bezier2Path.lineTo(-2.2f, 3.7f);
        bezier2Path.cubicTo(-3.36f, 5.25f, -3.99f, 7.06f, -3.99f, 9.0f);
        bezier2Path.lineTo(-3.99f, 16.0f);
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeMiter(10.0f);
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier2Path, paint);
        canvas.restore();
        RectF bezier3Rect = CacheForFork.bezier3Rect;
        bezier3Rect.set(-2.99f, -13.42f, 10.58f, 0.0f);
        Path bezier3Path = CacheForFork.bezier3Path;
        bezier3Path.reset();
        bezier3Path.moveTo(-2.61f, -9.17f);
        bezier3Path.lineTo(9.54f, -13.42f);
        bezier3Path.lineTo(10.57f, -0.59f);
        bezier3Path.cubicTo(10.59f, -0.47f, 10.57f, -0.34f, 10.5f, -0.23f);
        bezier3Path.cubicTo(10.35f, 0.0f, 10.04f, 0.07f, 9.81f, -0.08f);
        bezier3Path.cubicTo(9.77f, -0.1f, 9.72f, -0.15f, 9.72f, -0.15f);
        bezier3Path.lineTo(6.27f, -3.55f);
        bezier3Path.cubicTo(6.24f, -3.59f, 6.2f, -3.62f, 6.16f, -3.65f);
        bezier3Path.cubicTo(5.94f, -3.8f, 5.49f, -3.53f, 5.35f, -3.31f);
        bezier3Path.cubicTo(5.15f, -3.01f, 3.85f, -1.0f, 3.85f, -1.0f);
        bezier3Path.lineTo(2.17f, -2.09f);
        bezier3Path.lineTo(0.49f, -3.19f);
        bezier3Path.cubicTo(0.49f, -3.19f, 1.8f, -5.19f, 1.99f, -5.49f);
        bezier3Path.cubicTo(2.14f, -5.71f, 2.13f, -6.13f, 1.91f, -6.28f);
        bezier3Path.cubicTo(1.87f, -6.3f, 1.85f, -6.37f, 1.81f, -6.39f);
        bezier3Path.lineTo(-2.68f, -8.19f);
        bezier3Path.cubicTo(-2.68f, -8.19f, -2.74f, -8.23f, -2.77f, -8.26f);
        bezier3Path.cubicTo(-3.0f, -8.41f, -3.06f, -8.72f, -2.91f, -8.95f);
        bezier3Path.cubicTo(-2.84f, -9.06f, -2.73f, -9.14f, -2.61f, -9.17f);
        bezier3Path.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier3Path, paint);
        canvas.restore();
        canvas.restore();
    }

    public static void drawOffRamp(Canvas canvas, int primaryColor, int secondaryColor, PointF size) {
        ManeuversStyleKit.drawOffRamp(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, secondaryColor, size);
    }

    public static void drawOffRamp(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, int secondaryColor, PointF size) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForOfframp.paint;
        float x = size.x / 2.0f;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float y = size.y / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForOfframp.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForOfframp.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForOfframp.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(x + 3.38f, y);
        ((Matrix)currentTransformation.peek()).postTranslate(x + 3.38f, y);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezierRect = CacheForOfframp.bezierRect;
        bezierRect.set(-10.38f, -13.0f, -10.38f, 16.0f);
        Path bezierPath = CacheForOfframp.bezierPath;
        bezierPath.reset();
        bezierPath.moveTo(-10.38f, 16.0f);
        bezierPath.lineTo(-10.38f, 7.51f);
        bezierPath.cubicTo(-10.38f, 5.7f, -10.38f, -13.0f, -10.38f, -13.0f);
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeMiter(10.0f);
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(secondaryColor);
        canvas.drawPath(bezierPath, paint);
        canvas.restore();
        RectF bezier2Rect = CacheForOfframp.bezier2Rect;
        bezier2Rect.set(-10.38f, -4.4f, -0.81f, 16.0f);
        Path bezier2Path = CacheForOfframp.bezier2Path;
        bezier2Path.reset();
        bezier2Path.moveTo(-0.81f, -4.4f);
        bezier2Path.lineTo(-8.35f, 1.79f);
        bezier2Path.cubicTo(-9.51f, 3.34f, -10.38f, 5.23f, -10.38f, 7.17f);
        bezier2Path.lineTo(-10.38f, 16.0f);
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeMiter(10.0f);
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier2Path, paint);
        canvas.restore();
        RectF bezier3Rect = CacheForOfframp.bezier3Rect;
        bezier3Rect.set(-5.38f, -12.07f, 8.0f, 0.99f);
        Path bezier3Path = CacheForOfframp.bezier3Path;
        bezier3Path.reset();
        bezier3Path.moveTo(-4.85f, -11.35f);
        bezier3Path.lineTo(8.0f, -12.07f);
        bezier3Path.lineTo(5.43f, 0.55f);
        bezier3Path.cubicTo(5.42f, 0.67f, 5.36f, 0.79f, 5.27f, 0.87f);
        bezier3Path.cubicTo(5.06f, 1.05f, 4.74f, 1.03f, 4.56f, 0.82f);
        bezier3Path.cubicTo(4.53f, 0.79f, 4.5f, 0.73f, 4.5f, 0.73f);
        bezier3Path.lineTo(2.12f, -3.49f);
        bezier3Path.cubicTo(2.11f, -3.54f, 2.08f, -3.58f, 2.05f, -3.62f);
        bezier3Path.cubicTo(1.87f, -3.82f, 1.37f, -3.69f, 1.17f, -3.52f);
        bezier3Path.cubicTo(0.9f, -3.28f, -0.91f, -1.71f, -0.91f, -1.71f);
        bezier3Path.lineTo(-2.23f, -3.23f);
        bezier3Path.lineTo(-3.54f, -4.74f);
        bezier3Path.cubicTo(-3.54f, -4.74f, -1.72f, -6.31f, -1.45f, -6.54f);
        bezier3Path.cubicTo(-1.25f, -6.72f, -1.14f, -7.11f, -1.32f, -7.32f);
        bezier3Path.cubicTo(-1.35f, -7.36f, -1.34f, -7.43f, -1.38f, -7.45f);
        bezier3Path.lineTo(-5.19f, -10.43f);
        bezier3Path.cubicTo(-5.19f, -10.43f, -5.24f, -10.49f, -5.26f, -10.52f);
        bezier3Path.cubicTo(-5.44f, -10.73f, -5.41f, -11.05f, -5.2f, -11.23f);
        bezier3Path.cubicTo(-5.1f, -11.31f, -4.97f, -11.36f, -4.85f, -11.35f);
        bezier3Path.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier3Path, paint);
        canvas.restore();
        canvas.restore();
    }

    public static void drawArriveRight(Canvas canvas, int primaryColor, PointF size) {
        ManeuversStyleKit.drawArriveRight(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, size);
    }

    public static void drawArriveRight(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, PointF size) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForArriveright.paint;
        float x = size.x / 2.0f;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float y = size.y / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForArriveright.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForArriveright.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForArriveright.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(x, y);
        ((Matrix)currentTransformation.peek()).postTranslate(x, y);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezierRect = CacheForArriveright.bezierRect;
        bezierRect.set(-0.99f, 5.6f, -0.99f, 16.0f);
        Path bezierPath = CacheForArriveright.bezierPath;
        bezierPath.reset();
        bezierPath.moveTo(-0.99f, 5.6f);
        bezierPath.lineTo(-0.99f, 16.0f);
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeMiter(10.0f);
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(primaryColor);
        canvas.drawPath(bezierPath, paint);
        canvas.restore();
        RectF bezier2Rect = CacheForArriveright.bezier2Rect;
        bezier2Rect.set(-9.05f, -10.03f, 6.95f, 1.48f);
        Path bezier2Path = CacheForArriveright.bezier2Path;
        bezier2Path.reset();
        bezier2Path.moveTo(-3.05f, 1.48f);
        bezier2Path.cubicTo(-3.05f, 1.48f, -3.05f, 1.09f, -3.05f, 0.73f);
        bezier2Path.cubicTo(-3.05f, 0.46f, -3.28f, 0.12f, -3.55f, 0.12f);
        bezier2Path.cubicTo(-3.6f, 0.12f, -3.65f, 0.07f, -3.69f, 0.08f);
        bezier2Path.lineTo(-8.44f, 1.02f);
        bezier2Path.cubicTo(-8.44f, 1.02f, -8.51f, 1.01f, -8.55f, 1.01f);
        bezier2Path.cubicTo(-8.83f, 1.01f, -9.05f, 0.78f, -9.05f, 0.51f);
        bezier2Path.cubicTo(-9.05f, 0.37f, -9.0f, 0.25f, -8.91f, 0.16f);
        bezier2Path.lineTo(-1.05f, -10.03f);
        bezier2Path.lineTo(6.81f, 0.16f);
        bezier2Path.cubicTo(6.9f, 0.25f, 6.95f, 0.37f, 6.95f, 0.5f);
        bezier2Path.cubicTo(6.95f, 0.77f, 6.73f, 1.0f, 6.45f, 1.0f);
        bezier2Path.cubicTo(6.41f, 1.0f, 6.34f, 0.99f, 6.34f, 0.99f);
        bezier2Path.lineTo(1.59f, 0.02f);
        bezier2Path.cubicTo(1.55f, 0.01f, 1.5f, -0.0f, 1.45f, -0.0f);
        bezier2Path.cubicTo(1.18f, -0.0f, 0.95f, 0.46f, 0.95f, 0.73f);
        bezier2Path.cubicTo(0.95f, 1.09f, 0.96f, 1.48f, 0.96f, 1.48f);
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier2Path, paint);
        RectF ovalRect = CacheForArriveright.ovalRect;
        ovalRect.set(2.95f, -15.6f, 9.05f, -9.5f);
        Path ovalPath = CacheForArriveright.ovalPath;
        ovalPath.reset();
        ovalPath.addOval(ovalRect, Path.Direction.CW);
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(ovalPath, paint);
        RectF rectangleRect = CacheForArriveright.rectangleRect;
        rectangleRect.set(-3.05f, 2.63f, 0.95f, 4.58f);
        Path rectanglePath = CacheForArriveright.rectanglePath;
        rectanglePath.reset();
        rectanglePath.moveTo(rectangleRect.left, rectangleRect.top);
        rectanglePath.lineTo(rectangleRect.right, rectangleRect.top);
        rectanglePath.lineTo(rectangleRect.right, rectangleRect.bottom);
        rectanglePath.lineTo(rectangleRect.left, rectangleRect.bottom);
        rectanglePath.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(rectanglePath, paint);
        canvas.restore();
        canvas.restore();
    }

    public static void drawRoundabout(Canvas canvas, int primaryColor, int secondaryColor, PointF size, float roundabout_angle) {
        ManeuversStyleKit.drawRoundabout(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, secondaryColor, size, roundabout_angle, 6.5f);
    }

    public static void drawRoundabout(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, int secondaryColor, PointF size, float roundabout_angle, float roundabout_radius) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForRoundabout.paint;
        float roundabout_percentage = roundabout_angle / 360.0f * 2.0f * (float)Math.PI * roundabout_radius;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float roundabout_arrow_height = scale * (float)Math.cos((roundabout_angle - 180.0f) * (float)Math.PI / 180.0f) * 20.0f;
        float roundabout_y = size.y - scale * (roundabout_radius * 2.0f + 4.0f) + 1.0f + roundabout_arrow_height / 4.0f;
        float roundabout_arrow_width = scale * 0.75f * (float)Math.sin((roundabout_angle - 180.0f) * (float)Math.PI / 180.0f) * 16.0f;
        float roundabout_x = size.x / 2.0f + roundabout_arrow_width / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForRoundabout.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForRoundabout.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForRoundabout.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(roundabout_x - 0.0f, roundabout_y - 1.0f);
        ((Matrix)currentTransformation.peek()).postTranslate(roundabout_x - 0.0f, roundabout_y - 1.0f);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezierRect = CacheForRoundabout.bezierRect;
        bezierRect.set(-6.5f, -5.5f, 6.5f, 7.5f);
        Path bezierPath = CacheForRoundabout.bezierPath;
        bezierPath.reset();
        bezierPath.moveTo(6.5f, 1.0f);
        bezierPath.cubicTo(6.5f, 2.8f, 5.78f, 4.42f, 4.6f, 5.59f);
        bezierPath.cubicTo(3.43f, 6.77f, 1.8f, 7.5f, 0.0f, 7.5f);
        bezierPath.cubicTo(-1.79f, 7.5f, -3.41f, 6.78f, -4.59f, 5.61f);
        bezierPath.cubicTo(-5.77f, 4.43f, -6.5f, 2.8f, -6.5f, 1.0f);
        bezierPath.cubicTo(-6.5f, -0.79f, -5.77f, -2.42f, -4.6f, -3.59f);
        bezierPath.cubicTo(-3.42f, -4.77f, -1.79f, -5.5f, 0.0f, -5.5f);
        bezierPath.cubicTo(1.79f, -5.5f, 3.42f, -4.77f, 4.6f, -3.59f);
        bezierPath.cubicTo(5.77f, -2.42f, 6.5f, -0.79f, 6.5f, 1.0f);
        bezierPath.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeMiter(10.0f);
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(secondaryColor);
        canvas.drawPath(bezierPath, paint);
        canvas.restore();
        RectF rectangle2Rect = CacheForRoundabout.rectangle2Rect;
        rectangle2Rect.set(-1.97f, 5.5f, 2.03f, 17.5f);
        Path rectangle2Path = CacheForRoundabout.rectangle2Path;
        rectangle2Path.reset();
        float rectangle2CornerRadius = Math.min(Math.min(rectangle2Rect.width(), rectangle2Rect.height()) / 2.0f, 1.0f);
        float[] rectangle2CornerRadii = CacheForRoundabout.rectangle2CornerRadii;
        rectangle2CornerRadii[0] = rectangle2CornerRadii[1] = rectangle2CornerRadius;
        rectangle2CornerRadii[2] = rectangle2CornerRadii[3] = rectangle2CornerRadius;
        rectangle2CornerRadii[5] = 0.0f;
        rectangle2CornerRadii[4] = 0.0f;
        rectangle2CornerRadii[7] = 0.0f;
        rectangle2CornerRadii[6] = 0.0f;
        rectangle2Path.addRoundRect(rectangle2Rect, rectangle2CornerRadii, Path.Direction.CW);
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(rectangle2Path, paint);
        canvas.save();
        canvas.translate(0.0f, 1.0f);
        ((Matrix)currentTransformation.peek()).postTranslate(0.0f, 1.0f);
        canvas.rotate(-(roundabout_angle + 90.0f));
        ((Matrix)currentTransformation.peek()).postRotate(-(roundabout_angle + 90.0f));
        RectF bezier2Rect = CacheForRoundabout.bezier2Rect;
        bezier2Rect.set(-20.5f, -7.99f, -4.5f, 8.01f);
        Path bezier2Path = CacheForRoundabout.bezier2Path;
        bezier2Path.reset();
        bezier2Path.moveTo(-9.47f, -7.49f);
        bezier2Path.cubicTo(-9.47f, -7.45f, -9.49f, -7.38f, -9.49f, -7.38f);
        bezier2Path.cubicTo(-9.57f, -6.97f, -10.45f, -2.64f, -10.45f, -2.64f);
        bezier2Path.cubicTo(-10.47f, -2.59f, -10.47f, -2.54f, -10.47f, -2.49f);
        bezier2Path.cubicTo(-10.47f, -2.25f, -10.09f, -2.03f, -9.82f, -2.0f);
        bezier2Path.lineTo(-5.5f, -2.0f);
        bezier2Path.cubicTo(-4.95f, -2.0f, -4.5f, -1.55f, -4.5f, -1.0f);
        bezier2Path.lineTo(-4.5f, 1.0f);
        bezier2Path.cubicTo(-4.5f, 1.55f, -4.95f, 2.0f, -5.5f, 2.0f);
        bezier2Path.cubicTo(-5.5f, 2.0f, -9.38f, 2.01f, -9.75f, 2.01f);
        bezier2Path.cubicTo(-10.01f, 2.01f, -10.35f, 2.24f, -10.35f, 2.51f);
        bezier2Path.cubicTo(-10.35f, 2.56f, -10.41f, 2.6f, -10.39f, 2.65f);
        bezier2Path.lineTo(-9.46f, 7.39f);
        bezier2Path.cubicTo(-9.46f, 7.39f, -9.46f, 7.47f, -9.46f, 7.51f);
        bezier2Path.cubicTo(-9.46f, 7.78f, -9.69f, 8.01f, -9.97f, 8.01f);
        bezier2Path.cubicTo(-10.1f, 8.01f, -10.22f, 7.95f, -10.31f, 7.87f);
        bezier2Path.lineTo(-20.5f, 0.01f);
        bezier2Path.lineTo(-10.31f, -7.86f);
        bezier2Path.cubicTo(-10.22f, -7.94f, -10.11f, -7.99f, -9.97f, -7.99f);
        bezier2Path.cubicTo(-9.7f, -7.99f, -9.47f, -7.77f, -9.47f, -7.49f);
        bezier2Path.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier2Path, paint);
        canvas.restore();
        canvas.save();
        canvas.translate(1.0f, 2.0f);
        ((Matrix)currentTransformation.peek()).postTranslate(1.0f, 2.0f);
        canvas.rotate(-90.0f);
        ((Matrix)currentTransformation.peek()).postRotate(-90.0f);
        canvas.scale(-1.0f, 1.0f);
        ((Matrix)currentTransformation.peek()).postScale(-1.0f, 1.0f);
        RectF bezier3Rect = CacheForRoundabout.bezier3Rect;
        bezier3Rect.set(-7.5f, -7.5f, 5.5f, 5.5f);
        Path bezier3Path = CacheForRoundabout.bezier3Path;
        bezier3Path.reset();
        bezier3Path.moveTo(5.5f, -1.0f);
        bezier3Path.cubicTo(5.5f, 0.79f, 4.78f, 2.41f, 3.6f, 3.59f);
        bezier3Path.cubicTo(2.43f, 4.77f, 0.8f, 5.5f, -1.0f, 5.5f);
        bezier3Path.cubicTo(-2.79f, 5.5f, -4.41f, 4.78f, -5.59f, 3.61f);
        bezier3Path.cubicTo(-6.77f, 2.43f, -7.5f, 0.8f, -7.5f, -1.0f);
        bezier3Path.cubicTo(-7.5f, -2.79f, -6.77f, -4.42f, -5.6f, -5.6f);
        bezier3Path.cubicTo(-4.42f, -6.77f, -2.79f, -7.5f, -1.0f, -7.5f);
        bezier3Path.cubicTo(0.79f, -7.5f, 2.42f, -6.77f, 3.6f, -5.6f);
        bezier3Path.cubicTo(4.77f, -4.42f, 5.5f, -2.79f, 5.5f, -1.0f);
        bezier3Path.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeMiter(10.0f);
        paint.setPathEffect((PathEffect)CacheForRoundabout.bezier3PathDashEffect.get(roundabout_percentage, 1000.0f, 0.0f));
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier3Path, paint);
        canvas.restore();
        canvas.restore();
        canvas.restore();
        canvas.restore();
    }

    public static void drawArriveright2(Canvas canvas, int primaryColor, PointF size) {
        ManeuversStyleKit.drawArriveright2(canvas, new RectF(0.0f, 0.0f, 32.0f, 32.0f), ResizingBehavior.AspectFit, primaryColor, size);
    }

    public static void drawArriveright2(Canvas canvas, RectF targetFrame, ResizingBehavior resizing, int primaryColor, PointF size) {
        Stack<Matrix> currentTransformation = new Stack<Matrix>();
        currentTransformation.push(new Matrix());
        Paint paint = CacheForArriveright2.paint;
        float x = size.x / 2.0f;
        float scale = Math.min(size.x / 32.0f, size.y / 32.0f);
        float y = size.y / 2.0f;
        canvas.save();
        RectF resizedFrame = CacheForArriveright2.resizedFrame;
        ManeuversStyleKit.resizingBehaviorApply(resizing, CacheForArriveright2.originalFrame, targetFrame, resizedFrame);
        canvas.translate(resizedFrame.left, resizedFrame.top);
        canvas.scale(resizedFrame.width() / 32.0f, resizedFrame.height() / 32.0f);
        RectF frame = CacheForArriveright2.frame;
        frame.set(0.0f, 0.0f, size.x, size.y);
        canvas.save();
        canvas.translate(x, y);
        ((Matrix)currentTransformation.peek()).postTranslate(x, y);
        canvas.scale(scale, scale);
        ((Matrix)currentTransformation.peek()).postScale(scale, scale);
        RectF bezierRect = CacheForArriveright2.bezierRect;
        bezierRect.set(0.06f, 6.6f, 0.06f, 16.0f);
        Path bezierPath = CacheForArriveright2.bezierPath;
        bezierPath.reset();
        bezierPath.moveTo(0.06f, 6.6f);
        bezierPath.lineTo(0.06f, 16.0f);
        paint.reset();
        paint.setFlags(1);
        paint.setStrokeWidth(4.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeMiter(10.0f);
        canvas.save();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(primaryColor);
        canvas.drawPath(bezierPath, paint);
        canvas.restore();
        RectF bezier2Rect = CacheForArriveright2.bezier2Rect;
        bezier2Rect.set(-8.0f, -9.03f, 8.0f, 2.48f);
        Path bezier2Path = CacheForArriveright2.bezier2Path;
        bezier2Path.reset();
        bezier2Path.moveTo(-2.0f, 2.48f);
        bezier2Path.cubicTo(-2.0f, 2.48f, -2.0f, 2.09f, -2.0f, 1.73f);
        bezier2Path.cubicTo(-2.0f, 1.46f, -2.23f, 1.12f, -2.5f, 1.12f);
        bezier2Path.cubicTo(-2.55f, 1.12f, -2.6f, 1.07f, -2.64f, 1.08f);
        bezier2Path.lineTo(-7.39f, 2.02f);
        bezier2Path.cubicTo(-7.39f, 2.02f, -7.46f, 2.01f, -7.5f, 2.01f);
        bezier2Path.cubicTo(-7.78f, 2.01f, -8.0f, 1.78f, -8.0f, 1.51f);
        bezier2Path.cubicTo(-8.0f, 1.37f, -7.95f, 1.25f, -7.86f, 1.16f);
        bezier2Path.lineTo(0.0f, -9.03f);
        bezier2Path.lineTo(7.86f, 1.16f);
        bezier2Path.cubicTo(7.95f, 1.25f, 8.0f, 1.37f, 8.0f, 1.5f);
        bezier2Path.cubicTo(8.0f, 1.77f, 7.78f, 2.0f, 7.5f, 2.0f);
        bezier2Path.cubicTo(7.46f, 2.0f, 7.39f, 1.99f, 7.39f, 1.99f);
        bezier2Path.lineTo(2.64f, 1.02f);
        bezier2Path.cubicTo(2.6f, 1.01f, 2.55f, 1.0f, 2.5f, 1.0f);
        bezier2Path.cubicTo(2.23f, 1.0f, 2.0f, 1.46f, 2.0f, 1.73f);
        bezier2Path.cubicTo(2.0f, 2.09f, 2.0f, 2.48f, 2.0f, 2.48f);
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier2Path, paint);
        RectF rectangleRect = CacheForArriveright2.rectangleRect;
        rectangleRect.set(-2.0f, 3.63f, 2.0f, 5.58f);
        Path rectanglePath = CacheForArriveright2.rectanglePath;
        rectanglePath.reset();
        rectanglePath.moveTo(rectangleRect.left, rectangleRect.top);
        rectanglePath.lineTo(rectangleRect.right, rectangleRect.top);
        rectanglePath.lineTo(rectangleRect.right, rectangleRect.bottom);
        rectanglePath.lineTo(rectangleRect.left, rectangleRect.bottom);
        rectanglePath.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(rectanglePath, paint);
        RectF bezier3Rect = CacheForArriveright2.bezier3Rect;
        bezier3Rect.set(3.0f, -15.57f, 9.0f, -6.57f);
        Path bezier3Path = CacheForArriveright2.bezier3Path;
        bezier3Path.reset();
        bezier3Path.moveTo(6.0f, -13.69f);
        bezier3Path.cubicTo(5.87f, -13.69f, 5.75f, -13.67f, 5.64f, -13.63f);
        bezier3Path.cubicTo(5.19f, -13.48f, 4.88f, -13.06f, 4.88f, -12.57f);
        bezier3Path.cubicTo(4.88f, -11.95f, 5.38f, -11.44f, 6.0f, -11.44f);
        bezier3Path.cubicTo(6.62f, -11.44f, 7.13f, -11.95f, 7.13f, -12.57f);
        bezier3Path.cubicTo(7.13f, -13.19f, 6.62f, -13.69f, 6.0f, -13.69f);
        bezier3Path.close();
        bezier3Path.moveTo(9.0f, -12.57f);
        bezier3Path.cubicTo(9.0f, -10.91f, 7.5f, -9.94f, 6.0f, -6.57f);
        bezier3Path.cubicTo(4.5f, -9.94f, 3.0f, -10.91f, 3.0f, -12.57f);
        bezier3Path.cubicTo(3.0f, -13.45f, 3.38f, -14.25f, 4.0f, -14.8f);
        bezier3Path.cubicTo(4.19f, -14.97f, 4.41f, -15.12f, 4.64f, -15.24f);
        bezier3Path.cubicTo(5.05f, -15.45f, 5.51f, -15.57f, 6.0f, -15.57f);
        bezier3Path.cubicTo(7.66f, -15.57f, 9.0f, -14.22f, 9.0f, -12.57f);
        bezier3Path.close();
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(primaryColor);
        canvas.drawPath(bezier3Path, paint);
        canvas.restore();
        canvas.restore();
    }

    public static void resizingBehaviorApply(ResizingBehavior behavior, RectF rect, RectF target, RectF result) {
        if (rect.equals((Object)target) || target == null) {
            result.set(rect);
            return;
        }
        if (behavior == ResizingBehavior.Stretch) {
            result.set(target);
            return;
        }
        float xRatio = Math.abs(target.width() / rect.width());
        float yRatio = Math.abs(target.height() / rect.height());
        float scale = 0.0f;
        switch (behavior) {
            case AspectFit: {
                scale = Math.min(xRatio, yRatio);
                break;
            }
            case AspectFill: {
                scale = Math.max(xRatio, yRatio);
                break;
            }
            case Center: {
                scale = 1.0f;
                break;
            }
        }
        float newWidth = Math.abs(rect.width() * scale);
        float newHeight = Math.abs(rect.height() * scale);
        result.set(target.centerX() - newWidth / 2.0f, target.centerY() - newHeight / 2.0f, target.centerX() + newWidth / 2.0f, target.centerY() + newHeight / 2.0f);
    }

    private static class CacheForArriveright2 {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezierRect = new RectF();
        private static Path bezierPath = new Path();
        private static RectF bezier2Rect = new RectF();
        private static Path bezier2Path = new Path();
        private static RectF rectangleRect = new RectF();
        private static Path rectanglePath = new Path();
        private static RectF bezier3Rect = new RectF();
        private static Path bezier3Path = new Path();

        private CacheForArriveright2() {
        }
    }

    private static class CacheForRoundabout {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezierRect = new RectF();
        private static Path bezierPath = new Path();
        private static RectF rectangle2Rect = new RectF();
        private static Path rectangle2Path = new Path();
        private static float[] rectangle2CornerRadii = new float[8];
        private static RectF bezier2Rect = new RectF();
        private static Path bezier2Path = new Path();
        private static RectF bezier3Rect = new RectF();
        private static Path bezier3Path = new Path();
        private static PaintCodeDashPathEffect bezier3PathDashEffect = new PaintCodeDashPathEffect();

        private CacheForRoundabout() {
        }
    }

    private static class CacheForArriveright {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezierRect = new RectF();
        private static Path bezierPath = new Path();
        private static RectF bezier2Rect = new RectF();
        private static Path bezier2Path = new Path();
        private static RectF ovalRect = new RectF();
        private static Path ovalPath = new Path();
        private static RectF rectangleRect = new RectF();
        private static Path rectanglePath = new Path();

        private CacheForArriveright() {
        }
    }

    private static class CacheForOfframp {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezierRect = new RectF();
        private static Path bezierPath = new Path();
        private static RectF bezier2Rect = new RectF();
        private static Path bezier2Path = new Path();
        private static RectF bezier3Rect = new RectF();
        private static Path bezier3Path = new Path();

        private CacheForOfframp() {
        }
    }

    private static class CacheForFork {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezierRect = new RectF();
        private static Path bezierPath = new Path();
        private static RectF bezier2Rect = new RectF();
        private static Path bezier2Path = new Path();
        private static RectF bezier3Rect = new RectF();
        private static Path bezier3Path = new Path();

        private CacheForFork() {
        }
    }

    private static class CacheForMerge {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezierRect = new RectF();
        private static Path bezierPath = new Path();
        private static RectF bezier2Rect = new RectF();
        private static Path bezier2Path = new Path();
        private static RectF bezier3Rect = new RectF();
        private static Path bezier3Path = new Path();

        private CacheForMerge() {
        }
    }

    private static class CacheForDestination {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezierRect = new RectF();
        private static Path bezierPath = new Path();

        private CacheForDestination() {
        }
    }

    private static class CacheForStarting {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezier2Rect = new RectF();
        private static Path bezier2Path = new Path();

        private CacheForStarting() {
        }
    }

    private static class CacheForArrive {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezierRect = new RectF();
        private static Path bezierPath = new Path();
        private static RectF bezier2Rect = new RectF();
        private static Path bezier2Path = new Path();
        private static RectF ovalRect = new RectF();
        private static Path ovalPath = new Path();
        private static RectF rectangleRect = new RectF();
        private static Path rectanglePath = new Path();

        private CacheForArrive() {
        }
    }

    private static class CacheForArrowsharpright {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezierRect = new RectF();
        private static Path bezierPath = new Path();
        private static RectF bezier3Rect = new RectF();
        private static Path bezier3Path = new Path();

        private CacheForArrowsharpright() {
        }
    }

    private static class CacheForArrowstraight {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezierRect = new RectF();
        private static Path bezierPath = new Path();

        private CacheForArrowstraight() {
        }
    }

    private static class CacheForArrowslightright {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezier3Rect = new RectF();
        private static Path bezier3Path = new Path();
        private static RectF bezier4Rect = new RectF();
        private static Path bezier4Path = new Path();
        private static RectF clipRect = new RectF();

        private CacheForArrowslightright() {
        }
    }

    private static class CacheForArrowright {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezierRect = new RectF();
        private static Path bezierPath = new Path();

        private CacheForArrowright() {
        }
    }

    private static class CacheForArrow180right {
        private static Paint paint = new Paint();
        private static RectF originalFrame = new RectF(0.0f, 0.0f, 32.0f, 32.0f);
        private static RectF resizedFrame = new RectF();
        private static RectF frame = new RectF();
        private static RectF bezierRect = new RectF();
        private static Path bezierPath = new Path();
        private static RectF bezier2Rect = new RectF();
        private static Path bezier2Path = new Path();

        private CacheForArrow180right() {
        }
    }

    public static enum ResizingBehavior {
        AspectFit,
        AspectFill,
        Stretch,
        Center;

    }
}

