/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.constraint.ConstraintLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.TextView;
import com.mapbox.services.android.navigation.ui.v5.MultiOnClickListener;
import com.mapbox.services.android.navigation.ui.v5.NavigationButton;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.ThemeSwitcher;

public class SoundButton
extends ConstraintLayout
implements NavigationButton {
    private static final float ALPHA_VALUE_ZERO = 0.0f;
    private static final float ALPHA_VALUE_ONE = 1.0f;
    private static final long ANIMATION_DURATION_THREE_HUNDRED_MILLIS = 300L;
    private static final long ANIMATION_DURATION_ONE_THOUSAND_MILLIS = 1000L;
    private FloatingActionButton soundFab;
    private TextView soundChipText;
    private AnimationSet fadeInSlowOut;
    private boolean isMuted;
    private MultiOnClickListener multiOnClickListener = new MultiOnClickListener();

    public SoundButton(Context context) {
        this(context, null);
    }

    public SoundButton(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public SoundButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    @Override
    public void addOnClickListener(View.OnClickListener onClickListener) {
        this.multiOnClickListener.addListener(onClickListener);
    }

    @Override
    public void removeOnClickListener(View.OnClickListener onClickListener) {
        this.multiOnClickListener.removeListener(onClickListener);
    }

    @Override
    public void hide() {
        this.setVisibility(8);
    }

    @Override
    public void show() {
        this.setVisibility(0);
    }

    public boolean toggleMute() {
        return this.isMuted ? this.unmute() : this.mute();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bind();
        this.setupColors();
        this.initializeAnimation();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setupOnClickListeners();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clearListeners();
    }

    void soundFabOff() {
        this.soundFab.setImageResource(R.drawable.ic_sound_off);
    }

    private void setupOnClickListeners() {
        this.soundFab.setOnClickListener((View.OnClickListener)this.multiOnClickListener);
    }

    private void clearListeners() {
        this.multiOnClickListener.clearListeners();
        this.multiOnClickListener = null;
        this.setOnClickListener(null);
    }

    private void initializeAnimation() {
        AlphaAnimation fadeIn = new AlphaAnimation(0.0f, 1.0f);
        fadeIn.setInterpolator((Interpolator)new DecelerateInterpolator());
        fadeIn.setDuration(300L);
        AlphaAnimation fadeOut = new AlphaAnimation(1.0f, 0.0f);
        fadeOut.setInterpolator((Interpolator)new AccelerateInterpolator());
        fadeOut.setStartOffset(1000L);
        fadeOut.setDuration(1000L);
        this.fadeInSlowOut = new AnimationSet(false);
        this.fadeInSlowOut.addAnimation((Animation)fadeIn);
        this.fadeInSlowOut.addAnimation((Animation)fadeOut);
    }

    private void setupColors() {
        if (Build.VERSION.SDK_INT < 21) {
            Drawable soundChipBackground = DrawableCompat.wrap((Drawable)this.soundChipText.getBackground()).mutate();
            int navigationViewPrimaryColor = ThemeSwitcher.retrieveThemeColor(this.getContext(), R.attr.navigationViewPrimary);
            DrawableCompat.setTint((Drawable)soundChipBackground, (int)navigationViewPrimaryColor);
        }
    }

    private boolean mute() {
        this.isMuted = true;
        this.setSoundChipText(this.getContext().getString(R.string.muted));
        this.showSoundChip();
        this.soundFabOff();
        return this.isMuted;
    }

    private boolean unmute() {
        this.isMuted = false;
        this.setSoundChipText(this.getContext().getString(R.string.unmuted));
        this.showSoundChip();
        this.soundFabOn();
        return this.isMuted;
    }

    private void setSoundChipText(String text) {
        this.soundChipText.setText((CharSequence)text);
    }

    private void showSoundChip() {
        this.soundChipText.startAnimation((Animation)this.fadeInSlowOut);
    }

    private void bind() {
        this.soundFab = (FloatingActionButton)this.findViewById(R.id.soundFab);
        this.soundChipText = (TextView)this.findViewById(R.id.soundText);
    }

    private void initialize(Context context) {
        SoundButton.inflate((Context)context, (int)R.layout.sound_layout, (ViewGroup)this);
    }

    private void soundFabOn() {
        this.soundFab.setImageResource(R.drawable.ic_sound_on);
    }
}

