/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsResponse;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.ui.v5.ConnectivityStatusProvider;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewOfflineRouter;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewOptions;
import com.mapbox.services.android.navigation.ui.v5.RouteCallStatus;
import com.mapbox.services.android.navigation.ui.v5.RouteComparator;
import com.mapbox.services.android.navigation.ui.v5.ViewRouteListener;
import com.mapbox.services.android.navigation.v5.navigation.MapboxOfflineRouter;
import com.mapbox.services.android.navigation.v5.navigation.NavigationRoute;
import com.mapbox.services.android.navigation.v5.route.RouteFetcher;
import com.mapbox.services.android.navigation.v5.route.RouteListener;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import java.util.Date;
import java.util.List;

class NavigationViewRouter
implements RouteListener {
    private final RouteFetcher onlineRouter;
    private final ConnectivityStatusProvider connectivityStatus;
    private final RouteComparator routeComparator;
    private final ViewRouteListener listener;
    @Nullable
    private NavigationViewOfflineRouter offlineRouter;
    private RouteOptions routeOptions;
    private DirectionsRoute currentRoute;
    private Location location;
    private RouteCallStatus callStatus;

    NavigationViewRouter(RouteFetcher onlineRouter, ConnectivityStatusProvider connectivityStatus, ViewRouteListener listener) {
        this.onlineRouter = onlineRouter;
        this.connectivityStatus = connectivityStatus;
        this.listener = listener;
        this.routeComparator = new RouteComparator(this);
        onlineRouter.addRouteListener((RouteListener)this);
    }

    NavigationViewRouter(RouteFetcher onlineRouter, NavigationViewOfflineRouter offlineRouter, ConnectivityStatusProvider connectivityStatus, RouteComparator routeComparator, ViewRouteListener listener, RouteCallStatus callStatus) {
        this.onlineRouter = onlineRouter;
        this.offlineRouter = offlineRouter;
        this.connectivityStatus = connectivityStatus;
        this.routeComparator = routeComparator;
        this.listener = listener;
        this.callStatus = callStatus;
        onlineRouter.addRouteListener((RouteListener)this);
    }

    public void onResponseReceived(DirectionsResponse response, @Nullable RouteProgress routeProgress) {
        if (this.validRouteResponse(response)) {
            this.routeComparator.compare(response, this.currentRoute);
        }
        this.updateCallStatusReceived();
    }

    public void onErrorReceived(Throwable throwable) {
        this.onRequestError(throwable.getMessage());
        this.updateCallStatusReceived();
    }

    void extractRouteOptions(NavigationViewOptions options) {
        this.extractRouteFrom(options);
        this.initializeOfflineFrom(options);
    }

    void findRouteFrom(@Nullable RouteProgress routeProgress) {
        if (this.isRouting()) {
            return;
        }
        NavigationRoute.Builder builder = this.onlineRouter.buildRequestFrom(this.location, routeProgress);
        if (this.connectivityStatus.isConnectedFast()) {
            this.findOnlineRouteWith(builder);
        } else if (this.isOfflineConfigured()) {
            this.findOfflineRouteWith(builder);
        } else if (this.connectivityStatus.isConnected()) {
            this.findOnlineRouteWith(builder);
        }
    }

    void updateLocation(@NonNull Location location) {
        this.location = location;
    }

    void updateCurrentRoute(DirectionsRoute currentRoute) {
        this.currentRoute = currentRoute;
        this.listener.onRouteUpdate(currentRoute);
    }

    void updateCallStatusReceived() {
        if (this.callStatus != null) {
            this.callStatus.setResponseReceived();
        }
    }

    void onRequestError(String errorMessage) {
        this.listener.onRouteRequestError(errorMessage);
    }

    void onDestroy() {
        this.onlineRouter.cancelRouteCall();
        this.onlineRouter.clearListeners();
    }

    private boolean validRouteResponse(DirectionsResponse response) {
        return response != null && !response.routes().isEmpty();
    }

    private void extractRouteFrom(NavigationViewOptions options) {
        DirectionsRoute route = options.directionsRoute();
        this.cacheRouteOptions(route.routeOptions());
        this.updateCurrentRoute(route);
    }

    private void cacheRouteOptions(RouteOptions routeOptions) {
        this.routeOptions = routeOptions;
        this.cacheRouteDestination();
    }

    private void cacheRouteDestination() {
        boolean hasValidCoordinates;
        boolean bl = hasValidCoordinates = this.routeOptions != null && !this.routeOptions.coordinates().isEmpty();
        if (hasValidCoordinates) {
            List coordinates = this.routeOptions.coordinates();
            int destinationCoordinate = coordinates.size() - 1;
            Point destinationPoint = (Point)coordinates.get(destinationCoordinate);
            this.listener.onDestinationSet(destinationPoint);
        }
    }

    private void initializeOfflineFrom(NavigationViewOptions options) {
        String offlinePath = options.offlineRoutingTilesPath();
        String offlineTilesVersion = options.offlineRoutingTilesVersion();
        if (!TextUtils.isEmpty((CharSequence)offlinePath) && !TextUtils.isEmpty((CharSequence)offlineTilesVersion)) {
            if (this.offlineRouter == null) {
                MapboxOfflineRouter offlineRouter = new MapboxOfflineRouter(offlinePath);
                this.offlineRouter = new NavigationViewOfflineRouter(offlineRouter, this);
            }
            this.offlineRouter.configure(offlineTilesVersion);
        }
    }

    private boolean isOfflineConfigured() {
        return this.offlineRouter != null && this.offlineRouter.isConfigured();
    }

    private void findOnlineRouteWith(NavigationRoute.Builder builder) {
        this.onlineRouter.cancelRouteCall();
        this.onlineRouter.findRouteWith(builder);
        this.callStatus = new RouteCallStatus(new Date());
    }

    private void findOfflineRouteWith(NavigationRoute.Builder builder) {
        this.offlineRouter.findRouteWith(builder);
        this.callStatus = new RouteCallStatus(new Date());
    }

    private boolean isRouting() {
        if (this.callStatus == null) {
            return false;
        }
        return this.callStatus.isRouting(new Date());
    }
}

