/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import com.mapbox.services.android.navigation.ui.v5.NavigationViewRouter;
import com.mapbox.services.android.navigation.ui.v5.OfflineRouteFoundCallback;
import com.mapbox.services.android.navigation.ui.v5.OfflineRouterConfiguredCallback;
import com.mapbox.services.android.navigation.v5.navigation.MapboxOfflineRouter;
import com.mapbox.services.android.navigation.v5.navigation.NavigationRoute;
import com.mapbox.services.android.navigation.v5.navigation.OfflineRoute;
import com.mapbox.services.android.navigation.v5.navigation.OnOfflineRouteFoundCallback;
import com.mapbox.services.android.navigation.v5.navigation.OnOfflineTilesConfiguredCallback;
import timber.log.Timber;

class NavigationViewOfflineRouter {
    private final MapboxOfflineRouter offlineRouter;
    private final NavigationViewRouter router;
    private boolean isConfigured;
    private String tileVersion;

    NavigationViewOfflineRouter(MapboxOfflineRouter offlineRouter, NavigationViewRouter router) {
        this.offlineRouter = offlineRouter;
        this.router = router;
    }

    void configure(String tileVersion) {
        if (!this.isConfigured || this.isNew(tileVersion)) {
            this.offlineRouter.configure(tileVersion, (OnOfflineTilesConfiguredCallback)new OfflineRouterConfiguredCallback(this));
        }
        this.tileVersion = tileVersion;
    }

    void setIsConfigured(boolean isConfigured) {
        this.isConfigured = isConfigured;
    }

    boolean isConfigured() {
        return this.isConfigured;
    }

    void findRouteWith(NavigationRoute.Builder builder) {
        if (!this.isConfigured) {
            Timber.e((String)"Cannot find route - offline router is not configured", (Object[])new Object[0]);
            return;
        }
        OfflineRoute offlineRoute = OfflineRoute.builder((NavigationRoute.Builder)builder).build();
        this.offlineRouter.findRoute(offlineRoute, (OnOfflineRouteFoundCallback)new OfflineRouteFoundCallback(this.router));
    }

    private boolean isNew(String tileVersion) {
        return !this.tileVersion.equals(tileVersion);
    }
}

