/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.voice;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.mapbox.api.speech.v1.MapboxSpeech;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import timber.log.Timber;

public class VoiceInstructionLoader {
    private static final int VOICE_INSTRUCTIONS_TO_EVICT_THRESHOLD = 4;
    private static final String SSML_TEXT_TYPE = "ssml";
    private final ConnectivityManager connectivityManager;
    private final String accessToken;
    private List<String> urlsCached;
    private final Cache cache;
    private MapboxSpeech.Builder mapboxSpeechBuilder = null;

    public VoiceInstructionLoader(Context context, String accessToken, Cache cache) {
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.accessToken = accessToken;
        this.urlsCached = new ArrayList<String>();
        this.cache = cache;
    }

    VoiceInstructionLoader(Context context, String accessToken, Cache cache, MapboxSpeech.Builder mapboxSpeechBuilder) {
        this(context, accessToken, cache);
        this.mapboxSpeechBuilder = mapboxSpeechBuilder;
    }

    public List<String> evictVoiceInstructions() {
        ArrayList<String> urlsToRemove = new ArrayList<String>();
        block2: for (int i = 0; i < this.urlsCached.size() && i < 4; ++i) {
            String urlToRemove = this.urlsCached.get(i);
            try {
                Iterator urlsCurrentlyCached;
                Iterator urlCached = urlsCurrentlyCached = this.cache.urls();
                while (urlCached.hasNext()) {
                    String url = (String)urlCached.next();
                    if (!url.equals(urlToRemove)) continue;
                    urlCached.remove();
                    urlsToRemove.add(urlToRemove);
                    continue block2;
                }
                continue;
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        this.urlsCached.removeAll(urlsToRemove);
        return urlsToRemove;
    }

    public void cacheInstructions(List<String> instructions) {
        for (String instruction : instructions) {
            this.cacheInstruction(instruction);
        }
    }

    void addStubUrlsToCache(List<String> urlsToCache) {
        this.urlsCached = urlsToCache;
    }

    void setupMapboxSpeechBuilder(String language) {
        if (this.mapboxSpeechBuilder == null) {
            this.mapboxSpeechBuilder = MapboxSpeech.builder().accessToken(this.accessToken).language(language).cache(this.cache).interceptor(this.provideOfflineCacheInterceptor());
        }
    }

    void requestInstruction(String instruction, String textType, Callback<ResponseBody> callback) {
        if (!this.cache.isClosed() && this.mapboxSpeechBuilder != null) {
            MapboxSpeech mapboxSpeech = this.mapboxSpeechBuilder.instruction(instruction).textType(textType).build();
            mapboxSpeech.enqueueCall(callback);
        }
    }

    void flushCache() {
        try {
            this.cache.evictAll();
        }
        catch (IOException exception) {
            Timber.e((Throwable)exception);
        }
    }

    private void cacheInstruction(String instruction) {
        this.requestInstruction(instruction, SSML_TEXT_TYPE, new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, retrofit2.Response<ResponseBody> response) {
                ((ResponseBody)response.body()).byteStream();
                ((ResponseBody)response.body()).close();
                VoiceInstructionLoader.this.urlsCached.add(call.request().url().toString());
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                Timber.e((String)"onFailure cache instruction", (Object[])new Object[0]);
            }
        });
    }

    private Interceptor provideOfflineCacheInterceptor() {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                if (!VoiceInstructionLoader.this.hasNetworkConnection()) {
                    CacheControl cacheControl = new CacheControl.Builder().maxStale(3, TimeUnit.DAYS).build();
                    request = request.newBuilder().cacheControl(cacheControl).build();
                }
                return chain.proceed(request);
            }
        };
    }

    private boolean hasNetworkConnection() {
        if (this.connectivityManager == null) {
            return false;
        }
        NetworkInfo activeNetwork = this.connectivityManager.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }
}

