/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.summary.list;

import android.support.constraint.ConstraintLayout;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.instruction.maneuver.ManeuverView;
import com.mapbox.services.android.navigation.ui.v5.summary.list.InstructionListView;

class InstructionViewHolder
extends RecyclerView.ViewHolder
implements InstructionListView {
    private ManeuverView maneuverView;
    private TextView distanceText;
    private TextView primaryText;
    private TextView secondaryText;
    private View instructionLayoutText;

    InstructionViewHolder(View itemView) {
        super(itemView);
        this.maneuverView = (ManeuverView)itemView.findViewById(R.id.maneuverView);
        this.distanceText = (TextView)itemView.findViewById(R.id.stepDistanceText);
        this.primaryText = (TextView)itemView.findViewById(R.id.stepPrimaryText);
        this.secondaryText = (TextView)itemView.findViewById(R.id.stepSecondaryText);
        this.instructionLayoutText = itemView.findViewById(R.id.instructionLayoutText);
    }

    @Override
    public void updateManeuverViewTypeAndModifier(String maneuverType, String maneuverModifier) {
        this.maneuverView.setManeuverTypeAndModifier(maneuverType, maneuverModifier);
    }

    @Override
    public void updateManeuverViewRoundaboutDegrees(float roundaboutAngle) {
        this.maneuverView.setRoundaboutAngle(roundaboutAngle);
    }

    @Override
    public void updateDistanceText(SpannableString distanceText) {
        this.distanceText.setText((CharSequence)distanceText);
    }

    @Override
    public void updatePrimaryText(String primaryText) {
        this.primaryText.setText((CharSequence)primaryText);
    }

    @Override
    public void updatePrimaryMaxLines(int maxLines) {
        this.primaryText.setMaxLines(maxLines);
    }

    @Override
    public void updateSecondaryText(String secondaryText) {
        this.secondaryText.setText((CharSequence)secondaryText);
    }

    @Override
    public void updateSecondaryVisibility(int visibility) {
        this.secondaryText.setVisibility(visibility);
    }

    @Override
    public void updateBannerVerticalBias(float percentBias) {
        this.adjustBannerVerticalBias(percentBias);
    }

    private void adjustBannerVerticalBias(float percentBias) {
        int orientation = this.itemView.getResources().getConfiguration().orientation;
        if (orientation == 1) {
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.instructionLayoutText.getLayoutParams();
            params.verticalBias = percentBias;
            this.instructionLayoutText.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }
}

