/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.summary;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewModel;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.ThemeSwitcher;
import com.mapbox.services.android.navigation.ui.v5.summary.SummaryModel;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.DistanceFormatter;
import com.mapbox.services.android.navigation.v5.utils.LocaleUtils;

public class SummaryBottomSheet
extends FrameLayout {
    private static final String EMPTY_STRING = "";
    private TextView distanceRemainingText;
    private TextView timeRemainingText;
    private TextView arrivalTimeText;
    private ProgressBar rerouteProgressBar;
    private boolean isRerouting;
    private int timeFormatType;
    private DistanceFormatter distanceFormatter;

    public SummaryBottomSheet(Context context) {
        this(context, null);
    }

    public SummaryBottomSheet(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public SummaryBottomSheet(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bind();
    }

    public void subscribe(NavigationViewModel navigationViewModel) {
        navigationViewModel.summaryModel.observe((LifecycleOwner)this.getContext(), (Observer)new Observer<SummaryModel>(){

            public void onChanged(@Nullable SummaryModel summaryModel) {
                if (summaryModel != null && !SummaryBottomSheet.this.isRerouting) {
                    SummaryBottomSheet.this.arrivalTimeText.setText((CharSequence)summaryModel.getArrivalTime());
                    SummaryBottomSheet.this.timeRemainingText.setText((CharSequence)summaryModel.getTimeRemaining());
                    SummaryBottomSheet.this.distanceRemainingText.setText((CharSequence)summaryModel.getDistanceRemaining());
                }
            }
        });
        navigationViewModel.isOffRoute.observe((LifecycleOwner)this.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(@Nullable Boolean isOffRoute) {
                if (isOffRoute != null) {
                    SummaryBottomSheet.this.isRerouting = isOffRoute;
                    if (SummaryBottomSheet.this.isRerouting) {
                        SummaryBottomSheet.this.showRerouteState();
                    } else {
                        SummaryBottomSheet.this.hideRerouteState();
                    }
                }
            }
        });
    }

    public void update(RouteProgress routeProgress) {
        if (routeProgress != null && !this.isRerouting) {
            SummaryModel model = new SummaryModel(this.getContext(), this.distanceFormatter, routeProgress, this.timeFormatType);
            this.arrivalTimeText.setText((CharSequence)model.getArrivalTime());
            this.timeRemainingText.setText((CharSequence)model.getTimeRemaining());
            this.distanceRemainingText.setText((CharSequence)model.getDistanceRemaining());
        }
    }

    public void showRerouteState() {
        this.rerouteProgressBar.setVisibility(0);
        this.clearViews();
    }

    public void hideRerouteState() {
        this.rerouteProgressBar.setVisibility(4);
    }

    public void setTimeFormat(int type) {
        this.timeFormatType = type;
    }

    public void setDistanceFormatter(DistanceFormatter distanceFormatter) {
        if (distanceFormatter != null && !distanceFormatter.equals(this.distanceFormatter)) {
            this.distanceFormatter = distanceFormatter;
        }
    }

    private void initialize() {
        this.initializeDistanceFormatter();
        SummaryBottomSheet.inflate((Context)this.getContext(), (int)R.layout.summary_bottomsheet_layout, (ViewGroup)this);
    }

    private void initializeDistanceFormatter() {
        LocaleUtils localeUtils = new LocaleUtils();
        String language = localeUtils.inferDeviceLanguage(this.getContext());
        String unitType = localeUtils.getUnitTypeForDeviceLocale(this.getContext());
        int roundingIncrement = 50;
        this.distanceFormatter = new DistanceFormatter(this.getContext(), language, unitType, roundingIncrement);
    }

    private void bind() {
        this.distanceRemainingText = (TextView)this.findViewById(R.id.distanceRemainingText);
        this.timeRemainingText = (TextView)this.findViewById(R.id.timeRemainingText);
        this.arrivalTimeText = (TextView)this.findViewById(R.id.arrivalTimeText);
        this.rerouteProgressBar = (ProgressBar)this.findViewById(R.id.rerouteProgressBar);
        this.updateRouteOverviewImage();
    }

    private void updateRouteOverviewImage() {
        ImageButton routeOverviewBtn = (ImageButton)this.findViewById(R.id.routeOverviewBtn);
        routeOverviewBtn.setImageDrawable(ThemeSwitcher.retrieveThemeOverviewDrawable(this.getContext()));
    }

    private void clearViews() {
        this.arrivalTimeText.setText((CharSequence)EMPTY_STRING);
        this.timeRemainingText.setText((CharSequence)EMPTY_STRING);
        this.distanceRemainingText.setText((CharSequence)EMPTY_STRING);
    }
}

