/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.route;

import android.content.Context;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsResponse;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewOptions;
import com.mapbox.services.android.navigation.ui.v5.route.DamerauLevenshteinAlgorithm;
import com.mapbox.services.android.navigation.ui.v5.route.OffRouteEvent;
import com.mapbox.services.android.navigation.ui.v5.route.ViewRouteListener;
import com.mapbox.services.android.navigation.v5.route.RouteFetcher;
import com.mapbox.services.android.navigation.v5.route.RouteListener;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import java.util.List;

public class ViewRouteFetcher
extends RouteFetcher
implements RouteListener {
    private static final int FIRST_ROUTE = 0;
    private static final int ONE_ROUTE = 1;
    private final ViewRouteListener listener;
    private RouteOptions routeOptions;
    private DirectionsRoute currentRoute;
    private Location location;

    public ViewRouteFetcher(Context context, String accessToken, ViewRouteListener listener) {
        super(context, accessToken);
        this.listener = listener;
        this.addRouteListener(this);
    }

    public void onResponseReceived(DirectionsResponse response, @Nullable RouteProgress routeProgress) {
        this.processRoute(response);
    }

    public void onErrorReceived(Throwable throwable) {
        this.listener.onRouteRequestError(throwable);
    }

    public void extractRouteOptions(NavigationViewOptions options) {
        this.extractRouteFromOptions(options);
    }

    public void fetchRouteFromOffRouteEvent(OffRouteEvent event) {
        if (OffRouteEvent.isValid(event)) {
            RouteProgress routeProgress = event.getRouteProgress();
            this.findRouteFromRouteProgress(this.location, routeProgress);
        }
    }

    public void updateLocation(@NonNull Location location) {
        this.location = location;
    }

    public void onDestroy() {
        this.cancelRouteCall();
    }

    private void extractRouteFromOptions(NavigationViewOptions options) {
        DirectionsRoute route = options.directionsRoute();
        this.cacheRouteOptions(route.routeOptions());
        this.updateCurrentRoute(route);
    }

    private void cacheRouteOptions(RouteOptions routeOptions) {
        this.routeOptions = routeOptions;
        this.cacheRouteDestination();
    }

    private void cacheRouteDestination() {
        boolean hasValidCoordinates;
        boolean bl = hasValidCoordinates = this.routeOptions != null && !this.routeOptions.coordinates().isEmpty();
        if (hasValidCoordinates) {
            List coordinates = this.routeOptions.coordinates();
            int destinationCoordinate = coordinates.size() - 1;
            Point destinationPoint = (Point)coordinates.get(destinationCoordinate);
            this.listener.onDestinationSet(destinationPoint);
        }
    }

    private void processRoute(@NonNull DirectionsResponse response) {
        if (this.isValidRoute(response)) {
            List routes = response.routes();
            DirectionsRoute bestRoute = (DirectionsRoute)routes.get(0);
            DirectionsRoute chosenRoute = this.currentRoute;
            if (this.isNavigationRunning(chosenRoute)) {
                bestRoute = this.obtainMostSimilarRoute(routes, bestRoute, chosenRoute);
            }
            this.updateCurrentRoute(bestRoute);
        }
    }

    private void updateCurrentRoute(DirectionsRoute currentRoute) {
        this.currentRoute = currentRoute;
        this.listener.onRouteUpdate(currentRoute);
    }

    private boolean isValidRoute(DirectionsResponse response) {
        return response != null && !response.routes().isEmpty();
    }

    private boolean isNavigationRunning(DirectionsRoute chosenRoute) {
        return chosenRoute != null;
    }

    private DirectionsRoute obtainMostSimilarRoute(List<DirectionsRoute> routes, DirectionsRoute currentBestRoute, DirectionsRoute chosenRoute) {
        DirectionsRoute mostSimilarRoute = currentBestRoute;
        if (routes.size() > 1) {
            mostSimilarRoute = this.findMostSimilarRoute(chosenRoute, routes);
        }
        return mostSimilarRoute;
    }

    private DirectionsRoute findMostSimilarRoute(DirectionsRoute chosenRoute, List<DirectionsRoute> routes) {
        int routeIndex = 0;
        String chosenRouteLegDescription = this.obtainRouteLegDescriptionFrom(chosenRoute);
        int minSimilarity = Integer.MAX_VALUE;
        for (int index = 0; index < routes.size(); ++index) {
            String routeLegDescription = this.obtainRouteLegDescriptionFrom(routes.get(index));
            int currentSimilarity = DamerauLevenshteinAlgorithm.execute(chosenRouteLegDescription, routeLegDescription);
            if (currentSimilarity >= minSimilarity) continue;
            minSimilarity = currentSimilarity;
            routeIndex = index;
        }
        return routes.get(routeIndex);
    }

    private String obtainRouteLegDescriptionFrom(DirectionsRoute route) {
        List routeLegs = route.legs();
        StringBuilder routeLegDescription = new StringBuilder();
        for (RouteLeg leg : routeLegs) {
            routeLegDescription.append(leg.summary());
        }
        return routeLegDescription.toString();
    }
}

