/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.route;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.StyleRes;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.route.MapRouteArrow;
import com.mapbox.services.android.navigation.ui.v5.route.MapRouteClickListener;
import com.mapbox.services.android.navigation.ui.v5.route.MapRouteLine;
import com.mapbox.services.android.navigation.ui.v5.route.MapRouteProgressChangeListener;
import com.mapbox.services.android.navigation.ui.v5.route.OnRouteSelectionChangeListener;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.routeprogress.ProgressChangeListener;
import java.util.ArrayList;
import java.util.List;

public class NavigationMapRoute
implements LifecycleObserver {
    @StyleRes
    private final int styleRes;
    private final String belowLayer;
    private final MapboxMap mapboxMap;
    private final MapView mapView;
    private MapRouteClickListener mapRouteClickListener;
    private MapRouteProgressChangeListener mapRouteProgressChangeListener;
    private boolean isMapClickListenerAdded = false;
    private MapView.OnDidFinishLoadingStyleListener didFinishLoadingStyleListener;
    private boolean isDidFinishLoadingStyleListenerAdded = false;
    private MapboxNavigation navigation;
    private MapRouteLine routeLine;
    private MapRouteArrow routeArrow;

    public NavigationMapRoute(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap) {
        this(null, mapView, mapboxMap, R.style.NavigationMapRoute);
    }

    public NavigationMapRoute(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @Nullable String belowLayer) {
        this(null, mapView, mapboxMap, R.style.NavigationMapRoute, belowLayer);
    }

    public NavigationMapRoute(@Nullable MapboxNavigation navigation, @NonNull MapView mapView, @NonNull MapboxMap mapboxMap) {
        this(navigation, mapView, mapboxMap, R.style.NavigationMapRoute);
    }

    public NavigationMapRoute(@Nullable MapboxNavigation navigation, @NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @Nullable String belowLayer) {
        this(navigation, mapView, mapboxMap, R.style.NavigationMapRoute, belowLayer);
    }

    public NavigationMapRoute(@Nullable MapboxNavigation navigation, @NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @StyleRes int styleRes) {
        this(navigation, mapView, mapboxMap, styleRes, null);
    }

    public NavigationMapRoute(@Nullable MapboxNavigation navigation, @NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @StyleRes int styleRes, @Nullable String belowLayer) {
        this.styleRes = styleRes;
        this.belowLayer = belowLayer;
        this.mapView = mapView;
        this.mapboxMap = mapboxMap;
        this.navigation = navigation;
        this.routeLine = new MapRouteLine(mapView.getContext(), mapboxMap, styleRes, belowLayer);
        this.routeArrow = new MapRouteArrow(mapView, mapboxMap, styleRes);
        this.mapRouteClickListener = new MapRouteClickListener(this.routeLine);
        this.mapRouteProgressChangeListener = new MapRouteProgressChangeListener(this.routeLine, this.routeArrow);
        this.initializeDidFinishLoadingStyleListener();
        this.addListeners();
    }

    NavigationMapRoute(@Nullable MapboxNavigation navigation, @NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @StyleRes int styleRes, @Nullable String belowLayer, MapRouteClickListener mapClickListener, MapView.OnDidFinishLoadingStyleListener didFinishLoadingStyleListener, MapRouteProgressChangeListener progressChangeListener) {
        this.styleRes = styleRes;
        this.belowLayer = belowLayer;
        this.mapView = mapView;
        this.mapboxMap = mapboxMap;
        this.navigation = navigation;
        this.mapRouteClickListener = mapClickListener;
        this.didFinishLoadingStyleListener = didFinishLoadingStyleListener;
        this.mapRouteProgressChangeListener = progressChangeListener;
        this.addListeners();
    }

    NavigationMapRoute(@Nullable MapboxNavigation navigation, @NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @StyleRes int styleRes, @Nullable String belowLayer, MapRouteClickListener mapClickListener, MapView.OnDidFinishLoadingStyleListener didFinishLoadingStyleListener, MapRouteProgressChangeListener progressChangeListener, MapRouteLine routeLine, MapRouteArrow routeArrow) {
        this.styleRes = styleRes;
        this.belowLayer = belowLayer;
        this.mapView = mapView;
        this.mapboxMap = mapboxMap;
        this.navigation = navigation;
        this.mapRouteClickListener = mapClickListener;
        this.didFinishLoadingStyleListener = didFinishLoadingStyleListener;
        this.mapRouteProgressChangeListener = progressChangeListener;
        this.routeLine = routeLine;
        this.routeArrow = routeArrow;
    }

    public void addRoute(DirectionsRoute directionsRoute) {
        ArrayList<DirectionsRoute> routes = new ArrayList<DirectionsRoute>();
        routes.add(directionsRoute);
        this.addRoutes(routes);
    }

    public void addRoutes(@NonNull @Size(min=1L) List<DirectionsRoute> directionsRoutes) {
        this.routeLine.draw(directionsRoutes);
    }

    @Deprecated
    public void removeRoute() {
        this.updateRouteVisibilityTo(false);
        this.updateRouteArrowVisibilityTo(false);
    }

    public void updateRouteVisibilityTo(boolean isVisible) {
        this.routeLine.updateVisibilityTo(isVisible);
        this.mapRouteProgressChangeListener.updateVisibility(isVisible);
    }

    public void updateRouteArrowVisibilityTo(boolean isVisible) {
        this.routeArrow.updateVisibilityTo(isVisible);
    }

    public void setOnRouteSelectionChangeListener(@Nullable OnRouteSelectionChangeListener onRouteSelectionChangeListener) {
        this.mapRouteClickListener.setOnRouteSelectionChangeListener(onRouteSelectionChangeListener);
    }

    public void showAlternativeRoutes(boolean alternativesVisible) {
        this.mapRouteClickListener.updateAlternativesVisible(alternativesVisible);
        this.routeLine.toggleAlternativeVisibilityWith(alternativesVisible);
    }

    public void addProgressChangeListener(MapboxNavigation navigation) {
        this.navigation = navigation;
        navigation.addProgressChangeListener((ProgressChangeListener)this.mapRouteProgressChangeListener);
    }

    public void removeProgressChangeListener(MapboxNavigation navigation) {
        if (navigation != null) {
            navigation.removeProgressChangeListener((ProgressChangeListener)this.mapRouteProgressChangeListener);
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void onStart() {
        this.addListeners();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onStop() {
        this.removeListeners();
    }

    private void initializeDidFinishLoadingStyleListener() {
        this.didFinishLoadingStyleListener = new MapView.OnDidFinishLoadingStyleListener(){

            public void onDidFinishLoadingStyle() {
                NavigationMapRoute.this.redraw();
            }
        };
    }

    private void addListeners() {
        if (!this.isMapClickListenerAdded) {
            this.mapboxMap.addOnMapClickListener((MapboxMap.OnMapClickListener)this.mapRouteClickListener);
            this.isMapClickListenerAdded = true;
        }
        if (this.navigation != null) {
            this.navigation.addProgressChangeListener((ProgressChangeListener)this.mapRouteProgressChangeListener);
        }
        if (!this.isDidFinishLoadingStyleListenerAdded) {
            this.mapView.addOnDidFinishLoadingStyleListener(this.didFinishLoadingStyleListener);
            this.isDidFinishLoadingStyleListenerAdded = true;
        }
    }

    private void removeListeners() {
        if (this.isMapClickListenerAdded) {
            this.mapboxMap.removeOnMapClickListener((MapboxMap.OnMapClickListener)this.mapRouteClickListener);
            this.isMapClickListenerAdded = false;
        }
        if (this.navigation != null) {
            this.navigation.removeProgressChangeListener((ProgressChangeListener)this.mapRouteProgressChangeListener);
        }
        if (this.isDidFinishLoadingStyleListenerAdded) {
            this.mapView.removeOnDidFinishLoadingStyleListener(this.didFinishLoadingStyleListener);
            this.isDidFinishLoadingStyleListenerAdded = false;
        }
    }

    private void redraw() {
        this.routeArrow = new MapRouteArrow(this.mapView, this.mapboxMap, this.styleRes);
        List<DirectionsRoute> routes = this.routeLine.retrieveDirectionsRoutes();
        boolean alternativesVisible = this.routeLine.retrieveAlternativesVisible();
        int primaryRouteIndex = this.routeLine.retrievePrimaryRouteIndex();
        boolean isVisible = this.routeLine.retrieveVisibility();
        this.buildNewRouteLine();
        this.routeLine.redraw(routes, alternativesVisible, primaryRouteIndex, isVisible);
    }

    private void buildNewRouteLine() {
        this.routeLine = new MapRouteLine(this.mapView.getContext(), this.mapboxMap, this.styleRes, this.belowLayer);
        this.mapboxMap.removeOnMapClickListener((MapboxMap.OnMapClickListener)this.mapRouteClickListener);
        this.mapRouteClickListener = new MapRouteClickListener(this.routeLine);
        this.mapboxMap.addOnMapClickListener((MapboxMap.OnMapClickListener)this.mapRouteClickListener);
        this.mapRouteProgressChangeListener = new MapRouteProgressChangeListener(this.routeLine, this.routeArrow);
    }
}

