/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.map;

import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.MultiLineString;
import com.mapbox.geojson.Point;
import com.mapbox.turf.TurfMeasurement;
import com.mapbox.turf.TurfMisc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

class WaynameFeatureFilter {
    private static final int FIRST = 0;
    private static final int ONE_FEATURE = 1;
    private static final int TWO_POINTS = 2;
    private static final double ZERO_METERS = 0.0;
    private static final double TEN = 10.0;
    private final List<Feature> queriedFeatures;
    private final Point currentPoint;
    private final LineString currentStepLineString;

    WaynameFeatureFilter(List<Feature> queriedFeatures, Location currentLocation, List<Point> currentStepPoints) {
        this.queriedFeatures = new ArrayList<Feature>(new HashSet<Feature>(queriedFeatures));
        this.currentPoint = Point.fromLngLat((double)currentLocation.getLongitude(), (double)currentLocation.getLatitude());
        this.currentStepLineString = LineString.fromLngLats(currentStepPoints);
    }

    @NonNull
    Feature filterFeatures() {
        return this.filterQueriedFeatures();
    }

    @NonNull
    private Feature filterQueriedFeatures() {
        Feature filteredFeature = this.queriedFeatures.get(0);
        if (this.queriedFeatures.size() == 1) {
            return filteredFeature;
        }
        double smallestUserDistanceToFeature = Double.POSITIVE_INFINITY;
        for (Feature feature : this.queriedFeatures) {
            Geometry featureGeometry = feature.geometry();
            if (featureGeometry == null) continue;
            List<Object> featureLineStrings = new ArrayList<LineString>();
            if (featureGeometry instanceof LineString) {
                featureLineStrings.add((LineString)featureGeometry);
            } else if (featureGeometry instanceof MultiLineString) {
                featureLineStrings = ((MultiLineString)featureGeometry).lineStrings();
            }
            for (LineString featureLineString : featureLineStrings) {
                double userDistanceToBehindFeature;
                LineString reversedFeatureLine;
                List currentStepCoordinates = this.currentStepLineString.coordinates();
                int stepCoordinatesSize = currentStepCoordinates.size();
                if (stepCoordinatesSize < 2) {
                    return filteredFeature;
                }
                int lastStepCoordinate = stepCoordinatesSize - 1;
                Point lastStepPoint = (Point)currentStepCoordinates.get(lastStepCoordinate);
                if (this.currentPoint.equals(lastStepPoint)) {
                    return filteredFeature;
                }
                List lineCoordinates = featureLineString.coordinates();
                int lineCoordinatesSize = lineCoordinates.size();
                if (lineCoordinatesSize < 2) {
                    return filteredFeature;
                }
                int lastLineCoordinate = lineCoordinatesSize - 1;
                Point lastLinePoint = (Point)lineCoordinates.get(lastLineCoordinate);
                if (this.currentPoint.equals(lastLinePoint)) {
                    return filteredFeature;
                }
                Point firstLinePoint = (Point)lineCoordinates.get(0);
                if (this.currentPoint.equals(firstLinePoint)) {
                    return filteredFeature;
                }
                LineString stepSliceFromCurrentPoint = TurfMisc.lineSlice((Point)this.currentPoint, (Point)lastStepPoint, (LineString)this.currentStepLineString);
                Point pointAheadUserOnStep = TurfMeasurement.along((LineString)stepSliceFromCurrentPoint, (double)10.0, (String)"metres");
                LineString currentAheadLine = reversedFeatureLine = this.reverseFeatureLineStringCoordinates(featureLineString);
                LineString currentBehindLine = featureLineString;
                Point currentDirectionAhead = firstLinePoint;
                Point currentDirectionBehind = lastLinePoint;
                double distanceCurrentFirst = this.calculateDistance(this.currentPoint, firstLinePoint);
                double distanceAheadFirst = this.calculateDistance(pointAheadUserOnStep, firstLinePoint);
                if (distanceAheadFirst >= distanceCurrentFirst) {
                    currentAheadLine = featureLineString;
                    currentBehindLine = reversedFeatureLine;
                    currentDirectionAhead = lastLinePoint;
                    currentDirectionBehind = firstLinePoint;
                }
                LineString sliceFromCurrentPoint = TurfMisc.lineSlice((Point)this.currentPoint, (Point)currentDirectionAhead, (LineString)currentAheadLine);
                Point pointAheadFeature = TurfMeasurement.along((LineString)sliceFromCurrentPoint, (double)10.0, (String)"metres");
                LineString reverseSliceFromCurrentPoint = TurfMisc.lineSlice((Point)this.currentPoint, (Point)currentDirectionBehind, (LineString)currentBehindLine);
                Point pointBehindFeature = TurfMeasurement.along((LineString)reverseSliceFromCurrentPoint, (double)10.0, (String)"metres");
                double userDistanceToAheadFeature = this.calculateDistance(pointAheadUserOnStep, pointAheadFeature);
                double minDistanceToFeature = Math.min(userDistanceToAheadFeature, userDistanceToBehindFeature = this.calculateDistance(pointAheadUserOnStep, pointBehindFeature));
                if (!(minDistanceToFeature < smallestUserDistanceToFeature)) continue;
                smallestUserDistanceToFeature = minDistanceToFeature;
                filteredFeature = feature;
            }
        }
        return filteredFeature;
    }

    private double calculateDistance(Point lhs, Point rhs) {
        if (lhs == null || rhs == null) {
            return Double.POSITIVE_INFINITY;
        }
        return TurfMeasurement.distance((Point)lhs, (Point)rhs);
    }

    @Nullable
    Point findPointFromCurrentPoint(Point currentPoint, LineString lineString) {
        List lineStringCoordinates = lineString.coordinates();
        int coordinateSize = lineStringCoordinates.size();
        if (coordinateSize < 2) {
            return null;
        }
        Point lastLinePoint = (Point)lineStringCoordinates.get(coordinateSize - 1);
        if (currentPoint == null || currentPoint.equals(lastLinePoint)) {
            return null;
        }
        LineString sliceFromCurrentPoint = TurfMisc.lineSlice((Point)currentPoint, (Point)lastLinePoint, (LineString)lineString);
        LineString meterSlice = TurfMisc.lineSliceAlong((LineString)sliceFromCurrentPoint, (double)0.0, (double)10.0, (String)"metres");
        List slicePoints = meterSlice.coordinates();
        if (slicePoints.isEmpty()) {
            return null;
        }
        return (Point)slicePoints.get(0);
    }

    @NonNull
    private LineString reverseFeatureLineStringCoordinates(LineString featureLineString) {
        ArrayList reversedFeatureCoordinates = new ArrayList(featureLineString.coordinates());
        Collections.reverse(reversedFeatureCoordinates);
        return LineString.fromLngLats(reversedFeatureCoordinates);
    }
}

