/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.map;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.ThemeSwitcher;

public class WayNameView
extends FrameLayout {
    private TextView wayNameText;

    public WayNameView(Context context) {
        super(context);
        this.initialize();
    }

    public WayNameView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize();
    }

    public WayNameView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize();
    }

    public void updateWayNameText(String wayNameText) {
        this.wayNameText.setText((CharSequence)wayNameText);
    }

    public String retrieveWayNameText() {
        return this.wayNameText.getText().toString();
    }

    public void updateVisibility(boolean isVisible) {
        int visibility;
        int n = visibility = isVisible ? 0 : 4;
        if (this.getVisibility() != visibility) {
            this.setVisibility(visibility);
        }
    }

    private void initialize() {
        WayNameView.inflate((Context)this.getContext(), (int)R.layout.wayname_view_layout, (ViewGroup)this);
        this.wayNameText = (TextView)this.findViewById(R.id.waynameText);
        Drawable waynameTextBackground = this.wayNameText.getBackground();
        this.initializeBackground(waynameTextBackground);
    }

    private void initializeBackground(Drawable waynameTextBackground) {
        if (Build.VERSION.SDK_INT < 21) {
            int navigationViewPrimaryColor = ThemeSwitcher.retrieveThemeColor(this.getContext(), R.attr.navigationViewPrimary);
            Drawable soundChipBackground = DrawableCompat.wrap((Drawable)waynameTextBackground).mutate();
            DrawableCompat.setTint((Drawable)soundChipBackground, (int)navigationViewPrimaryColor);
        }
    }
}

