/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.map;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.location.Location;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.AnyRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.LocationComponent;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.OnCameraTrackingChangedListener;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.plugins.annotation.SymbolManager;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.style.sources.VectorSource;
import com.mapbox.services.android.navigation.ui.v5.NavigationSnapshotReadyCallback;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.ThemeSwitcher;
import com.mapbox.services.android.navigation.ui.v5.camera.NavigationCamera;
import com.mapbox.services.android.navigation.ui.v5.map.MapBatteryMonitor;
import com.mapbox.services.android.navigation.ui.v5.map.MapFpsDelegate;
import com.mapbox.services.android.navigation.ui.v5.map.MapLayerInteractor;
import com.mapbox.services.android.navigation.ui.v5.map.MapPaddingAdjustor;
import com.mapbox.services.android.navigation.ui.v5.map.MapWayName;
import com.mapbox.services.android.navigation.ui.v5.map.MapWayNameChangedListener;
import com.mapbox.services.android.navigation.ui.v5.map.NavigationMapSettings;
import com.mapbox.services.android.navigation.ui.v5.map.NavigationMapboxMapInstanceState;
import com.mapbox.services.android.navigation.ui.v5.map.NavigationSymbolManager;
import com.mapbox.services.android.navigation.ui.v5.map.OnWayNameChangedListener;
import com.mapbox.services.android.navigation.ui.v5.map.WaynameFeatureFinder;
import com.mapbox.services.android.navigation.ui.v5.route.NavigationMapRoute;
import com.mapbox.services.android.navigation.ui.v5.route.OnRouteSelectionChangeListener;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class NavigationMapboxMap {
    static final String STREETS_LAYER_ID = "streetsLayer";
    private static final String MAPBOX_STREETS_V7_URL = "mapbox.mapbox-streets-v7";
    private static final String MAPBOX_STREETS_V8_URL = "mapbox.mapbox-streets-v8";
    private static final String STREETS_SOURCE_ID = "com.mapbox.services.android.navigation.streets";
    private static final String STREETS_V7_ROAD_LABEL = "road_label";
    private static final String STREETS_V8_ROAD_LABEL = "road";
    private static final String INCIDENTS_LAYER_ID = "closures";
    private static final String TRAFFIC_LAYER_ID = "traffic";
    private static final int[] ZERO_MAP_PADDING = new int[]{0, 0, 0, 0};
    private static final double NAVIGATION_MAXIMUM_MAP_ZOOM = 18.0;
    private final CopyOnWriteArrayList<OnWayNameChangedListener> onWayNameChangedListeners = new CopyOnWriteArrayList();
    private final MapWayNameChangedListener internalWayNameChangedListener = new MapWayNameChangedListener(this.onWayNameChangedListeners);
    private NavigationMapSettings settings = new NavigationMapSettings();
    private MapView mapView;
    private MapboxMap mapboxMap;
    private LocationComponent locationComponent;
    private MapPaddingAdjustor mapPaddingAdjustor;
    private NavigationSymbolManager navigationSymbolManager;
    private MapLayerInteractor layerInteractor;
    private NavigationMapRoute mapRoute;
    private NavigationCamera mapCamera;
    @Nullable
    private MapWayName mapWayName;
    @Nullable
    private MapFpsDelegate mapFpsDelegate;

    public NavigationMapboxMap(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap) {
        this.mapView = mapView;
        this.mapboxMap = mapboxMap;
        this.initializeLocationComponent(mapView, mapboxMap);
        this.initializeMapPaddingAdjustor(mapView, mapboxMap);
        this.initializeNavigationSymbolManager(mapView, mapboxMap);
        this.initializeMapLayerInteractor(mapboxMap);
        this.initializeRoute(mapView, mapboxMap);
        this.initializeCamera(mapboxMap);
    }

    NavigationMapboxMap(MapLayerInteractor layerInteractor) {
        this.layerInteractor = layerInteractor;
    }

    NavigationMapboxMap(LocationComponent locationComponent) {
        this.locationComponent = locationComponent;
    }

    NavigationMapboxMap(NavigationMapRoute mapRoute) {
        this.mapRoute = mapRoute;
    }

    NavigationMapboxMap(@NonNull MapWayName mapWayName, @NonNull MapFpsDelegate mapFpsDelegate) {
        this.mapWayName = mapWayName;
        this.mapFpsDelegate = mapFpsDelegate;
    }

    NavigationMapboxMap(@NonNull MapWayName mapWayName, @NonNull MapFpsDelegate mapFpsDelegate, NavigationMapRoute mapRoute, NavigationCamera mapCamera) {
        this.mapWayName = mapWayName;
        this.mapFpsDelegate = mapFpsDelegate;
        this.mapRoute = mapRoute;
        this.mapCamera = mapCamera;
    }

    NavigationMapboxMap(MapboxMap mapboxMap, MapLayerInteractor layerInteractor, MapPaddingAdjustor adjustor) {
        this.layerInteractor = layerInteractor;
        this.initializeWayName(mapboxMap, adjustor);
    }

    public void addMarker(Context context, Point position) {
        this.navigationSymbolManager.addMarkerFor(position);
    }

    public void clearMarkers() {
        this.navigationSymbolManager.removeAllMarkerSymbols();
    }

    public void updateLocation(Location location) {
        this.locationComponent.forceLocationUpdate(location);
        this.updateMapWayNameWithLocation(location);
    }

    public void updateMapFpsThrottle(int maxFpsThreshold) {
        if (this.mapFpsDelegate != null) {
            this.mapFpsDelegate.updateMaxFpsThreshold(maxFpsThreshold);
        } else {
            this.settings.updateMaxFps(maxFpsThreshold);
        }
    }

    public void updateMapFpsThrottleEnabled(boolean isEnabled) {
        if (this.mapFpsDelegate != null) {
            this.mapFpsDelegate.updateEnabled(isEnabled);
        } else {
            this.settings.updateMaxFpsEnabled(isEnabled);
        }
    }

    public void updateLocationLayerRenderMode(int renderMode) {
        this.locationComponent.setRenderMode(renderMode);
    }

    public void addProgressChangeListener(@NonNull MapboxNavigation navigation) {
        this.initializeWayName(this.mapboxMap, this.mapPaddingAdjustor);
        this.initializeFpsDelegate(this.mapView);
        this.mapRoute.addProgressChangeListener(navigation);
        this.mapCamera.addProgressChangeListener(navigation);
        this.mapWayName.addProgressChangeListener(navigation);
        this.mapFpsDelegate.addProgressChangeListener(navigation);
    }

    public void saveStateWith(String key, Bundle outState) {
        this.settings.updateCurrentPadding(this.mapPaddingAdjustor.retrieveCurrentPadding());
        this.settings.updateShouldUseDefaultPadding(this.mapPaddingAdjustor.isUsingDefault());
        this.settings.updateCameraTrackingMode(this.mapCamera.getCameraTrackingMode());
        NavigationMapboxMapInstanceState instanceState = new NavigationMapboxMapInstanceState(this.settings);
        outState.putParcelable(key, (Parcelable)instanceState);
    }

    public void restoreFrom(NavigationMapboxMapInstanceState instanceState) {
        this.settings = instanceState.retrieveSettings();
        this.restoreMapWith(this.settings);
    }

    public void drawRoute(@NonNull DirectionsRoute route) {
        this.mapRoute.addRoute(route);
    }

    public void drawRoutes(@NonNull List<DirectionsRoute> routes) {
        this.mapRoute.addRoutes(routes);
    }

    public void setOnRouteSelectionChangeListener(@NonNull OnRouteSelectionChangeListener listener) {
        this.mapRoute.setOnRouteSelectionChangeListener(listener);
    }

    public void showAlternativeRoutes(boolean alternativesVisible) {
        this.mapRoute.showAlternativeRoutes(alternativesVisible);
    }

    public void removeRoute() {
        this.mapRoute.removeRoute();
    }

    public NavigationCamera retrieveCamera() {
        return this.mapCamera;
    }

    public void updateCameraTrackingMode(int trackingMode) {
        this.mapCamera.updateCameraTrackingMode(trackingMode);
    }

    public void startCamera(@NonNull DirectionsRoute directionsRoute) {
        this.mapCamera.start(directionsRoute);
    }

    public void resumeCamera(@NonNull Location location) {
        this.mapCamera.resume(location);
    }

    public void resetCameraPositionWith(int trackingCameraMode) {
        this.mapCamera.resetCameraPositionWith(trackingCameraMode);
    }

    public void resetPadding() {
        this.mapPaddingAdjustor.resetPadding();
    }

    public void showRouteOverview(int[] padding) {
        this.mapPaddingAdjustor.updatePaddingWith(ZERO_MAP_PADDING);
        this.mapCamera.showRouteOverview(padding);
    }

    public void updateWaynameQueryMap(boolean isEnabled) {
        if (this.mapWayName != null) {
            this.mapWayName.updateWayNameQueryMap(isEnabled);
        } else {
            this.settings.updateWayNameEnabled(isEnabled);
        }
    }

    public void onStart() {
        this.mapCamera.onStart();
        this.mapRoute.onStart();
        this.handleWayNameOnStart();
        this.handleFpsOnStart();
    }

    public void onStop() {
        this.mapCamera.onStop();
        this.mapRoute.onStop();
        this.handleWayNameOnStop();
        this.handleFpsOnStop();
    }

    public void updateLocationVisibilityTo(boolean isVisible) {
        this.locationComponent.setLocationComponentEnabled(isVisible);
    }

    public MapboxMap retrieveMap() {
        return this.mapboxMap;
    }

    public void updateIncidentsVisibility(boolean isVisible) {
        this.layerInteractor.updateLayerVisibility(isVisible, INCIDENTS_LAYER_ID);
    }

    public boolean isIncidentsVisible() {
        return this.layerInteractor.isLayerVisible(INCIDENTS_LAYER_ID);
    }

    public void updateTrafficVisibility(boolean isVisible) {
        this.layerInteractor.updateLayerVisibility(isVisible, TRAFFIC_LAYER_ID);
    }

    public boolean isTrafficVisible() {
        return this.layerInteractor.isLayerVisible(TRAFFIC_LAYER_ID);
    }

    public void addOnCameraTrackingChangedListener(OnCameraTrackingChangedListener listener) {
        this.locationComponent.addOnCameraTrackingChangedListener(listener);
    }

    public void removeOnCameraTrackingChangedListener(OnCameraTrackingChangedListener listener) {
        this.locationComponent.removeOnCameraTrackingChangedListener(listener);
    }

    public boolean addOnWayNameChangedListener(OnWayNameChangedListener listener) {
        return this.onWayNameChangedListeners.add(listener);
    }

    public boolean removeOnWayNameChangedListener(OnWayNameChangedListener listener) {
        return this.onWayNameChangedListeners.remove(listener);
    }

    public void adjustLocationIconWith(int[] customPadding) {
        this.mapPaddingAdjustor.adjustLocationIconWith(customPadding);
    }

    public void takeScreenshot(NavigationSnapshotReadyCallback navigationSnapshotReadyCallback) {
        this.mapboxMap.snapshot((MapboxMap.SnapshotReadyCallback)navigationSnapshotReadyCallback);
    }

    @SuppressLint(value={"MissingPermission"})
    private void initializeLocationComponent(MapView mapView, MapboxMap map) {
        this.locationComponent = map.getLocationComponent();
        map.setMinZoomPreference(7.0);
        map.setMaxZoomPreference(18.0);
        Context context = mapView.getContext();
        int locationLayerStyleRes = this.findLayerStyleRes(context);
        LocationComponentOptions options = LocationComponentOptions.createFromAttributes((Context)context, (int)locationLayerStyleRes);
        this.locationComponent.activateLocationComponent(context, map.getStyle(), null, options);
        this.locationComponent.setLocationComponentEnabled(true);
    }

    private int findLayerStyleRes(Context context) {
        int locationLayerStyleRes = ThemeSwitcher.retrieveNavigationViewStyle(context, R.attr.navigationViewLocationLayerStyle);
        if (!this.isValid(locationLayerStyleRes)) {
            locationLayerStyleRes = R.style.NavigationLocationLayerStyle;
        }
        return locationLayerStyleRes;
    }

    private boolean isValid(@AnyRes int resId) {
        return resId != -1 && (resId & 0xFF000000) != 0 && (resId & 0xFF0000) != 0;
    }

    private void initializeMapPaddingAdjustor(MapView mapView, MapboxMap mapboxMap) {
        this.mapPaddingAdjustor = new MapPaddingAdjustor(mapView, mapboxMap);
    }

    private void initializeNavigationSymbolManager(MapView mapView, MapboxMap mapboxMap) {
        Bitmap markerBitmap = ThemeSwitcher.retrieveThemeMapMarker(mapView.getContext());
        mapboxMap.getStyle().addImage("mapbox-navigation-marker", markerBitmap);
        SymbolManager symbolManager = new SymbolManager(mapView, mapboxMap, mapboxMap.getStyle());
        this.navigationSymbolManager = new NavigationSymbolManager(symbolManager);
    }

    private void initializeMapLayerInteractor(MapboxMap mapboxMap) {
        this.layerInteractor = new MapLayerInteractor(mapboxMap);
    }

    private void initializeRoute(MapView mapView, MapboxMap map) {
        Context context = mapView.getContext();
        int routeStyleRes = ThemeSwitcher.retrieveNavigationViewStyle(context, R.attr.navigationViewRouteStyle);
        this.mapRoute = new NavigationMapRoute(null, mapView, map, routeStyleRes);
    }

    private void initializeCamera(MapboxMap map) {
        this.mapCamera = new NavigationCamera(map, this.locationComponent);
    }

    private void initializeWayName(MapboxMap mapboxMap, MapPaddingAdjustor paddingAdjustor) {
        if (this.mapWayName != null) {
            return;
        }
        this.initializeStreetsSource(mapboxMap);
        WaynameFeatureFinder featureFinder = new WaynameFeatureFinder(mapboxMap);
        this.mapWayName = new MapWayName(featureFinder, paddingAdjustor);
        this.mapWayName.updateWayNameQueryMap(this.settings.isMapWayNameEnabled());
        this.mapWayName.addOnWayNameChangedListener(this.internalWayNameChangedListener);
    }

    private void initializeStreetsSource(MapboxMap mapboxMap) {
        List sources = mapboxMap.getStyle().getSources();
        Source sourceV7 = this.findSourceByUrl(sources, MAPBOX_STREETS_V7_URL);
        Source sourceV8 = this.findSourceByUrl(sources, MAPBOX_STREETS_V8_URL);
        if (sourceV7 != null) {
            this.layerInteractor.addStreetsLayer(sourceV7.getId(), STREETS_V7_ROAD_LABEL);
        } else if (sourceV8 != null) {
            this.layerInteractor.addStreetsLayer(sourceV8.getId(), STREETS_V8_ROAD_LABEL);
        } else {
            VectorSource streetSource = new VectorSource(STREETS_SOURCE_ID, MAPBOX_STREETS_V8_URL);
            mapboxMap.getStyle().addSource((Source)streetSource);
            this.layerInteractor.addStreetsLayer(STREETS_SOURCE_ID, STREETS_V8_ROAD_LABEL);
        }
    }

    @Nullable
    private Source findSourceByUrl(List<Source> sources, String streetsUrl) {
        for (Source source : sources) {
            VectorSource vectorSource;
            String url;
            if (!(source instanceof VectorSource) || (url = (vectorSource = (VectorSource)source).getUrl()) == null || !url.contains(streetsUrl)) continue;
            return vectorSource;
        }
        return null;
    }

    private void initializeFpsDelegate(MapView mapView) {
        if (this.mapFpsDelegate != null) {
            return;
        }
        MapBatteryMonitor batteryMonitor = new MapBatteryMonitor();
        this.mapFpsDelegate = new MapFpsDelegate(mapView, batteryMonitor);
        this.mapFpsDelegate.updateEnabled(this.settings.isMaxFpsEnabled());
        this.mapFpsDelegate.updateMaxFpsThreshold(this.settings.retrieveMaxFps());
        this.addFpsListenersToCamera();
    }

    private void addFpsListenersToCamera() {
        this.mapCamera.addOnTrackingModeTransitionListener(this.mapFpsDelegate);
        this.mapCamera.addOnTrackingModeChangedListener(this.mapFpsDelegate);
    }

    private void removeFpsListenersFromCamera() {
        this.mapCamera.removeOnTrackingModeTransitionListener(this.mapFpsDelegate);
        this.mapCamera.removeOnTrackingModeChangedListener(this.mapFpsDelegate);
    }

    private void updateMapWayNameWithLocation(Location location) {
        if (this.mapWayName == null) {
            return;
        }
        LatLng latLng = new LatLng(location);
        PointF mapPoint = this.mapboxMap.getProjection().toScreenLocation(latLng);
        this.mapWayName.updateWayNameWithPoint(mapPoint);
    }

    private void restoreMapWith(NavigationMapSettings settings) {
        this.updateCameraTrackingMode(settings.retrieveCameraTrackingMode());
        if (settings.shouldUseDefaultPadding()) {
            this.mapPaddingAdjustor.updatePaddingWithDefault();
        } else {
            this.adjustLocationIconWith(settings.retrieveCurrentPadding());
        }
        if (this.mapWayName != null) {
            this.mapWayName.updateWayNameQueryMap(settings.isMapWayNameEnabled());
        }
        if (this.mapFpsDelegate != null) {
            this.mapFpsDelegate.updateMaxFpsThreshold(settings.retrieveMaxFps());
            this.mapFpsDelegate.updateEnabled(settings.isMaxFpsEnabled());
        }
    }

    private void handleWayNameOnStart() {
        if (this.mapWayName != null) {
            this.mapWayName.onStart();
            this.mapWayName.addOnWayNameChangedListener(this.internalWayNameChangedListener);
        }
    }

    private void handleFpsOnStart() {
        if (this.mapFpsDelegate != null) {
            this.mapFpsDelegate.onStart();
            this.addFpsListenersToCamera();
        }
    }

    private void handleWayNameOnStop() {
        if (this.mapWayName != null) {
            this.mapWayName.onStop();
            this.mapWayName.removeOnWayNameChangedListener(this.internalWayNameChangedListener);
        }
    }

    private void handleFpsOnStop() {
        if (this.mapFpsDelegate != null) {
            this.mapFpsDelegate.onStop();
            this.removeFpsListenersFromCamera();
        }
    }
}

