/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.map;

import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import java.util.List;

class MapLayerInteractor {
    private static final float DEFAULT_WIDTH = 20.0f;
    private static final int LAST_INDEX = 0;
    private final MapboxMap mapboxMap;

    MapLayerInteractor(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
    }

    void updateLayerVisibility(boolean isVisible, String layerIdentifier) {
        List layers = this.mapboxMap.getStyle().getLayers();
        this.updateLayerWithVisibility(layerIdentifier, layers, isVisible);
    }

    boolean isLayerVisible(String layerIdentifier) {
        List layers = this.mapboxMap.getStyle().getLayers();
        return this.findLayerVisibility(layerIdentifier, layers);
    }

    void addStreetsLayer(String sourceId, String sourceLayer) {
        LineLayer streetsLayer = new LineLayer("streetsLayer", sourceId).withProperties(new PropertyValue[]{PropertyFactory.lineWidth((Float)Float.valueOf(20.0f)), PropertyFactory.lineColor((int)-1)}).withSourceLayer(sourceLayer);
        this.mapboxMap.getStyle().addLayerAt((Layer)streetsLayer, 0);
    }

    private void updateLayerWithVisibility(String layerIdentifier, List<Layer> layers, boolean isVisible) {
        for (Layer layer : layers) {
            String sourceLayerId;
            if (!this.isValid(layer) || !(sourceLayerId = this.retrieveSourceLayerId(layer)).equals(layerIdentifier)) continue;
            layer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)(isVisible ? "visible" : "none"))});
        }
    }

    private boolean findLayerVisibility(String layerIdentifier, List<Layer> layers) {
        for (Layer layer : layers) {
            String sourceLayerId;
            if (!this.isValid(layer) || !(sourceLayerId = this.retrieveSourceLayerId(layer)).equals(layerIdentifier)) continue;
            return ((String)layer.getVisibility().value).equals("visible");
        }
        return false;
    }

    private boolean isValid(Layer layer) {
        return layer instanceof LineLayer || layer instanceof SymbolLayer;
    }

    private String retrieveSourceLayerId(Layer layer) {
        String sourceIdentifier = layer instanceof LineLayer ? ((LineLayer)layer).getSourceLayer() : ((SymbolLayer)layer).getSourceLayer();
        return sourceIdentifier;
    }
}

