/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.api.directions.v5.models.VoiceInstructions;
import com.mapbox.services.android.navigation.ui.v5.voice.VoiceInstructionLoader;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import java.util.ArrayList;

class VoiceInstructionCache {
    private static final int MAX_VOICE_INSTRUCTIONS_TO_CACHE = 10;
    private static final int VOICE_INSTRUCTIONS_TO_CACHE_THRESHOLD = 5;
    private final MapboxNavigation navigation;
    private final VoiceInstructionLoader voiceInstructionLoader;
    private int totalVoiceInstructions = 0;
    private int currentVoiceInstructionsCachedIndex = 0;
    private boolean isVoiceInstructionsToCacheThresholdReached = false;

    VoiceInstructionCache(MapboxNavigation navigation, VoiceInstructionLoader voiceInstructionLoader) {
        this.navigation = navigation;
        this.voiceInstructionLoader = voiceInstructionLoader;
    }

    void preCache(DirectionsRoute route) {
        this.totalVoiceInstructions = 0;
        this.currentVoiceInstructionsCachedIndex = 0;
        this.isVoiceInstructionsToCacheThresholdReached = false;
        for (int i = 0; i < route.legs().size(); ++i) {
            RouteLeg leg = (RouteLeg)route.legs().get(i);
            for (int j = 0; j < leg.steps().size(); ++j) {
                LegStep step = (LegStep)leg.steps().get(j);
                for (VoiceInstructions ignored : step.voiceInstructions()) {
                    ++this.totalVoiceInstructions;
                }
            }
        }
        ArrayList<String> voiceInstructionsToCache = new ArrayList<String>();
        for (int i = this.currentVoiceInstructionsCachedIndex; i < this.totalVoiceInstructions; ++i) {
            voiceInstructionsToCache.add(this.navigation.retrieveSsmlAnnouncementInstruction(i));
            ++this.currentVoiceInstructionsCachedIndex;
            if ((this.currentVoiceInstructionsCachedIndex + 1) % 10 == 0) break;
        }
        this.voiceInstructionLoader.cacheInstructions(voiceInstructionsToCache);
    }

    void cache() {
        if (this.isVoiceInstructionsToCacheThresholdReached) {
            this.isVoiceInstructionsToCacheThresholdReached = false;
            this.voiceInstructionLoader.evictVoiceInstructions();
            ArrayList<String> voiceInstructionsToCache = new ArrayList<String>();
            for (int i = this.currentVoiceInstructionsCachedIndex; i < this.totalVoiceInstructions; ++i) {
                voiceInstructionsToCache.add(this.navigation.retrieveSsmlAnnouncementInstruction(i));
                ++this.currentVoiceInstructionsCachedIndex;
                if ((this.currentVoiceInstructionsCachedIndex + 1) % 10 == 0) break;
            }
            this.voiceInstructionLoader.cacheInstructions(voiceInstructionsToCache);
        }
    }

    void update(int voiceInstructionsToAnnounce) {
        if (voiceInstructionsToAnnounce % 5 == 0) {
            this.isVoiceInstructionsToCacheThresholdReached = true;
        }
    }
}

